/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class LabeledTextChunk
extends Chunk {
    public LabeledTextChunk(ModuleBase module, ChunkHeader hdr, DataInputStream dstrm) {
        super(module, hdr, dstrm);
    }

    @Override
    public boolean readChunk(RepInfo info) throws IOException {
        WaveModule module = (WaveModule)this._module;
        long cuePointID = module.readUnsignedInt(this._dstream);
        long sampleLength = module.readUnsignedInt(this._dstream);
        long purposeID = module.readUnsignedInt(this._dstream);
        int country = module.readUnsignedShort(this._dstream);
        int language = module.readUnsignedShort(this._dstream);
        int dialect = module.readUnsignedShort(this._dstream);
        int codePage = module.readUnsignedShort(this._dstream);
        byte[] buf = new byte[(int)(this.bytesLeft - 20L)];
        ModuleBase.readByteBuf(this._dstream, buf, module);
        String text = new String(buf).trim();
        ArrayList<Property> plist = new ArrayList<Property>(10);
        plist.add(new Property("CuePointID", PropertyType.LONG, new Long(cuePointID)));
        plist.add(new Property("SampleLength", PropertyType.LONG, new Long(sampleLength)));
        plist.add(new Property("PurposeID", PropertyType.LONG, new Long(purposeID)));
        plist.add(new Property("Country", PropertyType.INTEGER, new Integer(country)));
        plist.add(new Property("Language", PropertyType.INTEGER, new Integer(language)));
        plist.add(new Property("Dialect", PropertyType.INTEGER, new Integer(dialect)));
        plist.add(new Property("CodePage", PropertyType.INTEGER, new Integer(codePage)));
        plist.add(new Property("Text", PropertyType.STRING, text));
        module.addLabeledText(new Property("LabeledTextItem", PropertyType.PROPERTY, PropertyArity.LIST, plist));
        return true;
    }
}

