/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import edu.harvard.hul.ois.jhove.module.wave.WaveStrings;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class MpegChunk
extends Chunk {
    public MpegChunk(ModuleBase module, ChunkHeader hdr, DataInputStream dstrm) {
        super(module, hdr, dstrm);
    }

    @Override
    public boolean readChunk(RepInfo info) throws IOException {
        WaveModule module = (WaveModule)this._module;
        int soundInformation = module.readUnsignedShort(this._dstream);
        int frameSize = module.readUnsignedShort(this._dstream);
        int ancillaryDataLength = module.readUnsignedShort(this._dstream);
        int ancillaryDataDef = module.readUnsignedShort(this._dstream);
        module.skipBytes(this._dstream, 4L, module);
        ArrayList<Property> propList = new ArrayList<Property>();
        propList.add(module.buildBitmaskProperty(soundInformation, "SoundInformation", WaveStrings.SOUND_INFORMATION_1, WaveStrings.SOUND_INFORMATION_0));
        propList.add(new Property("FrameSize", PropertyType.INTEGER, new Integer(frameSize)));
        propList.add(new Property("AncillaryDataLength", PropertyType.INTEGER, new Integer(ancillaryDataLength)));
        propList.add(module.buildBitmaskProperty(ancillaryDataDef, "AncillaryDataDef", WaveStrings.ANCILLARY_DEF_1, WaveStrings.ANCILLARY_DEF_0));
        module.addWaveProperty(new Property("MPEG", PropertyType.PROPERTY, PropertyArity.LIST, propList));
        return true;
    }
}

