/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.trans.KeyDefinitionSet;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceType;

public final class KeyPattern
extends Pattern {
    private StructuredQName keyName;
    private KeyDefinitionSet keySet;
    private Expression keyexp;

    public KeyPattern(StructuredQName keyName, Expression key) {
        this.keyName = keyName;
        this.keyexp = key;
    }

    public Pattern analyze(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.keyexp = visitor.typeCheck(this.keyexp, contextItemType);
        RoleLocator role = new RoleLocator(0, "key", 2, visitor.getConfiguration().getNamePool());
        this.keyexp = TypeChecker.staticTypeCheck(this.keyexp, SequenceType.ATOMIC_SEQUENCE, false, role, visitor);
        this.keySet = visitor.getExecutable().getKeyManager().getKeyDefinitionSet(this.keyName);
        return this;
    }

    public int getDependencies() {
        return this.keyexp.getDependencies();
    }

    public Iterator iterateSubExpressions() {
        return new MonoIterator(this.keyexp);
    }

    public void promote(PromotionOffer offer) throws XPathException {
        this.keyexp = this.keyexp.promote(offer);
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        if (this.keyexp == original) {
            this.keyexp = replacement;
            return true;
        }
        return false;
    }

    public int allocateSlots(ExpressionContext env, int nextFree, SlotManager stackFrame) {
        return ExpressionTool.allocateSlots(this.keyexp, nextFree, stackFrame);
    }

    public boolean matches(NodeInfo e, XPathContext context) throws XPathException {
        DocumentInfo doc;
        KeyDefinitionSet kds = this.keySet;
        if (kds == null) {
            kds = context.getController().getExecutable().getKeyManager().getKeyDefinitionSet(this.keyName);
        }
        if ((doc = e.getDocumentRoot()) == null) {
            return false;
        }
        KeyManager km4 = context.getController().getKeyManager();
        SequenceIterator iter = this.keyexp.iterate(context);
        block0: while (true) {
            NodeInfo n;
            Item it;
            if ((it = iter.next()) == null) {
                return false;
            }
            SequenceIterator nodes = km4.selectByKey(kds, doc, (AtomicValue)it, context);
            do {
                if ((n = (NodeInfo)nodes.next()) == null) continue block0;
            } while (!n.isSameNodeInfo(e));
            break;
        }
        return true;
    }

    public NodeTest getNodeTest() {
        return AnyNodeTest.getInstance();
    }
}

