/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph.compose;

import java.util.Set;
import java.util.function.Predicate;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphBase;
import org.apache.jena.util.IteratorCollection;
import org.apache.jena.util.iterator.ClosableIterator;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.FilterIterator;
import org.apache.jena.util.iterator.NiceIterator;

public abstract class CompositionBase
extends GraphBase {
    public static <T> Predicate<T> reject(ClosableIterator<? extends T> i) {
        Set suppress = IteratorCollection.iteratorToSet(i);
        return o -> !suppress.contains(o);
    }

    public static <T> ClosableIterator<T> butNot(ClosableIterator<T> a, ClosableIterator<? extends T> b) {
        return new FilterIterator<T>(CompositionBase.reject(b), a);
    }

    public static <T> ExtendedIterator<T> recording(final ClosableIterator<T> i, final Set<T> seen) {
        return new NiceIterator<T>(){

            @Override
            public void remove() {
                i.remove();
            }

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public T next() {
                Object x = i.next();
                seen.add(x);
                return x;
            }

            @Override
            public void close() {
                i.close();
            }
        };
    }

    public static ExtendedIterator<Triple> rejecting(ExtendedIterator<Triple> i, Set<Triple> seen) {
        return i.filterDrop(seen::contains);
    }

    public static ExtendedIterator<Triple> rejecting(ExtendedIterator<Triple> i, Graph seen) {
        return i.filterDrop(seen::contains);
    }

    public static <T> Predicate<T> ifIn(ClosableIterator<T> i) {
        Set<T> allow = IteratorCollection.iteratorToSet(i);
        return allow::contains;
    }

    public static Predicate<Triple> ifIn(Graph g2) {
        return g2::contains;
    }
}

