/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.warc;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jwat.common.ByteCountingPushBackInputStream;
import org.jwat.gzip.GzipEntry;
import org.jwat.gzip.GzipReader;
import org.jwat.warc.WarcReader;
import org.jwat.warc.WarcRecord;

public class WarcReaderCompressed
extends WarcReader {
    public static final int PUSHBACK_BUFFER_SIZE = 32;
    protected GzipReader reader;
    protected int bufferSize;
    protected GzipReader currentReader;
    protected GzipEntry currentEntry;
    protected long startOffset = -1L;

    public WarcReaderCompressed() {
        this.init();
    }

    public WarcReaderCompressed(GzipReader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("'reader' is null");
        }
        this.reader = reader;
        this.init();
    }

    public WarcReaderCompressed(GzipReader reader, int buffer_size) {
        if (reader == null) {
            throw new IllegalArgumentException("'reader' is null");
        }
        if (buffer_size <= 0) {
            throw new IllegalArgumentException("The 'buffer_size' is less than or equal to zero: " + buffer_size);
        }
        this.reader = reader;
        this.bufferSize = buffer_size;
        this.init();
    }

    @Override
    public boolean isCompressed() {
        return true;
    }

    @Override
    public void close() {
        if (this.currentRecord != null) {
            try {
                this.currentRecord.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.currentRecord = null;
        }
        if (this.reader != null) {
            this.startOffset = this.reader.getStartOffset();
            this.consumed = this.reader.getOffset();
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.reader = null;
        }
    }

    @Override
    protected void recordClosed() {
        if (this.currentEntry != null) {
            try {
                this.currentEntry.close();
                this.consumed += this.currentEntry.consumed;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        } else {
            throw new IllegalStateException("'currentEntry' is null, this should never happen!");
        }
        this.currentEntry = null;
    }

    @Override
    public long getStartOffset() {
        if (this.reader != null) {
            return this.reader.getStartOffset();
        }
        return this.startOffset;
    }

    @Override
    public long getOffset() {
        if (this.reader != null) {
            return this.reader.getOffset();
        }
        return this.consumed;
    }

    @Override
    public long getConsumed() {
        if (this.reader != null) {
            return this.reader.getOffset();
        }
        return this.consumed;
    }

    @Override
    public WarcRecord getNextRecord() throws IOException {
        if (this.currentRecord != null) {
            this.currentRecord.close();
        }
        if (this.reader == null) {
            throw new IllegalStateException("This reader has been initialized with an incompatible constructor, 'reader' is null");
        }
        this.currentRecord = null;
        this.currentReader = this.reader;
        this.currentEntry = this.reader.getNextEntry();
        if (this.currentEntry != null) {
            ByteCountingPushBackInputStream pbin = this.bufferSize > 0 ? new ByteCountingPushBackInputStream(new BufferedInputStream(this.currentEntry.getInputStream(), this.bufferSize), 32) : new ByteCountingPushBackInputStream(this.currentEntry.getInputStream(), 32);
            this.currentRecord = WarcRecord.parseRecord(pbin, this);
        }
        if (this.currentRecord != null) {
            this.startOffset = this.currentEntry.getStartOffset();
            this.currentRecord.header.startOffset = this.currentEntry.getStartOffset();
        }
        return this.currentRecord;
    }

    @Override
    public WarcRecord getNextRecordFrom(InputStream rin, long offset) throws IOException {
        if (this.currentRecord != null) {
            this.currentRecord.close();
        }
        if (this.reader != null) {
            throw new IllegalStateException("This reader has been initialized with an incompatible constructor, 'reader' is not null");
        }
        if (rin == null) {
            throw new IllegalArgumentException("The inputstream 'rin' is null");
        }
        if (offset < -1L) {
            throw new IllegalArgumentException("The 'offset' is less than -1: " + offset);
        }
        this.currentRecord = null;
        this.currentReader = new GzipReader(rin);
        this.currentEntry = this.currentReader.getNextEntry();
        if (this.currentEntry != null) {
            ByteCountingPushBackInputStream pbin = new ByteCountingPushBackInputStream(this.currentEntry.getInputStream(), 32);
            this.currentRecord = WarcRecord.parseRecord(pbin, this);
        }
        if (this.currentRecord != null) {
            this.startOffset = offset;
            this.currentRecord.header.startOffset = offset;
        }
        return this.currentRecord;
    }

    @Override
    public WarcRecord getNextRecordFrom(InputStream rin, long offset, int buffer_size) throws IOException {
        if (this.currentRecord != null) {
            this.currentRecord.close();
        }
        if (this.reader != null) {
            throw new IllegalStateException("This reader has been initialized with an incompatible constructor, 'reader' is not null");
        }
        if (rin == null) {
            throw new IllegalArgumentException("The inputstream 'rin' is null");
        }
        if (offset < -1L) {
            throw new IllegalArgumentException("The 'offset' is less than -1: " + offset);
        }
        if (buffer_size <= 0) {
            throw new IllegalArgumentException("The 'buffer_size' is less than or equal to zero: " + buffer_size);
        }
        this.currentRecord = null;
        this.currentReader = new GzipReader(rin);
        this.currentEntry = this.currentReader.getNextEntry();
        if (this.currentEntry != null) {
            ByteCountingPushBackInputStream pbin = new ByteCountingPushBackInputStream(new BufferedInputStream(this.currentEntry.getInputStream(), buffer_size), 32);
            this.currentRecord = WarcRecord.parseRecord(pbin, this);
        }
        if (this.currentRecord != null) {
            this.startOffset = offset;
            this.currentRecord.header.startOffset = offset;
        }
        return this.currentRecord;
    }
}

