/*
 * Decompiled with CFR 0.152.
 */
package com.mcgath.jhove.module.png;

import com.mcgath.jhove.module.png.GeneralTextChunk;
import com.mcgath.jhove.module.png.PNGException;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.RepInfo;

public class ItxtChunk
extends GeneralTextChunk {
    public ItxtChunk(int sig, long leng) {
        this.chunkType = sig;
        this.length = leng;
        this.ancillary = true;
        this.duplicateAllowed = true;
    }

    @Override
    public void processChunk(RepInfo info) throws Exception {
        String badchunk = "Bad iTXt chunk";
        this.processChunkCommon(info);
        int state = 0;
        int compressionFlag = 0;
        int compressionType = 0;
        String keyword = null;
        String translatedKeyword = null;
        String language = null;
        byte[] valueData = null;
        StringBuilder sb = new StringBuilder();
        int valueIdx = 0;
        int i = 0;
        while ((long)i < this.length) {
            int c = this.readUnsignedByte();
            switch (state) {
                case 0: {
                    if (c == 0) {
                        keyword = sb.toString();
                        state = 1;
                        break;
                    }
                    sb.append((char)c);
                    break;
                }
                case 1: {
                    compressionFlag = c;
                    state = 2;
                    break;
                }
                case 2: {
                    if (compressionFlag == 0) break;
                    compressionType = c;
                    if (compressionType != 0) {
                        ErrorMessage msg = new ErrorMessage("Unknown compression type " + compressionType + " in iTXt chunk");
                        info.setMessage((Message)msg);
                        info.setWellFormed(false);
                        throw new PNGException("Bad iTXt chunk");
                    }
                    state = 3;
                    sb = new StringBuilder();
                    break;
                }
                case 3: {
                    if (c != 0) break;
                    if (sb.length() > 0) {
                        language = sb.toString();
                    }
                    state = 4;
                    sb = new StringBuilder();
                    break;
                }
                case 4: {
                    if (c != 0) break;
                    if (sb.length() > 0) {
                        translatedKeyword = sb.toString();
                    }
                    state = 5;
                    valueData = new byte[(int)this.length - i];
                    break;
                }
                default: {
                    valueData[valueIdx++] = (byte)c;
                }
            }
            String value = compressionFlag != 0 ? this.inflateToText(valueData) : new String(valueData, "ISO-8859-1");
            this._module.addKeyword(keyword, translatedKeyword, value, language);
            ++i;
        }
    }
}

