/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.Codestream;
import edu.harvard.hul.ois.jhove.module.jpeg2000.CodestreamHeaderBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2HeaderBox;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class PaletteBox
extends JP2Box {
    public PaletteBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        if (!(this._parentBox instanceof JP2HeaderBox)) {
            this._repInfo.setMessage((Message)new ErrorMessage("Image Header Box in illegal context", this._module.getFilePos()));
            return false;
        }
        this.initBytesRead();
        int len = (int)this._boxHeader.getDataLength();
        long startNByte = this._module.getFilePos();
        int ne = this._module.readUnsignedShort(this._dstrm);
        if (ne < 1 || ne > 1024) {
            this._repInfo.setMessage((Message)new ErrorMessage("Palette must have 1 to 1024 entries", this._module.getFilePos()));
            this._repInfo.setValid(false);
        }
        Property[] subProp = new Property[4];
        subProp[0] = new Property("Entries", PropertyType.INTEGER, (Object)new Integer(ne));
        int nc = ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module);
        int bytesRead = 3;
        subProp[1] = new Property("Components", PropertyType.INTEGER, (Object)new Integer(nc));
        int[] bpc = new int[nc];
        boolean[] cmpsigned = new boolean[nc];
        for (int i = 0; i < nc; ++i) {
            int b = ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module);
            cmpsigned[i] = (b & 0x80) != 0;
            bpc[i] = (b & 0x7F) + 1;
        }
        bytesRead += nc;
        subProp[2] = new Property("BitDepth", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)bpc);
        if (ne > 1024 || ne < 1) {
            subProp[3] = new Property("Values", PropertyType.STRING, (Object)"Invalid");
        } else {
            Property[] cprop = new Property[nc];
            for (int i = 0; i < nc; ++i) {
                int[] c = new int[ne];
                for (int j = 0; j < ne; ++j) {
                    c[j] = ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module);
                }
                cprop[i] = new Property("Component", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)c);
            }
            subProp[3] = new Property("Values", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)cprop);
            bytesRead += nc * ne;
        }
        Property palProp = new Property("Palette", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)subProp);
        if (this._parentBox instanceof CodestreamHeaderBox) {
            Codestream cs = ((CodestreamHeaderBox)this._parentBox).getCodestream();
            cs.setPaletteProperty(palProp);
        } else {
            this._module.addProperty(palProp);
        }
        this._module.skipBytes(this._dstrm, (int)((long)len - (this._module.getFilePos() - startNByte)), this._module);
        this.finalizeBytesRead();
        return true;
    }

    @Override
    protected String getSelfPropName() {
        return "Palette Box";
    }
}

