/*
 * Decompiled with CFR 0.152.
 */
package com.mcgath.jhove.module.png;

import com.mcgath.jhove.module.png.PNGChunk;
import com.mcgath.jhove.module.png.PNGException;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;

public class SrgbChunk
extends PNGChunk {
    private static final String[] intents = new String[]{"Perceptual", "Relative colorimetric", "Saturation", "Absolute colorimetric"};

    public SrgbChunk(int sig, long leng) {
        this.chunkType = sig;
        this.length = leng;
        this.ancillary = true;
        this.duplicateAllowed = false;
    }

    @Override
    public void processChunk(RepInfo info) throws Exception {
        String badChunk = "Bad sRGB chunk";
        this.processChunkCommon(info);
        ErrorMessage msg = null;
        int colorIntent = 0;
        if (this._module.isPlteSeen()) {
            msg = new ErrorMessage("sRGB chunk not allowed after PLTE chunk");
        } else if (this._module.isIdatSeen()) {
            msg = new ErrorMessage("sRGB chunk not allowed after IDAT chunk");
        } else if (this._module.isChunkSeen(1766015824)) {
            msg = new ErrorMessage("iCCP and sRGB chunks are not allowed in the same file");
        } else if (this.length == 0L) {
            msg = new ErrorMessage("sRGB chunk too short");
        } else {
            colorIntent = this.readUnsignedByte();
            if (colorIntent > 3) {
                msg = new ErrorMessage("Invalid sRGB rendering intent: " + colorIntent);
            }
        }
        if (msg != null) {
            info.setMessage((Message)msg);
            info.setWellFormed(false);
            throw new PNGException("Bad sRGB chunk");
        }
        Property prop = new Property("SRGB rendering intent", PropertyType.STRING, (Object)intents[colorIntent]);
        info.setProperty(prop);
        int i = 0;
        while ((long)i < this.length - 1L) {
            this.readUnsignedByte();
            ++i;
        }
    }
}

