/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.geotiff11.tiffTests;

import org.opengis.cite.geotiff11.tiffTests.GeoKeysTests;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AsciiParamsTests
extends GeoKeysTests {
    String asciiParamsSet;

    @BeforeClass
    public void setUpAsciiParamsSet() {
        if (this.directory.hasTag(34737)) {
            this.asciiParamsSet = this.directory.getTag(34737).getValuesAsString().toString();
            this.asciiParamsSet = this.asciiParamsSet.replace("\\0", "\u0000");
        }
    }

    @Test(description="Ascii Params Tag Count Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyGeoAsciiParamsTagCount() throws Exception {
        if (this.keyEntrySet.contains(34737)) {
            Assert.assertTrue((boolean)this.directory.hasTag(34737), (String)"the GeoAsciiParamsTag SHALL contain the values of the key parameters of type = ASCII referenced by the GeoKeyDirectoryTag");
        } else {
            Assert.assertFalse((boolean)this.directory.hasTag(34737), (String)"if there is no key parameters of type = ASCII, it SHALL not be present");
        }
    }

    @Test(description="Ascii Params Tag Type Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyGeoAsciiParamsTagType() throws Exception {
        if (this.directory.hasTag(34737)) {
            Assert.assertTrue((this.directory.getTag(34737).getTypeValue() == 2 ? 1 : 0) != 0, (String)"the GeoAsciiParamsTag SHALL have type = ASCII");
        }
    }

    @Test(description="Ascii Params Tag NULLWrite Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyGeoAsciiParamsTagNULLWrite() throws Exception {
        if (this.asciiParamsSet == null) {
            return;
        }
        for (int i = 0; i < this.asciiParamsSet.length() - 1; ++i) {
            Assert.assertTrue((this.asciiParamsSet.charAt(i) != '\u0000' ? 1 : 0) != 0, (String)"NULL (ASCII code = 0) characters SHALL not be present in the string content written in the GeoAsciiParamsTag");
        }
        Assert.assertTrue((this.asciiParamsSet.charAt(this.asciiParamsSet.length() - 1) == '\u0000' ? 1 : 0) != 0, (String)"the string content written in the GeoAsciiParamsTag should end in NULL (ASCII code = 0) characters ");
    }

    String processFourthShortForAscii(int index, int keyLength) {
        int asciiIndex = (Integer)this.keyEntrySet.get(index + 3);
        Object value = "";
        int i = asciiIndex;
        while (true) {
            Assert.assertTrue((i < this.asciiParamsSet.length() ? 1 : 0) != 0);
            if (this.asciiParamsSet.charAt(i) == '|') break;
            value = (String)value + this.asciiParamsSet.charAt(i);
            ++i;
        }
        Assert.assertTrue((((String)value).length() == keyLength - 1 ? 1 : 0) != 0, (String)"the pipe character | in the GeoAsciiParamsTag SHALL be used as the character to terminate a string written in as ASCII tag");
        return value;
    }

    @Test(description="Ascii Params GTCitationGeoKey (1026) Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyGTCitationGeoKey() throws Exception {
        int index = this.getKeyIndex(1026);
        if (index == -1) {
            return;
        }
        int type = this.processSecondShort(index);
        int geoKey = this.processFirstShort(index);
        int keyLength = this.processThirdShort(index);
        String value = this.processFourthShortForAscii(index, keyLength);
        Assert.assertTrue((type == 34737 ? 1 : 0) != 0, (String)"the GeogLinearUnitSizeGeoKey SHALL have type = ASCII");
    }

    @Test(description="Ascii Params GeodeticCitationGeoKey (2049) Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyGeodeticCitationGeoKey() throws Exception {
        int index = this.getKeyIndex(2049);
        if (index == -1) {
            return;
        }
        int type = this.processSecondShort(index);
        int geoKey = this.processFirstShort(index);
        int keyLength = this.processThirdShort(index);
        String value = this.processFourthShortForAscii(index, keyLength);
        Assert.assertTrue((type == 34737 ? 1 : 0) != 0, (String)"the GeogLinearUnitSizeGeoKey SHALL have type = ASCII");
    }

    @Test(description="Ascii Params ProjectedCitationGeoKey (3073) Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyProjectedCitationGeoKey() throws Exception {
        int index = this.getKeyIndex(3073);
        if (index == -1) {
            return;
        }
        int type = this.processSecondShort(index);
        int geoKey = this.processFirstShort(index);
        int keyLength = this.processThirdShort(index);
        String value = this.processFourthShortForAscii(index, keyLength);
        Assert.assertTrue((type == 34737 ? 1 : 0) != 0, (String)"the GeogLinearUnitSizeGeoKey SHALL have type = ASCII");
    }

    @Test(description="Ascii Params VerticalCitationGeoKey (4097) Test", dependsOnGroups={"verifyGeoKeyDirectory"})
    public void verifyVerticalCitationGeoKey() throws Exception {
        int index = this.getKeyIndex(4097);
        if (index == -1) {
            return;
        }
        int type = this.processSecondShort(index);
        int geoKey = this.processFirstShort(index);
        int keyLength = this.processThirdShort(index);
        String value = this.processFourthShortForAscii(index, keyLength);
        Assert.assertTrue((type == 34737 ? 1 : 0) != 0, (String)"the GeogLinearUnitSizeGeoKey SHALL have type = ASCII");
    }
}

