/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19136.data.spatial;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.geotoolkit.geometry.GeneralEnvelope;
import org.geotoolkit.gml.xml.v321.EnvelopeType;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.xml.MarshallerPool;
import org.opengis.cite.geomatics.GeodesyUtils;
import org.opengis.cite.iso19136.data.DataFixture;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class EnvelopeTests
extends DataFixture {
    private static final QName GML_ENV = new QName("http://www.opengis.net/gml/3.2", "Envelope");
    List<Envelope> envelopes;

    @BeforeClass
    public void findEnvelopes() {
        Unmarshaller unmarshaller;
        this.envelopes = new ArrayList<Envelope>();
        try {
            MarshallerPool pool = new MarshallerPool("org.geotoolkit.gml.xml.v321");
            unmarshaller = pool.acquireUnmarshaller();
        }
        catch (JAXBException jxb) {
            throw new RuntimeException(jxb);
        }
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        try (FileInputStream gmlData = new FileInputStream(this.dataFile);){
            XMLStreamReader reader = factory.createXMLStreamReader(gmlData, "UTF-8");
            while (reader.hasNext()) {
                int eventType = reader.next();
                if (eventType != 1 || !reader.getName().equals(GML_ENV)) continue;
                JAXBElement result = (JAXBElement)unmarshaller.unmarshal(reader);
                EnvelopeType env = (EnvelopeType)result.getValue();
                if (null != env.getSrsName() && env.getSrsName().startsWith("http")) {
                    String crsRef = GeodesyUtils.getAbbreviatedCRSIdentifier((String)env.getSrsName());
                    GeneralEnvelope genEnv = new GeneralEnvelope(CRS.decode((String)crsRef));
                    double[] lowerPos = env.getLowerCorner().getCoordinate();
                    double[] upperPos = env.getUpperCorner().getCoordinate();
                    double[] coords = new double[lowerPos.length + upperPos.length];
                    System.arraycopy(lowerPos, 0, coords, 0, lowerPos.length);
                    System.arraycopy(upperPos, 0, coords, lowerPos.length, upperPos.length);
                    genEnv.setEnvelope(coords);
                    this.envelopes.add((Envelope)genEnv);
                    continue;
                }
                this.envelopes.add((Envelope)env);
            }
            reader.close();
        }
        catch (Exception x) {
            String errMsg = x.getMessage().replaceAll("[^\\x00-\\x7F]", "");
            throw new RuntimeException(errMsg);
        }
        Assert.assertFalse((boolean)this.envelopes.isEmpty(), (String)"gml:Envelope elements not found.");
    }

    @Test(description="See ISO 19136: 10.1.3.2")
    public void envelopeHasValidCRS() {
        for (int i = 0; i < this.envelopes.size(); ++i) {
            Envelope env = this.envelopes.get(i);
            CoordinateReferenceSystem crs = env.getCoordinateReferenceSystem();
            String srsName = "unknown";
            if (EnvelopeType.class.isInstance(env)) {
                EnvelopeType gmlEnv = (EnvelopeType)EnvelopeType.class.cast(env);
                srsName = gmlEnv.getSrsName();
            }
            Assert.assertNotNull((Object)crs, (String)String.format("//gml:Envelope[%d] has unknown CRS (srsName: %s)", i + 1, srsName));
        }
    }

    @Test(description="See ISO 19107: 6.4.3.2, 6.4.3.3")
    public void checkEnvelopePositions() {
        for (int i = 0; i < this.envelopes.size(); ++i) {
            Envelope env = this.envelopes.get(i);
            DirectPosition lowerCorner = env.getLowerCorner();
            Assert.assertNotNull((Object)lowerCorner, (String)String.format("//gml:Envelope[%d] has no lowerCorner.", i + 1));
            DirectPosition upperCorner = env.getUpperCorner();
            Assert.assertEquals((int)lowerCorner.getDimension(), (int)upperCorner.getDimension(), (String)String.format("//gml:Envelope[%d]: dimension of corner positions must be equal.", i + 1));
            if (null != env.getCoordinateReferenceSystem()) {
                Assert.assertEquals((int)lowerCorner.getDimension(), (int)env.getCoordinateReferenceSystem().getCoordinateSystem().getDimension(), (String)String.format("In //gml:Envelope[%d], dimension of lowerCorner does not match that of CRS.", i + 1));
            }
            for (int j = 0; j < lowerCorner.getDimension(); ++j) {
                Assert.assertTrue((lowerCorner.getOrdinate(j) < upperCorner.getOrdinate(j) ? 1 : 0) != 0, (String)String.format("//gml:Envelope[%d]: expected lowerCorner[%2$d] < upperCorner[%2$d] (%3$f < %4$f).", i + 1, j, lowerCorner.getOrdinate(j), upperCorner.getOrdinate(j)));
            }
        }
    }
}

