/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.extent;

import java.util.Date;
import java.util.logging.LogRecord;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.factory.FactoryNotFoundException;
import org.geotoolkit.internal.TemporalUtilities;
import org.geotoolkit.internal.referencing.ProxyForMetadata;
import org.geotoolkit.metadata.iso.MetadataEntity;
import org.geotoolkit.metadata.iso.extent.DefaultSpatialTemporalExtent;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.SpatialTemporalExtent;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.referencing.operation.TransformException;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Period;
import org.opengis.temporal.TemporalPrimitive;

@ThreadSafe
@XmlType(name="EX_TemporalExtent_Type")
@XmlRootElement(name="EX_TemporalExtent")
@XmlSeeAlso(value={DefaultSpatialTemporalExtent.class})
public class DefaultTemporalExtent
extends MetadataEntity
implements TemporalExtent {
    private static final long serialVersionUID = 3668140516657118045L;
    private long startTime = Long.MIN_VALUE;
    private long endTime = Long.MIN_VALUE;
    private TemporalPrimitive extent;
    private transient TemporalPrimitive cachedExtent;

    public DefaultTemporalExtent() {
    }

    public DefaultTemporalExtent(TemporalExtent temporalExtent) {
        super(temporalExtent);
    }

    public DefaultTemporalExtent(Envelope envelope) throws TransformException {
        ProxyForMetadata.getInstance().copy(envelope, this);
    }

    public DefaultTemporalExtent(Date date, Date date2) {
        this.setStartTime(date);
        this.setEndTime(date2);
    }

    public static DefaultTemporalExtent castOrCopy(TemporalExtent temporalExtent) {
        if (temporalExtent instanceof SpatialTemporalExtent) {
            return DefaultSpatialTemporalExtent.castOrCopy((SpatialTemporalExtent)temporalExtent);
        }
        return temporalExtent == null || temporalExtent instanceof DefaultTemporalExtent ? (DefaultTemporalExtent)temporalExtent : new DefaultTemporalExtent(temporalExtent);
    }

    private Date getTime(long l, boolean bl) {
        Instant instant;
        if (l != Long.MIN_VALUE) {
            return new Date(l);
        }
        TemporalPrimitive temporalPrimitive = this.extent;
        if (temporalPrimitive instanceof Instant) {
            instant = (Instant)temporalPrimitive;
        } else if (temporalPrimitive instanceof Period) {
            instant = bl ? ((Period)temporalPrimitive).getBeginning() : ((Period)temporalPrimitive).getEnding();
        } else {
            return null;
        }
        return instant.getPosition().getDate();
    }

    public synchronized Date getStartTime() {
        return this.getTime(this.startTime, true);
    }

    public synchronized void setStartTime(Date date) {
        this.checkWritePermission();
        this.cachedExtent = null;
        this.startTime = date != null ? date.getTime() : Long.MIN_VALUE;
    }

    public synchronized Date getEndTime() {
        return this.getTime(this.endTime, false);
    }

    public synchronized void setEndTime(Date date) {
        this.checkWritePermission();
        this.cachedExtent = null;
        this.endTime = date != null ? date.getTime() : Long.MIN_VALUE;
    }

    @Override
    @XmlElement(name="extent", required=true)
    public synchronized TemporalPrimitive getExtent() {
        TemporalPrimitive temporalPrimitive = this.extent;
        if (temporalPrimitive == null && (temporalPrimitive = this.cachedExtent) == null) {
            Date date;
            Date date2 = this.startTime != Long.MIN_VALUE ? new Date(this.startTime) : null;
            Date date3 = date = this.endTime != Long.MIN_VALUE ? new Date(this.endTime) : date2;
            if (date != null) {
                try {
                    temporalPrimitive = date2 == null || date2.equals(date) ? TemporalUtilities.createInstant((Date)date) : TemporalUtilities.createPeriod((Date)date2, (Date)date);
                    this.cachedExtent = temporalPrimitive;
                }
                catch (FactoryNotFoundException factoryNotFoundException) {
                    LogRecord logRecord = TemporalUtilities.createLog((FactoryNotFoundException)factoryNotFoundException);
                    logRecord.setSourceClassName(DefaultTemporalExtent.class.getCanonicalName());
                    logRecord.setSourceMethodName("getExtent");
                    logRecord.setLoggerName(LOGGER.getName());
                    LOGGER.log(logRecord);
                }
            }
        }
        return temporalPrimitive;
    }

    public synchronized void setExtent(TemporalPrimitive temporalPrimitive) {
        this.checkWritePermission();
        this.cachedExtent = null;
        this.extent = temporalPrimitive;
    }
}

