/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.measure;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Duration;
import javax.measure.quantity.Length;
import javax.measure.quantity.Quantity;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotoolkit.lang.Static;
import org.geotoolkit.measure.SexagesimalConverter;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Exceptions;
import org.geotoolkit.util.Strings;
import org.geotoolkit.util.XArrays;

public final class Units
extends Static {
    private static final double EPS = 1.0E-12;
    private static final String[] DEGREE_SUFFIXES = new String[]{"east", "west", "north", "south"};
    public static final Unit<Duration> MILLISECOND = SI.MetricPrefix.MILLI((Unit)SI.SECOND);
    public static final Unit<Angle> SEXAGESIMAL_DMS = NonSI.DEGREE_ANGLE.transform(SexagesimalConverter.FRACTIONAL.inverse()).asType(Angle.class);
    public static final Unit<Angle> DEGREE_MINUTE_SECOND = NonSI.DEGREE_ANGLE.transform(SexagesimalConverter.INTEGER.inverse()).asType(Angle.class);
    public static final Unit<Dimensionless> PPM = Unit.ONE.times(1.0E-6);
    private static final Map<Unit<?>, Unit<?>> COMMONS = new HashMap(48);

    private Units() {
    }

    public static boolean isTemporal(Unit<?> unit) {
        return unit != null && unit.toSI().equals((Object)SI.SECOND);
    }

    public static boolean isLinear(Unit<?> unit) {
        return unit != null && unit.toSI().equals((Object)SI.METRE);
    }

    public static boolean isAngular(Unit<?> unit) {
        return unit != null && unit.toSI().equals((Object)SI.RADIAN);
    }

    public static boolean isScale(Unit<?> unit) {
        return unit != null && unit.toSI().equals((Object)Unit.ONE);
    }

    public static boolean isPressure(Unit<?> unit) {
        return unit != null && unit.toSI().equals((Object)SI.PASCAL);
    }

    public static Unit<Duration> ensureTemporal(Unit<?> unit) throws IllegalArgumentException {
        if (unit != null && !Units.isTemporal(unit)) {
            throw new IllegalArgumentException(Errors.format(139, unit));
        }
        return unit;
    }

    public static Unit<Length> ensureLinear(Unit<?> unit) throws IllegalArgumentException {
        if (unit != null && !Units.isLinear(unit)) {
            throw new IllegalArgumentException(Errors.format(135, unit));
        }
        return unit;
    }

    public static Unit<Angle> ensureAngular(Unit<?> unit) throws IllegalArgumentException {
        if (unit != null && !Units.isAngular(unit)) {
            throw new IllegalArgumentException(Errors.format(128, unit));
        }
        return unit;
    }

    public static Unit<Dimensionless> ensureScale(Unit<?> unit) throws IllegalArgumentException {
        if (unit != null && !Units.isScale(unit)) {
            throw new IllegalArgumentException(Errors.format(138, unit));
        }
        return unit;
    }

    public static <A extends Quantity> Unit<A> multiply(Unit<A> unit, double d) {
        if (SI.RADIAN.equals(unit)) {
            if (Math.abs(d - Math.PI / 180) < 1.0E-12) {
                return NonSI.DEGREE_ANGLE;
            }
            if (Math.abs(d - 0.015707963267948967) < 1.0E-12) {
                return NonSI.GRADE;
            }
        }
        if (Math.abs(d - 1.0) > 1.0E-12) {
            long l = (long)d;
            unit = (double)l == d ? unit.times(l) : unit.times(d);
        }
        return Units.canonicalize(unit);
    }

    private static <A extends Quantity> Unit<A> canonicalize(Unit<A> unit) {
        Unit<?> unit2 = COMMONS.get(unit);
        if (unit2 != null) {
            return unit2;
        }
        return unit;
    }

    public static <A extends Quantity> double toStandardUnit(Unit<A> unit) {
        return Units.derivative(unit.getConverterTo(unit.toSI()), 0.0);
    }

    public static double derivative(UnitConverter unitConverter, double d) {
        return unitConverter.convert(d + 1.0) - unitConverter.convert(d);
    }

    public static Unit<?> valueOf(String string) throws IllegalArgumentException {
        Unit unit;
        String string2;
        if (string == null) {
            return null;
        }
        int n = (string = ((Object)Strings.toASCII(string.trim())).toString()).indexOf(58);
        if (n >= 0 && (string2 = string.substring(0, n).trim()).equalsIgnoreCase("EPSG")) {
            try {
                return Units.valueOfEPSG(Integer.parseInt(string.substring(n + 1).trim()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(Errors.format(73, "uom", string), numberFormatException);
            }
        }
        if (string.length() >= 3) {
            if (string.regionMatches(true, 0, "deg", 0, 3)) {
                if (string.length() == 3) {
                    return NonSI.DEGREE_ANGLE;
                }
                boolean bl = false;
                n = string.indexOf(32, 3);
                if (n < 0) {
                    n = string.indexOf(95, 3);
                }
                if (n >= 0) {
                    String string3 = string.substring(0, n).trim();
                    String string4 = string.substring(n + 1).trim();
                    if (!string3.isEmpty() && !string4.isEmpty()) {
                        if (XArrays.containsIgnoreCase(DEGREE_SUFFIXES, string4)) {
                            string = string3;
                        } else {
                            string = string3;
                            bl = Units.isCelsius(string4);
                        }
                    }
                }
                if (Units.equalsIgnorePlural(string, "degree")) {
                    return bl ? SI.CELSIUS : NonSI.DEGREE_ANGLE;
                }
            } else {
                if (Units.equalsIgnorePlural(string, "pixel")) {
                    return NonSI.PIXEL;
                }
                if (Units.equalsIgnorePlural(string, "decimal_degree")) {
                    return NonSI.DEGREE_ANGLE;
                }
                if (string.equalsIgnoreCase("rad") || Units.equalsIgnorePlural(string, "radian")) {
                    return SI.RADIAN;
                }
                if (Units.equalsIgnorePlural(string, "kilometer") || Units.equalsIgnorePlural(string, "kilometre")) {
                    return SI.KILOMETRE;
                }
                if (Units.equalsIgnorePlural(string, "meter") || Units.equalsIgnorePlural(string, "metre")) {
                    return SI.METRE;
                }
                if (Units.equalsIgnorePlural(string, "week")) {
                    return NonSI.WEEK;
                }
                if (Units.equalsIgnorePlural(string, "day")) {
                    return NonSI.DAY;
                }
                if (Units.equalsIgnorePlural(string, "hour")) {
                    return NonSI.HOUR;
                }
                if (Units.equalsIgnorePlural(string, "minute")) {
                    return NonSI.MINUTE;
                }
                if (Units.equalsIgnorePlural(string, "second")) {
                    return SI.SECOND;
                }
                if (string.equalsIgnoreCase("psu")) {
                    return Unit.ONE;
                }
                if (string.equalsIgnoreCase("level")) {
                    return Unit.ONE;
                }
                if (Units.isCelsius(string)) {
                    return SI.CELSIUS;
                }
            }
        } else {
            if (string.isEmpty()) {
                return Unit.ONE;
            }
            if (string.equals("\u00b0")) {
                return NonSI.DEGREE_ANGLE;
            }
        }
        try {
            unit = Unit.valueOf((CharSequence)string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw Exceptions.setMessage(illegalArgumentException, Errors.format(73, "uom", string), true);
        }
        return Units.canonicalize(unit);
    }

    private static boolean equalsIgnorePlural(String string, String string2) {
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        int n = string2.length();
        return string.length() == n + 1 && Character.toLowerCase(string.charAt(n)) == 's' && string.regionMatches(true, 0, string2, 0, n);
    }

    private static boolean isCelsius(String string) {
        return string.equalsIgnoreCase("Celsius") || string.equalsIgnoreCase("Celcius");
    }

    public static Unit<?> valueOfEPSG(int n) {
        switch (n) {
            case 9001: {
                return SI.METRE;
            }
            case 9002: {
                return NonSI.FOOT;
            }
            case 9030: {
                return NonSI.NAUTICAL_MILE;
            }
            case 9036: {
                return SI.KILOMETRE;
            }
            case 9101: {
                return SI.RADIAN;
            }
            case 9102: 
            case 9122: {
                return NonSI.DEGREE_ANGLE;
            }
            case 9103: {
                return NonSI.MINUTE_ANGLE;
            }
            case 9104: {
                return NonSI.SECOND_ANGLE;
            }
            case 9105: {
                return NonSI.GRADE;
            }
            case 9107: {
                return DEGREE_MINUTE_SECOND;
            }
            case 9108: {
                return DEGREE_MINUTE_SECOND;
            }
            case 9109: {
                return SI.MetricPrefix.MICRO((Unit)SI.RADIAN);
            }
            case 9110: {
                return SEXAGESIMAL_DMS;
            }
            case 9201: 
            case 9203: {
                return Unit.ONE;
            }
            case 9202: {
                return PPM;
            }
        }
        return null;
    }

    static {
        COMMONS.put(PPM, PPM);
        boolean bl = false;
        do {
            for (Field field : (bl ? NonSI.class : SI.class).getFields()) {
                Unit unit;
                Object object;
                int n = field.getModifiers();
                if (!Modifier.isStatic(n) || !Modifier.isFinal(n)) continue;
                try {
                    object = field.get(null);
                }
                catch (Exception exception) {
                    throw new AssertionError((Object)exception);
                }
                if (!(object instanceof Unit) || !Units.isLinear(unit = (Unit)object) && !Units.isAngular(unit) && !Units.isScale(unit)) continue;
                COMMONS.put(unit, unit);
            }
        } while (bl = !bl);
    }
}

