/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry;

import java.awt.geom.Rectangle2D;
import javax.measure.converter.ConversionException;
import javax.measure.unit.Unit;
import org.geotoolkit.display.shape.XRectangle2D;
import org.geotoolkit.geometry.AbstractDirectPosition;
import org.geotoolkit.geometry.ArrayEnvelope;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.geometry.GeneralEnvelope;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.math.XMath;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Strings;
import org.geotoolkit.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.RangeMeaning;

public abstract class AbstractEnvelope
implements Envelope {
    protected AbstractEnvelope() {
    }

    public static AbstractEnvelope castOrCopy(Envelope envelope) {
        if (envelope == null || envelope instanceof AbstractEnvelope) {
            return (AbstractEnvelope)envelope;
        }
        return new GeneralEnvelope(envelope);
    }

    static boolean equalsIgnoreMetadata(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, boolean bl) {
        return coordinateReferenceSystem == null || coordinateReferenceSystem2 == null || Utilities.deepEquals((Object)coordinateReferenceSystem, (Object)coordinateReferenceSystem2, (ComparisonMode)(bl ? ComparisonMode.DEBUG : ComparisonMode.IGNORE_METADATA));
    }

    static CoordinateReferenceSystem getCoordinateReferenceSystem(DirectPosition directPosition, DirectPosition directPosition2) throws MismatchedReferenceSystemException {
        CoordinateReferenceSystem coordinateReferenceSystem = directPosition.getCoordinateReferenceSystem();
        CoordinateReferenceSystem coordinateReferenceSystem2 = directPosition2.getCoordinateReferenceSystem();
        if (coordinateReferenceSystem == null) {
            return coordinateReferenceSystem2;
        }
        if (coordinateReferenceSystem2 != null && !coordinateReferenceSystem.equals(coordinateReferenceSystem2)) {
            throw new MismatchedReferenceSystemException(Errors.format((int)111));
        }
        return coordinateReferenceSystem;
    }

    static CoordinateSystemAxis getAxis(CoordinateReferenceSystem coordinateReferenceSystem, int n) {
        CoordinateSystem coordinateSystem;
        if (coordinateReferenceSystem != null && (coordinateSystem = coordinateReferenceSystem.getCoordinateSystem()) != null) {
            return coordinateSystem.getAxis(n);
        }
        return null;
    }

    static boolean isWrapAround(CoordinateReferenceSystem coordinateReferenceSystem, int n) {
        CoordinateSystemAxis coordinateSystemAxis = AbstractEnvelope.getAxis(coordinateReferenceSystem, n);
        return coordinateSystemAxis != null && RangeMeaning.WRAPAROUND.equals(coordinateSystemAxis.getRangeMeaning());
    }

    static double getSpan(CoordinateSystemAxis coordinateSystemAxis) {
        if (coordinateSystemAxis != null && RangeMeaning.WRAPAROUND.equals(coordinateSystemAxis.getRangeMeaning())) {
            return coordinateSystemAxis.getMaximumValue() - coordinateSystemAxis.getMinimumValue();
        }
        return Double.NaN;
    }

    static boolean isNegativeUnsafe(double d) {
        return (Double.doubleToRawLongBits(d) & Long.MIN_VALUE) != 0L;
    }

    @Override
    public DirectPosition getLowerCorner() {
        return new LowerCorner();
    }

    @Override
    public DirectPosition getUpperCorner() {
        return new UpperCorner();
    }

    public abstract double getLower(int var1) throws IndexOutOfBoundsException;

    public abstract double getUpper(int var1) throws IndexOutOfBoundsException;

    @Override
    public double getMinimum(int n) throws IndexOutOfBoundsException {
        double d = this.getLower(n);
        if (XMath.isNegative((double)(this.getUpper(n) - d))) {
            CoordinateSystemAxis coordinateSystemAxis = AbstractEnvelope.getAxis(this.getCoordinateReferenceSystem(), n);
            d = coordinateSystemAxis != null ? coordinateSystemAxis.getMinimumValue() : Double.NEGATIVE_INFINITY;
        }
        return d;
    }

    @Override
    public double getMaximum(int n) throws IndexOutOfBoundsException {
        double d = this.getUpper(n);
        if (XMath.isNegative((double)(d - this.getLower(n)))) {
            CoordinateSystemAxis coordinateSystemAxis = AbstractEnvelope.getAxis(this.getCoordinateReferenceSystem(), n);
            d = coordinateSystemAxis != null ? coordinateSystemAxis.getMaximumValue() : Double.POSITIVE_INFINITY;
        }
        return d;
    }

    public DirectPosition getMedian() {
        GeneralDirectPosition generalDirectPosition = new GeneralDirectPosition(this.getDimension());
        int n = generalDirectPosition.ordinates.length;
        while (--n >= 0) {
            generalDirectPosition.ordinates[n] = this.getMedian(n);
        }
        generalDirectPosition.setCoordinateReferenceSystem(this.getCoordinateReferenceSystem());
        return generalDirectPosition;
    }

    @Override
    public double getMedian(int n) throws IndexOutOfBoundsException {
        double d = this.getLower(n);
        double d2 = this.getUpper(n);
        double d3 = 0.5 * (d + d2);
        if (XMath.isNegative((double)(d2 - d))) {
            d3 = AbstractEnvelope.fixMedian(AbstractEnvelope.getAxis(this.getCoordinateReferenceSystem(), n), d3);
        }
        return d3;
    }

    static double fixMedian(CoordinateSystemAxis coordinateSystemAxis, double d) {
        if (coordinateSystemAxis != null && RangeMeaning.WRAPAROUND.equals(coordinateSystemAxis.getRangeMeaning())) {
            double d2 = coordinateSystemAxis.getMinimumValue();
            double d3 = coordinateSystemAxis.getMaximumValue();
            double d4 = d3 - d2;
            if (d4 > 0.0 && d4 != Double.POSITIVE_INFINITY) {
                return d + 0.5 * Math.copySign(d4, 0.5 * (d2 + d3) - d);
            }
        }
        return Double.NaN;
    }

    @Override
    public double getSpan(int n) {
        double d = this.getUpper(n) - this.getLower(n);
        if (XMath.isNegative((double)d)) {
            d = AbstractEnvelope.fixSpan(AbstractEnvelope.getAxis(this.getCoordinateReferenceSystem(), n), d);
        }
        return d;
    }

    static double fixSpan(CoordinateSystemAxis coordinateSystemAxis, double d) {
        double d2;
        if (coordinateSystemAxis != null && RangeMeaning.WRAPAROUND.equals(coordinateSystemAxis.getRangeMeaning()) && (d2 = coordinateSystemAxis.getMaximumValue() - coordinateSystemAxis.getMinimumValue()) > 0.0 && d2 != Double.POSITIVE_INFINITY && (d += d2) >= 0.0) {
            return d;
        }
        return Double.NaN;
    }

    public double getSpan(int n, Unit<?> unit) throws IndexOutOfBoundsException, ConversionException {
        Unit<?> unit2;
        double d = this.getSpan(n);
        CoordinateSystemAxis coordinateSystemAxis = AbstractEnvelope.getAxis(this.getCoordinateReferenceSystem(), n);
        if (coordinateSystemAxis != null && (unit2 = coordinateSystemAxis.getUnit()) != null) {
            d = unit2.getConverterToAny(unit).convert(d);
        }
        return d;
    }

    public boolean isEmpty() {
        int n = this.getDimension();
        if (n == 0) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            if (this.getSpan(i) > 0.0) continue;
            return true;
        }
        assert (!this.isNull()) : this;
        return false;
    }

    public boolean isNull() {
        int n = this.getDimension();
        for (int i = 0; i < n; ++i) {
            if (Double.isNaN(this.getLower(i)) && Double.isNaN(this.getUpper(i))) continue;
            return false;
        }
        assert (this.isEmpty()) : this;
        return true;
    }

    public boolean contains(DirectPosition directPosition) throws MismatchedDimensionException, AssertionError {
        ArgumentChecks.ensureNonNull((String)"position", (Object)directPosition);
        int n = this.getDimension();
        AbstractDirectPosition.ensureDimensionMatch("point", directPosition.getDimension(), n);
        assert (AbstractEnvelope.equalsIgnoreMetadata(this.getCoordinateReferenceSystem(), directPosition.getCoordinateReferenceSystem(), true)) : directPosition;
        for (int i = 0; i < n; ++i) {
            boolean bl;
            double d = directPosition.getOrdinate(i);
            double d2 = this.getLower(i);
            double d3 = this.getUpper(i);
            boolean bl2 = d >= d2;
            boolean bl3 = bl = d <= d3;
            if (bl2 & bl || bl2 | bl && XMath.isNegative((double)(d3 - d2))) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Envelope envelope, boolean bl) throws MismatchedDimensionException, AssertionError {
        ArgumentChecks.ensureNonNull((String)"envelope", (Object)envelope);
        int n = this.getDimension();
        AbstractDirectPosition.ensureDimensionMatch("envelope", envelope.getDimension(), n);
        assert (AbstractEnvelope.equalsIgnoreMetadata(this.getCoordinateReferenceSystem(), envelope.getCoordinateReferenceSystem(), true)) : envelope;
        DirectPosition directPosition = envelope.getLowerCorner();
        DirectPosition directPosition2 = envelope.getUpperCorner();
        for (int i = 0; i < n; ++i) {
            boolean bl2;
            boolean bl3;
            double d = this.getLower(i);
            double d2 = this.getUpper(i);
            double d3 = directPosition.getOrdinate(i);
            double d4 = directPosition2.getOrdinate(i);
            if (bl) {
                bl3 = d3 >= d;
                bl2 = d4 <= d2;
            } else {
                bl3 = d3 > d;
                boolean bl4 = bl2 = d4 < d2;
            }
            if (bl3 & bl2 ? !AbstractEnvelope.isNegativeUnsafe(d4 - d3) || AbstractEnvelope.isNegativeUnsafe(d2 - d) || d == Double.NEGATIVE_INFINITY && d2 == Double.POSITIVE_INFINITY || d2 - d >= AbstractEnvelope.getSpan(AbstractEnvelope.getAxis(this.getCoordinateReferenceSystem(), i)) : bl3 != bl2 && XMath.isNegative((double)(d2 - d)) && (XMath.isPositive((double)(d4 - d3)) || bl && Double.doubleToRawLongBits(d) == 0L && Double.doubleToRawLongBits(d2) == Long.MIN_VALUE)) continue;
            return false;
        }
        assert (envelope.getClass() == ArrayEnvelope.class || this.intersects(new ArrayEnvelope(envelope), bl)) : envelope;
        return true;
    }

    public boolean intersects(Envelope envelope, boolean bl) throws MismatchedDimensionException, AssertionError {
        ArgumentChecks.ensureNonNull((String)"envelope", (Object)envelope);
        int n = this.getDimension();
        AbstractDirectPosition.ensureDimensionMatch("envelope", envelope.getDimension(), n);
        assert (AbstractEnvelope.equalsIgnoreMetadata(this.getCoordinateReferenceSystem(), envelope.getCoordinateReferenceSystem(), true)) : envelope;
        DirectPosition directPosition = envelope.getLowerCorner();
        DirectPosition directPosition2 = envelope.getUpperCorner();
        for (int i = 0; i < n; ++i) {
            boolean bl2;
            boolean bl3;
            boolean bl4;
            boolean bl5;
            double d = this.getLower(i);
            double d2 = this.getUpper(i);
            double d3 = directPosition.getOrdinate(i);
            double d4 = directPosition2.getOrdinate(i);
            if (bl) {
                bl5 = d3 <= d2;
                bl4 = d4 >= d;
            } else {
                bl5 = d3 < d2;
                boolean bl6 = bl4 = d4 > d;
            }
            if (bl4 & bl5 || (bl3 = XMath.isNegative((double)(d2 - d))) | (bl2 = XMath.isNegative((double)(d4 - d3))) && bl3 & bl2 | (bl4 | bl5)) continue;
            assert (envelope.getClass() == ArrayEnvelope.class || AbstractEnvelope.hasNaN(envelope) || !this.contains(new ArrayEnvelope(envelope), bl)) : envelope;
            return false;
        }
        return true;
    }

    static boolean hasNaN(Envelope envelope) {
        return AbstractEnvelope.hasNaN(envelope.getLowerCorner()) || AbstractEnvelope.hasNaN(envelope.getUpperCorner());
    }

    static boolean hasNaN(DirectPosition directPosition) {
        int n = directPosition.getDimension();
        while (--n >= 0) {
            if (!Double.isNaN(directPosition.getOrdinate(n))) continue;
            return true;
        }
        return false;
    }

    public Rectangle2D toRectangle2D() throws IllegalStateException {
        int n = this.getDimension();
        if (n != 2) {
            throw new IllegalStateException(Errors.format((int)150, (Object)n));
        }
        return XRectangle2D.createFromExtremums(this.getMinimum(0), this.getMinimum(1), this.getMaximum(0), this.getMaximum(1));
    }

    public String toString() {
        return AbstractEnvelope.toString(this);
    }

    static String toString(Envelope envelope) {
        int n;
        int n2 = envelope.getDimension();
        DirectPosition directPosition = envelope.getLowerCorner();
        DirectPosition directPosition2 = envelope.getUpperCorner();
        StringBuilder stringBuilder = new StringBuilder("BOX").append(n2).append("D(");
        for (n = 0; n < n2; ++n) {
            if (n != 0) {
                stringBuilder.append(' ');
            }
            Strings.trimFractionalPart((StringBuilder)stringBuilder.append(directPosition.getOrdinate(n)));
        }
        stringBuilder.append(',');
        for (n = 0; n < n2; ++n) {
            Strings.trimFractionalPart((StringBuilder)stringBuilder.append(' ').append(directPosition2.getOrdinate(n)));
        }
        return stringBuilder.append(')').toString();
    }

    public int hashCode() {
        int n = this.getDimension();
        int n2 = 1;
        boolean bl = true;
        do {
            for (int i = 0; i < n; ++i) {
                long l = Double.doubleToLongBits(bl ? this.getLower(i) : this.getUpper(i));
                n2 = 31 * n2 + ((int)l ^ (int)(l >>> 32));
            }
        } while (!(bl = !bl));
        CoordinateReferenceSystem coordinateReferenceSystem = this.getCoordinateReferenceSystem();
        if (coordinateReferenceSystem != null) {
            n2 += coordinateReferenceSystem.hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            AbstractEnvelope abstractEnvelope = (AbstractEnvelope)object;
            int n = this.getDimension();
            if (n == abstractEnvelope.getDimension()) {
                for (int i = 0; i < n; ++i) {
                    if (Utilities.equals((double)this.getLower(i), (double)abstractEnvelope.getLower(i)) && Utilities.equals((double)this.getUpper(i), (double)abstractEnvelope.getUpper(i))) continue;
                    assert (!this.equals(abstractEnvelope, 0.0, false)) : this;
                    return false;
                }
                if (Utilities.equals((Object)this.getCoordinateReferenceSystem(), (Object)abstractEnvelope.getCoordinateReferenceSystem())) {
                    assert (this.hashCode() == abstractEnvelope.hashCode()) : this;
                    assert (this.equals(abstractEnvelope, 0.0, false)) : this;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean equals(Envelope envelope, double d, boolean bl) {
        ArgumentChecks.ensureNonNull((String)"envelope", (Object)envelope);
        int n = this.getDimension();
        if (envelope.getDimension() != n) {
            return false;
        }
        if (!AbstractEnvelope.equalsIgnoreMetadata(this.getCoordinateReferenceSystem(), envelope.getCoordinateReferenceSystem(), false)) {
            return false;
        }
        DirectPosition directPosition = envelope.getLowerCorner();
        DirectPosition directPosition2 = envelope.getUpperCorner();
        for (int i = 0; i < n; ++i) {
            double d2;
            double d3 = d;
            if (bl && (d2 = Math.max(this.getSpan(i), envelope.getSpan(i))) > 0.0 && d2 < Double.POSITIVE_INFINITY) {
                d3 *= d2;
            }
            if (InternalUtilities.epsilonEqual((double)this.getLower(i), (double)directPosition.getOrdinate(i), (double)d3) && InternalUtilities.epsilonEqual((double)this.getUpper(i), (double)directPosition2.getOrdinate(i), (double)d3)) continue;
            return false;
        }
        return true;
    }

    private final class UpperCorner
    extends Corner {
        private UpperCorner() {
        }

        @Override
        public double getOrdinate(int n) throws IndexOutOfBoundsException {
            return AbstractEnvelope.this.getUpper(n);
        }
    }

    private final class LowerCorner
    extends Corner {
        private LowerCorner() {
        }

        @Override
        public double getOrdinate(int n) throws IndexOutOfBoundsException {
            return AbstractEnvelope.this.getLower(n);
        }
    }

    private abstract class Corner
    extends AbstractDirectPosition {
        private Corner() {
        }

        @Override
        public CoordinateReferenceSystem getCoordinateReferenceSystem() {
            return AbstractEnvelope.this.getCoordinateReferenceSystem();
        }

        @Override
        public int getDimension() {
            return AbstractEnvelope.this.getDimension();
        }

        @Override
        public void setOrdinate(int n, double d) {
            throw new UnsupportedOperationException();
        }
    }
}

