/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.depend;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.depend.Dependency;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DependencyDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.ViewDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.compile.CreateViewNode;
import org.apache.derby.impl.sql.depend.BasicDependency;
import org.apache.derby.impl.sql.depend.BasicProviderInfo;

public class BasicDependencyManager
implements DependencyManager {
    private final DataDictionary dd;
    private final Map dependents = new HashMap();
    private final Map providers = new HashMap();
    private static final ProviderInfo[] EMPTY_PROVIDER_INFO = new ProviderInfo[0];

    public void addDependency(Dependent dependent, Provider provider, ContextManager contextManager) throws StandardException {
        this.addDependency(dependent, provider, contextManager, null);
    }

    private void addDependency(Dependent dependent, Provider provider, ContextManager contextManager, TransactionController transactionController) throws StandardException {
        if (!dependent.isPersistent() || !provider.isPersistent()) {
            this.addInMemoryDependency(dependent, provider, contextManager);
        } else {
            this.addStoredDependency(dependent, provider, contextManager, transactionController);
        }
    }

    private synchronized void addInMemoryDependency(Dependent dependent, Provider provider, ContextManager contextManager) throws StandardException {
        BasicDependency basicDependency = new BasicDependency(dependent, provider);
        boolean bl = false;
        boolean bl2 = false;
        bl = this.addDependencyToTable(this.dependents, dependent.getObjectID(), basicDependency);
        if (bl) {
            bl2 = this.addDependencyToTable(this.providers, provider.getObjectID(), basicDependency);
        }
        StatementContext statementContext = (StatementContext)contextManager.getContext("StatementContext");
        statementContext.addDependency(basicDependency);
    }

    private void addStoredDependency(Dependent dependent, Provider provider, ContextManager contextManager, TransactionController transactionController) throws StandardException {
        LanguageConnectionContext languageConnectionContext = this.getLanguageConnectionContext(contextManager);
        TransactionController transactionController2 = transactionController == null ? languageConnectionContext.getTransactionExecute() : transactionController;
        this.dd.addDescriptor(new DependencyDescriptor(dependent, provider), null, 6, true, transactionController2);
    }

    private void dropDependency(LanguageConnectionContext languageConnectionContext, Dependent dependent, Provider provider) throws StandardException {
        DependencyDescriptor dependencyDescriptor = new DependencyDescriptor(dependent, provider);
        this.dd.dropStoredDependency(dependencyDescriptor, languageConnectionContext.getTransactionExecute());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateFor(Provider provider, int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
        if (provider.isPersistent()) {
            this.coreInvalidateFor(provider, n, languageConnectionContext);
        } else {
            BasicDependencyManager basicDependencyManager = this;
            synchronized (basicDependencyManager) {
                this.coreInvalidateFor(provider, n, languageConnectionContext);
            }
        }
    }

    private void coreInvalidateFor(Provider provider, int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
        List list = this.getDependents(provider);
        if (list.isEmpty()) {
            return;
        }
        FormatableBitSet formatableBitSet = null;
        FormatableBitSet formatableBitSet2 = null;
        if (provider instanceof TableDescriptor && (formatableBitSet = ((TableDescriptor)provider).getReferencedColumnMap()) != null) {
            formatableBitSet2 = new FormatableBitSet(formatableBitSet.getLength());
        }
        StandardException standardException = null;
        for (int i = list.size() - 1; i >= 0; --i) {
            if (i >= list.size()) continue;
            Dependency dependency = (Dependency)list.get(i);
            Dependent dependent = dependency.getDependent();
            if (formatableBitSet != null) {
                TableDescriptor tableDescriptor = (TableDescriptor)dependency.getProvider();
                FormatableBitSet formatableBitSet3 = tableDescriptor.getReferencedColumnMap();
                if (formatableBitSet3 == null) {
                    if (dependent instanceof ViewDescriptor) {
                        ViewDescriptor viewDescriptor = (ViewDescriptor)dependent;
                        SchemaDescriptor schemaDescriptor = this.dd.getSchemaDescriptor(viewDescriptor.getCompSchemaId(), null);
                        CompilerContext compilerContext = languageConnectionContext.pushCompilerContext(schemaDescriptor);
                        Parser parser = compilerContext.getParser();
                        CreateViewNode createViewNode = (CreateViewNode)parser.parseStatement(viewDescriptor.getViewText());
                        compilerContext.setCurrentDependent(dependent);
                        createViewNode.bindStatement();
                        ProviderInfo[] providerInfoArray = createViewNode.getProviderInfo();
                        languageConnectionContext.popCompilerContext(compilerContext);
                        boolean bl = false;
                        for (int j = 0; j < providerInfoArray.length; ++j) {
                            TableDescriptor tableDescriptor2;
                            FormatableBitSet formatableBitSet4;
                            Provider provider2 = null;
                            provider2 = (Provider)providerInfoArray[j].getDependableFinder().getDependable(this.dd, providerInfoArray[j].getObjectId());
                            if (!(provider2 instanceof TableDescriptor) || (formatableBitSet4 = (tableDescriptor2 = (TableDescriptor)provider2).getReferencedColumnMap()) == null) continue;
                            tableDescriptor2.setReferencedColumnMap(null);
                            this.dropDependency(languageConnectionContext, viewDescriptor, tableDescriptor2);
                            tableDescriptor2.setReferencedColumnMap(formatableBitSet4);
                            this.addDependency(viewDescriptor, tableDescriptor2, languageConnectionContext.getContextManager());
                            if (!tableDescriptor2.getObjectID().equals(tableDescriptor.getObjectID())) continue;
                            System.arraycopy(formatableBitSet.getByteArray(), 0, formatableBitSet2.getByteArray(), 0, formatableBitSet.getLengthInBytes());
                            formatableBitSet2.and(formatableBitSet4);
                            if (formatableBitSet2.anySetBit() == -1) continue;
                            bl = true;
                            ((TableDescriptor)provider).setReferencedColumnMap(formatableBitSet2);
                        }
                        if (!bl) {
                            continue;
                        }
                    } else {
                        ((TableDescriptor)provider).setReferencedColumnMap(null);
                    }
                } else {
                    System.arraycopy(formatableBitSet.getByteArray(), 0, formatableBitSet2.getByteArray(), 0, formatableBitSet.getLengthInBytes());
                    formatableBitSet2.and(formatableBitSet3);
                    if (formatableBitSet2.anySetBit() == -1) continue;
                    ((TableDescriptor)provider).setReferencedColumnMap(formatableBitSet2);
                }
            }
            try {
                dependent.prepareToInvalidate(provider, n, languageConnectionContext);
            }
            catch (StandardException standardException2) {
                if (standardException == null) {
                    standardException = standardException2;
                }
                try {
                    standardException2.initCause(standardException);
                    standardException = standardException2;
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            if (standardException != null) continue;
            if (formatableBitSet != null) {
                ((TableDescriptor)provider).setReferencedColumnMap(formatableBitSet);
            }
            dependent.makeInvalid(n, languageConnectionContext);
        }
        if (standardException != null) {
            throw standardException;
        }
    }

    public void clearDependencies(LanguageConnectionContext languageConnectionContext, Dependent dependent) throws StandardException {
        this.clearDependencies(languageConnectionContext, dependent, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDependencies(LanguageConnectionContext languageConnectionContext, Dependent dependent, TransactionController transactionController) throws StandardException {
        UUID uUID = dependent.getObjectID();
        if (dependent.isPersistent()) {
            boolean bl = transactionController == null;
            this.dd.dropDependentsStoredDependencies(uUID, bl ? languageConnectionContext.getTransactionExecute() : transactionController, bl);
        }
        BasicDependencyManager basicDependencyManager = this;
        synchronized (basicDependencyManager) {
            List list = (List)this.dependents.get(uUID);
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Dependency dependency = (Dependency)iterator.next();
                    this.clearProviderDependency(dependency.getProviderKey(), dependency);
                }
                this.dependents.remove(uUID);
            }
        }
    }

    public synchronized void clearInMemoryDependency(Dependency dependency) {
        UUID uUID = dependency.getDependent().getObjectID();
        UUID uUID2 = dependency.getProviderKey();
        List list = (List)this.dependents.get(uUID);
        if (list == null) {
            return;
        }
        List list2 = (List)this.providers.get(uUID2);
        if (list2 == null) {
            return;
        }
        list.remove(dependency);
        if (list.isEmpty()) {
            this.dependents.remove(uUID);
        }
        list2.remove(dependency);
        if (list2.isEmpty()) {
            this.providers.remove(uUID2);
        }
    }

    public ProviderInfo[] getPersistentProviderInfos(Dependent dependent) throws StandardException {
        List list = this.getProviders(dependent);
        if (list.isEmpty()) {
            return EMPTY_PROVIDER_INFO;
        }
        Iterator iterator = list.iterator();
        ArrayList<BasicProviderInfo> arrayList = new ArrayList<BasicProviderInfo>();
        while (iterator.hasNext()) {
            Provider provider = (Provider)iterator.next();
            if (!provider.isPersistent()) continue;
            arrayList.add(new BasicProviderInfo(provider.getObjectID(), provider.getDependableFinder(), provider.getObjectName()));
        }
        return arrayList.toArray(EMPTY_PROVIDER_INFO);
    }

    public ProviderInfo[] getPersistentProviderInfos(ProviderList providerList) throws StandardException {
        Enumeration enumeration = providerList.elements();
        int n = 0;
        while (enumeration != null && enumeration.hasMoreElements()) {
            Provider provider = (Provider)enumeration.nextElement();
            if (!provider.isPersistent()) continue;
            ++n;
        }
        enumeration = providerList.elements();
        ProviderInfo[] providerInfoArray = new ProviderInfo[n];
        int n2 = 0;
        while (enumeration != null && enumeration.hasMoreElements()) {
            Provider provider = (Provider)enumeration.nextElement();
            if (!provider.isPersistent()) continue;
            providerInfoArray[n2++] = new BasicProviderInfo(provider.getObjectID(), provider.getDependableFinder(), provider.getObjectName());
        }
        return providerInfoArray;
    }

    public void clearColumnInfoInProviders(ProviderList providerList) throws StandardException {
        Enumeration enumeration = providerList.elements();
        while (enumeration.hasMoreElements()) {
            Provider provider = (Provider)enumeration.nextElement();
            if (!(provider instanceof TableDescriptor)) continue;
            ((TableDescriptor)provider).setReferencedColumnMap(null);
        }
    }

    public void copyDependencies(Dependent dependent, Dependent dependent2, boolean bl, ContextManager contextManager) throws StandardException {
        this.copyDependencies(dependent, dependent2, bl, contextManager, null);
    }

    public void copyDependencies(Dependent dependent, Dependent dependent2, boolean bl, ContextManager contextManager, TransactionController transactionController) throws StandardException {
        List list = this.getProviders(dependent);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Provider provider = (Provider)iterator.next();
            if (bl && !provider.isPersistent()) continue;
            this.addDependency(dependent2, provider, contextManager, transactionController);
        }
    }

    public String getActionString(int n) {
        switch (n) {
            case 12: {
                return "ALTER TABLE";
            }
            case 34: {
                return "RENAME";
            }
            case 41: {
                return "RENAME INDEX";
            }
            case 0: {
                return "COMPILE FAILED";
            }
            case 1: {
                return "DROP TABLE";
            }
            case 2: {
                return "DROP INDEX";
            }
            case 9: {
                return "DROP VIEW";
            }
            case 3: {
                return "CREATE INDEX";
            }
            case 4: {
                return "ROLLBACK";
            }
            case 5: {
                return "CHANGED CURSOR";
            }
            case 22: {
                return "CREATE CONSTRAINT";
            }
            case 19: {
                return "DROP CONSTRAINT";
            }
            case 6: {
                return "DROP ROUTINE";
            }
            case 11: {
                return "PREPARED STATEMENT RELEASE";
            }
            case 13: {
                return "DROP STORED PREPARED STATEMENT";
            }
            case 14: {
                return "USER REQUESTED INVALIDATION";
            }
            case 15: {
                return "BULK INSERT";
            }
            case 10: {
                return "CREATE_VIEW";
            }
            case 17: {
                return "DROP_JAR";
            }
            case 18: {
                return "REPLACE_JAR";
            }
            case 20: {
                return "SET_CONSTRAINTS_ENABLE";
            }
            case 21: {
                return "SET_CONSTRAINTS_DISABLE";
            }
            case 23: {
                return "INTERNAL RECOMPILE REQUEST";
            }
            case 28: {
                return "CREATE TRIGGER";
            }
            case 27: {
                return "DROP TRIGGER";
            }
            case 29: {
                return "SET TRIGGERS ENABLED";
            }
            case 30: {
                return "SET TRIGGERS DISABLED";
            }
            case 31: {
                return "MODIFY COLUMN DEFAULT";
            }
            case 33: {
                return "COMPRESS TABLE";
            }
            case 37: {
                return "DROP COLUMN";
            }
            case 46: {
                return "DROP COLUMN RESTRICT";
            }
            case 39: {
                return "DROP STATISTICS";
            }
            case 40: {
                return "UPDATE STATISTICS";
            }
            case 42: {
                return "TRUNCATE TABLE";
            }
            case 43: {
                return "DROP SYNONYM";
            }
            case 44: {
                return "REVOKE PRIVILEGE";
            }
            case 45: {
                return "REVOKE PRIVILEGE RESTRICT";
            }
            case 47: {
                return "REVOKE ROLE";
            }
            case 48: {
                return "RECHECK PRIVILEGES";
            }
            case 49: {
                return "DROP SEQUENCE";
            }
            case 50: {
                return "DROP TYPE";
            }
            case 51: {
                return "DROP DERBY AGGREGATE";
            }
        }
        return "UNKNOWN";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countDependencies() throws StandardException {
        List list = this.dd.getAllDependencyDescriptorsList();
        int n = list.size();
        BasicDependencyManager basicDependencyManager = this;
        synchronized (basicDependencyManager) {
            Iterator iterator = this.dependents.values().iterator();
            Iterator iterator2 = this.providers.values().iterator();
            while (iterator.hasNext()) {
                n += ((List)iterator.next()).size();
            }
            while (iterator2.hasNext()) {
                n += ((List)iterator2.next()).size();
            }
        }
        return n;
    }

    public BasicDependencyManager(DataDictionary dataDictionary) {
        this.dd = dataDictionary;
    }

    private boolean addDependencyToTable(Map map, Object object, Dependency dependency) {
        ArrayList<Dependency> arrayList = (ArrayList<Dependency>)map.get(object);
        if (arrayList == null) {
            arrayList = new ArrayList<Dependency>();
            arrayList.add(dependency);
            map.put(object, arrayList);
        } else {
            UUID uUID = dependency.getProvider().getObjectID();
            UUID uUID2 = dependency.getDependent().getObjectID();
            ListIterator listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                Dependency dependency2 = (Dependency)listIterator.next();
                if (!dependency2.getProvider().getObjectID().equals(uUID) || !dependency2.getDependent().getObjectID().equals(uUID2)) continue;
                return false;
            }
            arrayList.add(dependency);
        }
        return true;
    }

    private void clearProviderDependency(UUID uUID, Dependency dependency) {
        List list = (List)this.providers.get(uUID);
        if (list == null) {
            return;
        }
        list.remove(dependency);
        if (list.size() == 0) {
            this.providers.remove(uUID);
        }
    }

    private List getDependencyDescriptorList(List list, Provider provider) throws StandardException {
        if (list.size() != 0) {
            ListIterator<BasicDependency> listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                Provider provider2;
                DependableFinder dependableFinder = null;
                DependencyDescriptor dependencyDescriptor = (DependencyDescriptor)listIterator.next();
                dependableFinder = dependencyDescriptor.getDependentFinder();
                Dependent dependent = (Dependent)dependableFinder.getDependable(this.dd, dependencyDescriptor.getUUID());
                if (provider != null) {
                    provider2 = provider;
                } else {
                    dependableFinder = dependencyDescriptor.getProviderFinder();
                    provider2 = (Provider)dependableFinder.getDependable(this.dd, dependencyDescriptor.getProviderID());
                }
                listIterator.set(new BasicDependency(dependent, provider2));
            }
        }
        return list;
    }

    private LanguageConnectionContext getLanguageConnectionContext(ContextManager contextManager) {
        return (LanguageConnectionContext)contextManager.getContext("LanguageConnectionContext");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getProviders(Dependent dependent) throws StandardException {
        Object object;
        ArrayList<Provider> arrayList = new ArrayList<Provider>();
        Object object2 = this;
        synchronized (object2) {
            object = (List)this.dependents.get(dependent.getObjectID());
            if (object != null) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    arrayList.add(((Dependency)iterator.next()).getProvider());
                }
            }
        }
        if (dependent.isPersistent()) {
            object2 = this.getDependencyDescriptorList(this.dd.getDependentsDescriptorList(dependent.getObjectID().toString()), null);
            object = object2.iterator();
            while (object.hasNext()) {
                arrayList.add(((Dependency)object.next()).getProvider());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getDependents(Provider provider) throws StandardException {
        ArrayList arrayList = new ArrayList();
        Object object = this;
        synchronized (object) {
            List list = (List)this.providers.get(provider.getObjectID());
            if (list != null) {
                arrayList.addAll(list);
            }
        }
        if (provider.isPersistent()) {
            object = this.getDependencyDescriptorList(this.dd.getProvidersDescriptorList(provider.getObjectID().toString()), provider);
            arrayList.addAll(object);
        }
        return arrayList;
    }
}

