/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.converter;

import net.jcip.annotations.Immutable;
import org.geotoolkit.util.converter.FallbackConverter;
import org.geotoolkit.util.converter.ObjectConverter;

@Immutable
class ClassPair<S, T> {
    protected final Class<? super S> sourceClass;
    protected final Class<? extends T> targetClass;

    ClassPair(ObjectConverter<? super S, ? extends T> objectConverter) {
        this(objectConverter.getSourceClass(), objectConverter.getTargetClass());
    }

    ClassPair(Class<? super S> clazz, Class<? extends T> clazz2) {
        this.sourceClass = clazz;
        this.targetClass = clazz2;
    }

    public final ClassPair<? super S, T> parentSource() {
        Class<Object> clazz;
        if (this.sourceClass.isInterface()) {
            Class<?>[] classArray = this.sourceClass.getInterfaces();
            if (classArray.length == 0) {
                return null;
            }
            clazz = classArray[0];
        } else {
            clazz = this.sourceClass.getSuperclass();
            if (clazz == null) {
                return null;
            }
        }
        return new ClassPair<S, T>(clazz, this.targetClass);
    }

    final ObjectConverter<S, T> cast(ObjectConverter<?, ?> objectConverter) {
        if (objectConverter != null) {
            assert (objectConverter.getSourceClass().isAssignableFrom(this.sourceClass)) : this.sourceClass;
            assert (this.targetClass.isAssignableFrom(objectConverter.getTargetClass())) : this.targetClass;
        }
        return objectConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isDefining(ObjectConverter<?, ?> objectConverter) {
        if (objectConverter instanceof FallbackConverter) {
            ObjectConverter objectConverter2;
            ObjectConverter objectConverter3;
            FallbackConverter fallbackConverter;
            FallbackConverter fallbackConverter2 = fallbackConverter = (FallbackConverter)objectConverter;
            synchronized (fallbackConverter2) {
                objectConverter3 = fallbackConverter.converter(true);
                objectConverter2 = fallbackConverter.converter(false);
            }
            return this.isDefining(objectConverter3) || this.isDefining(objectConverter2);
        }
        return objectConverter.getSourceClass() == this.sourceClass && objectConverter.getTargetClass() == this.targetClass;
    }

    public final boolean equals(Object object) {
        if (object instanceof ClassPair) {
            ClassPair classPair = (ClassPair)object;
            return this.sourceClass == classPair.sourceClass && this.targetClass == classPair.targetClass;
        }
        return false;
    }

    public final int hashCode() {
        return this.sourceClass.hashCode() + 31 * this.targetClass.hashCode();
    }

    public String toString() {
        return this.sourceClass.getSimpleName() + "\u00a0\u21e8\u00a0" + this.targetClass.getSimpleName();
    }
}

