/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19136.data.spatial;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xerces.xs.XSElementDeclaration;
import org.geotoolkit.gml.xml.v321.AbstractGeometryType;
import org.geotoolkit.gml.xml.v321.LineStringType;
import org.geotoolkit.xml.MarshallerPool;
import org.opengis.cite.geomatics.gml.GmlUtils;
import org.opengis.cite.iso19136.data.DataFixture;
import org.opengis.cite.iso19136.data.spatial.GeometryAssert;
import org.opengis.cite.iso19136.util.TestSuiteLogger;
import org.opengis.cite.iso19136.util.XMLSchemaModelUtils;
import org.opengis.cite.iso19136.util.XMLUtils;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LineStringTests
extends DataFixture {
    NodeList lineNodes;
    List<QName> lineElems = new ArrayList<QName>();

    @BeforeClass(alwaysRun=true)
    public void findLineStrings() {
        StreamSource data = new StreamSource(this.dataFile);
        this.lineElems.add(new QName("http://www.opengis.net/gml/3.2", "LineString"));
        if (null != this.model) {
            XSElementDeclaration gmlCurve = this.model.getElementDeclaration("LineString", "http://www.opengis.net/gml/3.2");
            List<XSElementDeclaration> lineDecls = XMLSchemaModelUtils.getElementsByAffiliation(this.model, gmlCurve);
            for (XSElementDeclaration decl : lineDecls) {
                this.lineElems.add(new QName(decl.getNamespace(), decl.getName()));
            }
        }
        HashMap<String, String> namespaceBindings = new HashMap<String, String>();
        String xpath = this.generateXPathExpression(this.lineElems, namespaceBindings);
        try {
            this.lineNodes = (NodeList)XMLUtils.evaluateXPath(data, xpath, namespaceBindings, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        if (this.lineNodes.getLength() == 0) {
            throw new SkipException("No gml:Curve elements were found.");
        }
    }

    @Test(description="See ISO 19136: 9.10, 10.1.3.2; ISO 19107: 6.2.2.17")
    public void lineHasValidCRS() {
        for (int i = 0; i < this.lineNodes.getLength(); ++i) {
            Element geom = (Element)this.lineNodes.item(i);
            GeometryAssert.assertValidCRS(geom);
        }
    }

    @Test(description="See ISO 19136: 10.4.4")
    public void validLineString() {
        Unmarshaller gmlUnmarshaller;
        try {
            MarshallerPool pool = new MarshallerPool("org.geotoolkit.gml.xml.v321");
            gmlUnmarshaller = pool.acquireUnmarshaller();
        }
        catch (JAXBException jxe) {
            throw new RuntimeException(jxe);
        }
        for (int i = 0; i < this.lineNodes.getLength(); ++i) {
            LineStringType line;
            Element lineElem = (Element)this.lineNodes.item(i);
            GmlUtils.findCRSReference((Element)lineElem);
            GeometryAssert.assertAllCurveSegmentsHaveRequiredLength(lineElem);
            try {
                JAXBElement result = gmlUnmarshaller.unmarshal((Node)lineElem, LineStringType.class);
                line = (LineStringType)result.getValue();
            }
            catch (JAXBException e) {
                TestSuiteLogger.log(Level.WARNING, "Failed to unmarshal LineString geometry.", (Exception)((Object)e));
                continue;
            }
            GeometryAssert.assertGeometryCoveredByValidArea((AbstractGeometryType)line);
        }
    }
}

