/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.factory;

import java.awt.RenderingHints;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.converter.Classes;

final class SerializedKey
implements Serializable {
    private static final long serialVersionUID = -7330917618436040846L;
    private final Class<?> definer;
    private final String field;

    SerializedKey(RenderingHints.Key key) throws NotSerializableException {
        Field field = Hints.fieldOf(key);
        if (field == null) {
            throw new NotSerializableException(Errors.format(226, Classes.getShortClassName(key)));
        }
        this.definer = field.getDeclaringClass();
        this.field = field.getName();
    }

    protected Object readResolve() throws ObjectStreamException {
        try {
            return this.definer.getField(this.field).get(null);
        }
        catch (Exception exception) {
            InvalidClassException invalidClassException = new InvalidClassException(this.definer.getName(), Errors.format(84, this));
            invalidClassException.initCause(exception);
            throw invalidClassException;
        }
    }

    public String toString() {
        return this.definer.getCanonicalName() + '.' + this.field;
    }
}

