/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.collection;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.internal.ReferenceQueueConsumer;
import org.geotoolkit.internal.Threads;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Disposable;
import org.geotoolkit.util.collection.CacheEntries;
import org.geotoolkit.util.collection.XCollections;

@ThreadSafe
public class Cache<K, V>
extends AbstractMap<K, V> {
    private final ConcurrentMap<K, Object> map;
    @GuardedBy(value="costs")
    private final Map<K, Integer> costs;
    @GuardedBy(value="costs")
    private long totalCost;
    private final long costLimit;
    private final boolean soft;
    private volatile boolean keyCollisionAllowed;
    private transient Set<Map.Entry<K, V>> entries;

    public Cache() {
        this(12, 100L, false);
    }

    public Cache(int n, long l, boolean bl) {
        if (n < 1) {
            throw new IllegalArgumentException(Errors.format(73, "initialCapacity", n));
        }
        if (l < 0L) {
            throw new IllegalArgumentException(Errors.format(73, "costLimit", l));
        }
        n = XCollections.hashMapCapacity(n);
        this.map = new ConcurrentHashMap<K, Object>(n);
        this.costs = new LinkedHashMap<K, Integer>((int)Math.min((long)n, l), 0.75f, true);
        this.costLimit = l;
        this.soft = bl;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    static boolean isReservedType(Object object) {
        return object instanceof Handler || object instanceof Reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <V> V valueOf(Object object) {
        if (object instanceof Reference) {
            return (V)((Reference)object).get();
        }
        if (object instanceof Handler) {
            Handler handler = (Handler)object;
            ReentrantLock reentrantLock = (ReentrantLock)object;
            if (reentrantLock.isHeldByCurrentThread()) {
                return null;
            }
            reentrantLock.lock();
            try {
                Object v = handler.peek();
                return v;
            }
            finally {
                reentrantLock.unlock();
            }
        }
        return (V)object;
    }

    @Override
    public V put(K k, V v) {
        Object v2;
        if (Cache.isReservedType(v)) {
            throw new IllegalArgumentException(Errors.format(13, "value", v.getClass()));
        }
        if (v != null) {
            v2 = this.map.put(k, v);
            Threads.executeWork(new Strong(k, v));
        } else {
            v2 = this.map.remove(k);
        }
        return Cache.valueOf(v2);
    }

    @Override
    public V remove(Object object) {
        return Cache.valueOf(this.map.remove(object));
    }

    @Override
    public V get(Object object) {
        return Cache.valueOf(this.map.get(object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getOrCreate(K k, Callable<? extends V> callable) throws Exception {
        V v = this.peek(k);
        if (v == null) {
            Handler<V> handler = this.lock(k);
            try {
                v = handler.peek();
                if (v == null) {
                    v = callable.call();
                }
            }
            finally {
                handler.putAndUnlock(v);
            }
        }
        return v;
    }

    public V peek(K k) {
        Object v = this.map.get(k);
        if (v instanceof Handler) {
            return null;
        }
        if (v instanceof Reference) {
            Reference reference = (Reference)v;
            Object t = reference.get();
            if (t != null && this.map.replace(k, reference, t)) {
                reference.clear();
                Threads.executeWork(new Strong(k, t));
            }
            return (V)t;
        }
        Object v2 = v;
        return v2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Handler<V> lock(K k) {
        Object object;
        Object object2;
        Work work = new Work(k);
        work.lock();
        try {
            while (true) {
                if ((object2 = this.map.putIfAbsent(k, work)) == null) {
                    work.lock();
                    object = work;
                    return object;
                }
                if (!(object2 instanceof Reference)) {
                    break;
                }
                object = (Reference)object2;
                Object t = ((Reference)object).get();
                if (t != null) {
                    if (this.map.replace(k, object, t)) {
                        ((Reference)object).clear();
                        Threads.executeWork(new Strong(k, t));
                    }
                    Simple simple = new Simple(t);
                    return simple;
                }
                if (!this.map.replace(k, object, work)) continue;
                work.lock();
                Work work2 = work;
                return work2;
            }
        }
        finally {
            work.unlock();
        }
        if (object2 instanceof Handler) {
            object = (Work)object2;
            if (((ReentrantLock)object).isHeldByCurrentThread()) {
                if (this.isKeyCollisionAllowed()) {
                    return new Simple<Object>(null);
                }
                throw new IllegalStateException(Errors.format(193, k));
            }
            return (Work)object.new Work.Wait();
        }
        assert (object2 != null && !Cache.isReservedType(object2)) : object2;
        object = object2;
        return new Simple<Object>(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void adjustReferences(K k, V v) {
        int n = this.cost(v);
        Map<K, Integer> map = this.costs;
        synchronized (map) {
            Integer n2 = this.costs.put(k, n);
            if (n2 != null) {
                n -= n2.intValue();
            }
            if ((this.totalCost += (long)n) > this.costLimit) {
                Iterator<Map.Entry<K, Integer>> iterator = this.costs.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, Integer> entry = iterator.next();
                    K k2 = entry.getKey();
                    Object v2 = this.map.get(k2);
                    if (v2 != null && !Cache.isReservedType(v2)) {
                        Reference reference;
                        Reference reference2 = reference = this.soft ? new Soft(this.map, k2, v2) : new Weak(this.map, k2, v2);
                        if (!this.map.replace(k2, v2, reference)) {
                            reference.clear();
                        }
                    }
                    iterator.remove();
                    if ((this.totalCost -= (long)entry.getValue().intValue()) > this.costLimit) continue;
                    break;
                }
            }
        }
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> set = this.entries;
        return set != null ? set : (this.entries = new CacheEntries(this.map.entrySet()));
    }

    public boolean isKeyCollisionAllowed() {
        return this.keyCollisionAllowed;
    }

    public void setKeyCollisionAllowed(boolean bl) {
        this.keyCollisionAllowed = bl;
    }

    protected int cost(V v) {
        return 1;
    }

    private static final class Weak<K, V>
    extends WeakReference<V>
    implements Disposable {
        private final K key;
        private final ConcurrentMap<K, Object> map;

        Weak(ConcurrentMap<K, Object> concurrentMap, K k, V v) {
            super(v, ReferenceQueueConsumer.DEFAULT.queue);
            this.map = concurrentMap;
            this.key = k;
        }

        @Override
        public void dispose() {
            this.map.remove(this.key, this);
        }
    }

    private static final class Soft<K, V>
    extends SoftReference<V>
    implements Disposable {
        private final K key;
        private final ConcurrentMap<K, Object> map;

        Soft(ConcurrentMap<K, Object> concurrentMap, K k, V v) {
            super(v, ReferenceQueueConsumer.DEFAULT.queue);
            this.map = concurrentMap;
            this.key = k;
        }

        @Override
        public void dispose() {
            this.map.remove(this.key, this);
        }
    }

    final class Work
    extends ReentrantLock
    implements Handler<V>,
    Runnable {
        private final K key;
        private V value;

        Work(K k) {
            this.key = k;
        }

        final V get() {
            if (this.isHeldByCurrentThread()) {
                throw new IllegalStateException();
            }
            this.lock();
            Object v = this.value;
            this.unlock();
            return v;
        }

        @Override
        public V peek() {
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAndUnlock(V v) throws IllegalStateException {
            boolean bl;
            try {
                if (Cache.isReservedType(v)) {
                    throw new IllegalArgumentException(Errors.format(13, "result", v.getClass()));
                }
                this.value = v;
                bl = v != null ? Cache.this.map.replace(this.key, this, v) : Cache.this.map.remove(this.key, this);
            }
            finally {
                this.unlock();
            }
            if (bl) {
                Threads.executeWork(this);
            }
        }

        @Override
        public void run() {
            Object v = this.value;
            if (v != null) {
                Cache.this.adjustReferences(this.key, v);
            }
        }

        final class Wait
        implements Handler<V> {
            Wait() {
            }

            @Override
            public V peek() {
                return Work.this.get();
            }

            @Override
            public void putAndUnlock(V v) throws IllegalStateException {
                if (v != Work.this.get() && !Cache.this.isKeyCollisionAllowed()) {
                    throw new IllegalStateException("Key collision: the cache already has a value.");
                }
            }
        }
    }

    private final class Simple<V>
    implements Handler<V> {
        private final V value;

        Simple(V v) {
            this.value = v;
        }

        @Override
        public V peek() {
            return this.value;
        }

        @Override
        public void putAndUnlock(V v) throws IllegalStateException {
            if (v != this.value && !Cache.this.isKeyCollisionAllowed()) {
                throw new IllegalStateException("Key collision: the cache already has a value.");
            }
        }
    }

    public static interface Handler<V> {
        public V peek();

        public void putAndUnlock(V var1) throws IllegalStateException;
    }

    private final class Strong
    implements Runnable {
        private final K key;
        private final V value;

        Strong(K k, V v) {
            this.key = k;
            this.value = v;
        }

        @Override
        public void run() {
            Cache.this.adjustReferences(this.key, this.value);
        }
    }
}

