/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry;

import java.awt.geom.Rectangle2D;
import org.geotoolkit.geometry.AbstractDirectPosition;
import org.geotoolkit.geometry.AbstractEnvelope;
import org.geotoolkit.geometry.DirectPosition2D;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.math.XMath;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Cloneable;
import org.geotoolkit.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;

public class Envelope2D
extends Rectangle2D.Double
implements Envelope,
Cloneable {
    private static final long serialVersionUID = -3319231220761419350L;
    private CoordinateReferenceSystem crs;

    public Envelope2D() {
    }

    private Envelope2D(double d, double d2, double d3, double d4) {
        super(d, d2, d3 - d, d4 - d2);
    }

    private Envelope2D(CoordinateReferenceSystem coordinateReferenceSystem, DirectPosition directPosition, DirectPosition directPosition2) throws MismatchedReferenceSystemException {
        this(directPosition.getOrdinate(0), directPosition.getOrdinate(1), directPosition2.getOrdinate(0), directPosition2.getOrdinate(1));
        AbstractDirectPosition.checkCoordinateReferenceSystemDimension(coordinateReferenceSystem, 2);
        this.crs = coordinateReferenceSystem;
    }

    public Envelope2D(Envelope envelope) throws MismatchedDimensionException {
        this(envelope.getCoordinateReferenceSystem(), envelope.getLowerCorner(), envelope.getUpperCorner());
        int n = envelope.getDimension();
        if (n != 2) {
            throw new MismatchedDimensionException(Errors.format((int)150, (Object)n));
        }
    }

    public Envelope2D(GeographicBoundingBox geographicBoundingBox) {
        this(geographicBoundingBox.getWestBoundLongitude(), geographicBoundingBox.getSouthBoundLatitude(), geographicBoundingBox.getEastBoundLongitude(), geographicBoundingBox.getNorthBoundLatitude());
        this.crs = DefaultGeographicCRS.WGS84;
        if (Boolean.FALSE.equals(geographicBoundingBox.getInclusion())) {
            this.x += this.width;
            this.width = -this.width;
            if (!InternalUtilities.isPoleToPole((double)this.y, (double)(this.y + this.height))) {
                this.y += this.height;
                this.height = -this.height;
            }
        }
    }

    public Envelope2D(CoordinateReferenceSystem coordinateReferenceSystem, Rectangle2D rectangle2D) {
        super(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        AbstractDirectPosition.checkCoordinateReferenceSystemDimension(coordinateReferenceSystem, 2);
        this.crs = coordinateReferenceSystem;
    }

    public Envelope2D(CoordinateReferenceSystem coordinateReferenceSystem, double d, double d2, double d3, double d4) {
        super(d, d2, d3, d4);
        AbstractDirectPosition.checkCoordinateReferenceSystemDimension(coordinateReferenceSystem, 2);
        this.crs = coordinateReferenceSystem;
    }

    public Envelope2D(DirectPosition directPosition, DirectPosition directPosition2) throws MismatchedReferenceSystemException {
        this(AbstractEnvelope.getCoordinateReferenceSystem(directPosition, directPosition2), directPosition, directPosition2);
    }

    public void setEnvelope(Envelope envelope) throws MismatchedDimensionException {
        if (envelope != this) {
            int n = envelope.getDimension();
            if (n != 2) {
                throw new MismatchedDimensionException(Errors.format((int)150, (Object)n));
            }
            DirectPosition directPosition = envelope.getLowerCorner();
            DirectPosition directPosition2 = envelope.getUpperCorner();
            this.x = directPosition.getOrdinate(0);
            this.y = directPosition.getOrdinate(1);
            this.width = directPosition2.getOrdinate(0) - this.x;
            this.height = directPosition2.getOrdinate(1) - this.y;
            this.setCoordinateReferenceSystem(envelope.getCoordinateReferenceSystem());
        }
    }

    @Override
    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem coordinateReferenceSystem) {
        AbstractDirectPosition.checkCoordinateReferenceSystemDimension(coordinateReferenceSystem, 2);
        this.crs = coordinateReferenceSystem;
    }

    @Override
    public final int getDimension() {
        return 2;
    }

    @Override
    public DirectPosition2D getLowerCorner() {
        return new DirectPosition2D(this.crs, this.x, this.y);
    }

    @Override
    public DirectPosition2D getUpperCorner() {
        return new DirectPosition2D(this.crs, this.x + this.width, this.y + this.height);
    }

    private static IndexOutOfBoundsException indexOutOfBounds(int n) {
        return new IndexOutOfBoundsException(Errors.format((int)96, (Object)n));
    }

    @Override
    public double getMinimum(int n) throws IndexOutOfBoundsException {
        double d;
        double d2;
        switch (n) {
            case 0: {
                d2 = this.x;
                d = this.width;
                break;
            }
            case 1: {
                d2 = this.y;
                d = this.height;
                break;
            }
            default: {
                throw Envelope2D.indexOutOfBounds(n);
            }
        }
        if (XMath.isNegative((double)d)) {
            CoordinateSystemAxis coordinateSystemAxis = AbstractEnvelope.getAxis(this.crs, n);
            return coordinateSystemAxis != null ? coordinateSystemAxis.getMinimumValue() : Double.NEGATIVE_INFINITY;
        }
        return d2;
    }

    @Override
    public double getMaximum(int n) throws IndexOutOfBoundsException {
        double d;
        double d2;
        switch (n) {
            case 0: {
                d2 = this.x;
                d = this.width;
                break;
            }
            case 1: {
                d2 = this.y;
                d = this.height;
                break;
            }
            default: {
                throw Envelope2D.indexOutOfBounds(n);
            }
        }
        if (XMath.isNegative((double)d)) {
            CoordinateSystemAxis coordinateSystemAxis = AbstractEnvelope.getAxis(this.crs, n);
            return coordinateSystemAxis != null ? coordinateSystemAxis.getMaximumValue() : Double.POSITIVE_INFINITY;
        }
        return d2 + d;
    }

    @Override
    public double getMedian(int n) throws IndexOutOfBoundsException {
        double d;
        double d2;
        switch (n) {
            case 0: {
                d2 = this.x;
                d = this.width;
                break;
            }
            case 1: {
                d2 = this.y;
                d = this.height;
                break;
            }
            default: {
                throw Envelope2D.indexOutOfBounds(n);
            }
        }
        d2 += 0.5 * d;
        if (XMath.isNegative((double)d)) {
            d2 = AbstractEnvelope.fixMedian(AbstractEnvelope.getAxis(this.crs, n), d2);
        }
        return d2;
    }

    @Override
    public double getSpan(int n) throws IndexOutOfBoundsException {
        double d;
        switch (n) {
            case 0: {
                d = this.width;
                break;
            }
            case 1: {
                d = this.height;
                break;
            }
            default: {
                throw Envelope2D.indexOutOfBounds(n);
            }
        }
        if (XMath.isNegative((double)d)) {
            d = AbstractEnvelope.fixSpan(AbstractEnvelope.getAxis(this.crs, n), d);
        }
        return d;
    }

    @Override
    public double getMinX() {
        return this.getMinimum(0);
    }

    @Override
    public double getMinY() {
        return this.getMinimum(1);
    }

    @Override
    public double getMaxX() {
        return this.getMaximum(0);
    }

    @Override
    public double getMaxY() {
        return this.getMaximum(1);
    }

    @Override
    public double getCenterX() {
        return this.getMedian(0);
    }

    @Override
    public double getCenterY() {
        return this.getMedian(1);
    }

    @Override
    public double getWidth() {
        return this.getSpan(0);
    }

    @Override
    public double getHeight() {
        return this.getSpan(1);
    }

    @Override
    public boolean isEmpty() {
        return !(this.width > 0.0) && (!XMath.isNegative((double)this.width) || !AbstractEnvelope.isWrapAround(this.crs, 0)) || !(this.height > 0.0) && (!XMath.isNegative((double)this.height) || !AbstractEnvelope.isWrapAround(this.crs, 1));
    }

    @Override
    public boolean contains(double d, double d2) {
        boolean bl;
        boolean bl2 = d >= this.x;
        boolean bl3 = bl = d <= this.x + this.width;
        if (bl2 & bl || bl2 | bl && XMath.isNegative((double)this.width)) {
            bl2 = d2 >= this.y;
            bl = d2 <= this.y + this.height;
            return bl2 & bl || bl2 | bl && XMath.isNegative((double)this.height);
        }
        return false;
    }

    @Override
    public boolean contains(Rectangle2D rectangle2D) {
        if (rectangle2D instanceof Envelope2D) {
            Envelope2D envelope2D = (Envelope2D)rectangle2D;
            return this.contains(envelope2D.x, envelope2D.y, envelope2D.width, envelope2D.height);
        }
        return super.contains(rectangle2D);
    }

    @Override
    public boolean contains(double d, double d2, double d3, double d4) {
        for (int i = 0; i != 2; ++i) {
            boolean bl;
            double d5;
            double d6;
            double d7;
            double d8;
            if (i == 0) {
                d8 = this.x;
                d7 = this.width;
                d6 = d;
                d5 = d3;
            } else {
                d8 = this.y;
                d7 = this.height;
                d6 = d2;
                d5 = d4;
            }
            boolean bl2 = d6 >= d8;
            boolean bl3 = bl = d6 + d5 <= d8 + d7;
            if (bl2 & bl ? !AbstractEnvelope.isNegativeUnsafe(d5) || AbstractEnvelope.isNegativeUnsafe(d7) || d7 >= AbstractEnvelope.getSpan(AbstractEnvelope.getAxis(this.getCoordinateReferenceSystem(), i)) : bl2 != bl && XMath.isNegative((double)d7) && XMath.isPositive((double)d5)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean intersects(Rectangle2D rectangle2D) {
        if (rectangle2D instanceof Envelope2D) {
            Envelope2D envelope2D = (Envelope2D)rectangle2D;
            return this.intersects(envelope2D.x, envelope2D.y, envelope2D.width, envelope2D.height);
        }
        return super.contains(rectangle2D);
    }

    @Override
    public boolean intersects(double d, double d2, double d3, double d4) {
        for (int i = 0; i != 2; ++i) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            double d5;
            double d6;
            double d7;
            double d8;
            if (i == 0) {
                d8 = this.x;
                d7 = this.width;
                d6 = d;
                d5 = d3;
            } else {
                d8 = this.y;
                d7 = this.height;
                d6 = d2;
                d5 = d4;
            }
            boolean bl4 = d6 <= d8 + d7;
            boolean bl5 = bl3 = d6 + d5 >= d8;
            if (bl3 & bl4 || (bl2 = XMath.isNegative((double)d7)) | (bl = XMath.isNegative((double)d5)) && bl2 & bl | (bl3 | bl4)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Envelope2D createIntersection(Rectangle2D rectangle2D) {
        Envelope2D envelope2D = rectangle2D instanceof Envelope2D ? (Envelope2D)rectangle2D : null;
        Envelope2D envelope2D2 = new Envelope2D(this.crs, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        for (int i = 0; i != 2; ++i) {
            double d;
            double d2;
            double d3;
            double d4;
            if (i == 0) {
                d4 = this.x;
                d3 = this.width;
                d2 = rectangle2D.getX();
                d = envelope2D != null ? envelope2D.width : rectangle2D.getWidth();
            } else {
                d4 = this.y;
                d3 = this.height;
                d2 = rectangle2D.getY();
                d = envelope2D != null ? envelope2D.height : rectangle2D.getHeight();
            }
            double d5 = d4 + d3;
            double d6 = d2 + d;
            double d7 = Math.max(d4, d2);
            double d8 = Math.min(d5, d6);
            if (XMath.isSameSign((double)d3, (double)d)) {
                if ((d2 > d5 || d6 < d4) && !AbstractEnvelope.isNegativeUnsafe(d3)) {
                    continue;
                }
            } else {
                if (Double.isNaN(d3) || Double.isNaN(d)) continue;
                int n = 0;
                if (AbstractEnvelope.isNegativeUnsafe(d3)) {
                    if (d2 <= d5) {
                        d7 = d2;
                        n = 1;
                    }
                    if (d6 >= d4) {
                        d8 = d6;
                        n |= 2;
                    }
                } else {
                    if (d4 <= d6) {
                        d7 = d4;
                        n = 1;
                    }
                    if (d5 >= d2) {
                        d8 = d5;
                        n |= 2;
                    }
                }
                if (n == 0 || n == 3) {
                    double d9 = AbstractEnvelope.getSpan(AbstractEnvelope.getAxis(this.crs, i));
                    if (d >= d9) {
                        d7 = d4;
                        d8 = d5;
                    } else {
                        if (!(d3 >= d9)) continue;
                        d7 = d2;
                        d8 = d6;
                    }
                }
            }
            envelope2D2.setRange(i, d7, d8);
        }
        assert (envelope2D2.isEmpty() || this.contains(envelope2D2) && rectangle2D.contains(envelope2D2)) : envelope2D2;
        return envelope2D2;
    }

    @Override
    public Envelope2D createUnion(Rectangle2D rectangle2D) {
        Envelope2D envelope2D = (Envelope2D)this.clone();
        envelope2D.add(rectangle2D);
        assert (envelope2D.isEmpty() || envelope2D.contains(this) && envelope2D.contains(rectangle2D)) : envelope2D;
        return envelope2D;
    }

    @Override
    public void add(Rectangle2D rectangle2D) {
        Envelope2D envelope2D = rectangle2D instanceof Envelope2D ? (Envelope2D)rectangle2D : null;
        for (int i = 0; i != 2; ++i) {
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            if (i == 0) {
                d6 = this.x;
                d5 = this.width;
                d4 = rectangle2D.getX();
                d3 = envelope2D != null ? envelope2D.width : rectangle2D.getWidth();
                this.width = Double.NaN;
                this.x = Double.NaN;
            } else {
                d6 = this.y;
                d5 = this.height;
                d4 = rectangle2D.getY();
                d3 = envelope2D != null ? envelope2D.height : rectangle2D.getHeight();
                this.height = Double.NaN;
                this.y = Double.NaN;
            }
            double d7 = d6 + d5;
            double d8 = d4 + d3;
            double d9 = Math.min(d6, d4);
            double d10 = Math.max(d7, d8);
            boolean bl = XMath.isNegative((double)d5);
            boolean bl2 = XMath.isNegative((double)d3);
            if (bl == bl2) {
                if (bl && !AbstractEnvelope.isNegativeUnsafe(d10 - d9)) {
                    continue;
                }
            } else if (bl) {
                if (d8 <= d7 || d4 >= d6) {
                    d9 = d6;
                    d10 = d7;
                } else {
                    d2 = d4 - d7;
                    d = d6 - d8;
                    if (!(d2 > 0.0) && !(d > 0.0)) continue;
                    if (d2 > d) {
                        d9 = d4;
                        d10 = d7;
                    }
                    if (d > d2) {
                        d9 = d6;
                        d10 = d8;
                    }
                }
            } else if (d7 <= d8 || d6 >= d4) {
                d9 = d4;
                d10 = d8;
            } else {
                d2 = d6 - d8;
                d = d4 - d7;
                if (!(d2 > 0.0) && !(d > 0.0)) continue;
                if (d2 > d) {
                    d9 = d6;
                    d10 = d8;
                }
                if (d > d2) {
                    d9 = d4;
                    d10 = d7;
                }
            }
            this.setRange(i, d9, d10);
        }
    }

    private void setRange(int n, double d, double d2) throws IndexOutOfBoundsException {
        double d3 = d2 - d;
        switch (n) {
            case 0: {
                this.x = d;
                this.width = d3;
                break;
            }
            case 1: {
                this.y = d;
                this.height = d3;
                break;
            }
            default: {
                throw Envelope2D.indexOutOfBounds(n);
            }
        }
    }

    @Override
    public void add(double d, double d2) {
        double d3;
        double d4 = d - this.x;
        if (!XMath.isNegative((double)this.width)) {
            if (d4 < 0.0) {
                this.x = d;
                this.width -= d4;
            }
            if (d4 > this.width) {
                this.width = d4;
            }
        } else if (d4 < 0.0 && (d3 = this.width - d4) < 0.0) {
            if (d3 > d4) {
                this.width = d4;
            } else {
                this.x = d;
                this.width -= d4;
            }
        }
        d4 = d2 - this.y;
        if (!XMath.isNegative((double)this.height)) {
            if (d4 < 0.0) {
                this.y = d2;
                this.height -= d4;
            }
            if (d4 > this.height) {
                this.height = d4;
            }
        } else if (d4 < 0.0 && (d3 = this.height - d4) < 0.0) {
            if (d3 > d4) {
                this.height = d4;
            } else {
                this.y = d2;
                this.height -= d4;
            }
        }
        assert (this.contains(d, d2) || this.isEmpty() || Double.isNaN(d) || Double.isNaN(d2));
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Envelope2D) {
            Envelope2D envelope2D = (Envelope2D)object;
            return Utilities.equals((double)this.x, (double)envelope2D.x) && Utilities.equals((double)this.y, (double)envelope2D.y) && Utilities.equals((double)this.width, (double)envelope2D.width) && Utilities.equals((double)this.height, (double)envelope2D.height) && Utilities.equals((Object)this.crs, (Object)envelope2D.crs);
        }
        return super.equals(object);
    }

    public boolean boundsEquals(Envelope envelope, int n, int n2, double d) {
        d *= 0.5 * (this.width + this.height);
        for (int i = 0; i < 4; ++i) {
            double d2;
            double d3;
            int n3;
            int n4 = i & 1;
            int n5 = n3 = n4 == 0 ? n : n2;
            if ((i & 2) == 0) {
                d3 = this.getMinimum(n4);
                d2 = envelope.getMinimum(n3);
            } else {
                d3 = this.getMaximum(n4);
                d2 = envelope.getMaximum(n3);
            }
            if (Math.abs(d3 - d2) <= d) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return AbstractEnvelope.toString(this);
    }
}

