/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.cs;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.measure.converter.ConversionException;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotoolkit.lang.Static;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.referencing.cs.ComparableAxisWrapper;
import org.geotoolkit.referencing.cs.DefaultAffineCS;
import org.geotoolkit.referencing.cs.DefaultCartesianCS;
import org.geotoolkit.referencing.cs.DefaultCompoundCS;
import org.geotoolkit.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotoolkit.referencing.cs.DefaultEllipsoidalCS;
import org.geotoolkit.referencing.cs.DefaultSphericalCS;
import org.geotoolkit.referencing.cs.DefaultTimeCS;
import org.geotoolkit.referencing.cs.DefaultVerticalCS;
import org.geotoolkit.resources.Errors;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.LinearCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.UserDefinedCS;
import org.opengis.referencing.cs.VerticalCS;

final class PredefinedCS
extends Static
implements Comparator<CoordinateSystem> {
    private static Comparator<CoordinateSystem> csComparator;
    private final Class<? extends CoordinateSystem>[] types = new Class[]{CartesianCS.class, AffineCS.class, EllipsoidalCS.class, SphericalCS.class, CylindricalCS.class, PolarCS.class, VerticalCS.class, TimeCS.class, LinearCS.class, UserDefinedCS.class};

    private PredefinedCS() {
    }

    @Override
    public int compare(CoordinateSystem coordinateSystem, CoordinateSystem coordinateSystem2) {
        Class<?> clazz = coordinateSystem.getClass();
        Class<?> clazz2 = coordinateSystem2.getClass();
        for (int i = 0; i < this.types.length; ++i) {
            Class<? extends CoordinateSystem> clazz3 = this.types[i];
            boolean bl = clazz3.isAssignableFrom(clazz);
            boolean bl2 = clazz3.isAssignableFrom(clazz2);
            if (bl) {
                return bl2 ? 0 : -1;
            }
            if (!bl2) continue;
            return bl ? 0 : 1;
        }
        return 0;
    }

    static CoordinateSystem standard(CoordinateSystem coordinateSystem) throws IllegalArgumentException {
        int n = coordinateSystem.getDimension();
        if (coordinateSystem instanceof CartesianCS) {
            switch (n) {
                case 2: {
                    if (DefaultCartesianCS.PROJECTED.axisColinearWith(coordinateSystem)) {
                        return DefaultCartesianCS.PROJECTED;
                    }
                    if (DefaultCartesianCS.GRID.axisColinearWith(coordinateSystem)) {
                        return DefaultCartesianCS.GRID;
                    }
                    if (DefaultCartesianCS.GENERIC_2D.directionColinearWith(coordinateSystem)) {
                        return DefaultCartesianCS.GENERIC_2D;
                    }
                    return PredefinedCS.rightHanded((CartesianCS)coordinateSystem);
                }
                case 3: {
                    if (DefaultCartesianCS.GEOCENTRIC.axisColinearWith(coordinateSystem)) {
                        return DefaultCartesianCS.GEOCENTRIC;
                    }
                    if (DefaultCartesianCS.GENERIC_3D.directionColinearWith(coordinateSystem)) {
                        return DefaultCartesianCS.GENERIC_3D;
                    }
                    return PredefinedCS.rightHanded((CartesianCS)coordinateSystem);
                }
            }
        }
        if (coordinateSystem instanceof AffineCS) {
            return PredefinedCS.rightHanded((AffineCS)coordinateSystem);
        }
        if (coordinateSystem instanceof EllipsoidalCS) {
            switch (n) {
                case 2: {
                    return DefaultEllipsoidalCS.GEODETIC_2D;
                }
                case 3: {
                    return DefaultEllipsoidalCS.GEODETIC_3D;
                }
            }
        }
        if (coordinateSystem instanceof SphericalCS) {
            switch (n) {
                case 3: {
                    return DefaultSphericalCS.GEOCENTRIC;
                }
            }
        }
        if (coordinateSystem instanceof VerticalCS) {
            switch (n) {
                case 1: {
                    return DefaultVerticalCS.ELLIPSOIDAL_HEIGHT;
                }
            }
        }
        if (coordinateSystem instanceof TimeCS) {
            switch (n) {
                case 1: {
                    return DefaultTimeCS.DAYS;
                }
            }
        }
        if (coordinateSystem instanceof DefaultCompoundCS) {
            List<CoordinateSystem> list = ((DefaultCompoundCS)coordinateSystem).getComponents();
            Object[] objectArray = new CoordinateSystem[list.size()];
            Object[] objectArray2 = new CoordinateSystem[objectArray.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                objectArray[i] = list.get(i);
                objectArray2[i] = PredefinedCS.standard((CoordinateSystem)objectArray[i]);
            }
            if (csComparator == null) {
                csComparator = new PredefinedCS();
            }
            Arrays.sort(objectArray2, csComparator);
            return Arrays.equals(objectArray, objectArray2) ? coordinateSystem : new DefaultCompoundCS((CoordinateSystem[])objectArray2);
        }
        throw new IllegalArgumentException(Errors.format((int)237, (Object)coordinateSystem.getName().getCode()));
    }

    private static AffineCS rightHanded(AffineCS affineCS) {
        boolean bl = false;
        int n = affineCS.getDimension();
        CoordinateSystemAxis[] coordinateSystemAxisArray = new CoordinateSystemAxis[n];
        for (int i = 0; i < n; ++i) {
            Unit<?> unit;
            coordinateSystemAxisArray[i] = affineCS.getAxis(i);
            CoordinateSystemAxis coordinateSystemAxis = coordinateSystemAxisArray[i];
            DefaultCoordinateSystemAxis defaultCoordinateSystemAxis = DefaultCoordinateSystemAxis.getPredefined(coordinateSystemAxis);
            if (defaultCoordinateSystemAxis != null) {
                coordinateSystemAxis = defaultCoordinateSystemAxis;
            }
            if (!Unit.ONE.equals(unit = coordinateSystemAxis.getUnit()) && !SI.METRE.equals(unit)) {
                try {
                    coordinateSystemAxis = DefaultCoordinateSystemAxis.castOrCopy(coordinateSystemAxis).usingUnit((Unit<?>)SI.METRE);
                }
                catch (ConversionException conversionException) {
                    throw new IllegalArgumentException(Errors.format((int)92, (Object)SI.METRE), conversionException);
                }
            }
            bl |= coordinateSystemAxis != coordinateSystemAxisArray[i];
            coordinateSystemAxisArray[i] = coordinateSystemAxis;
        }
        if (!(bl |= ComparableAxisWrapper.sort(coordinateSystemAxisArray))) {
            return affineCS;
        }
        Map<String, Object> map = IdentifiedObjects.getProperties(affineCS, null);
        if (affineCS instanceof CartesianCS) {
            return new DefaultCartesianCS(map, coordinateSystemAxisArray);
        }
        return new DefaultAffineCS(map, coordinateSystemAxisArray);
    }
}

