/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19136.data.spatial;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.geotoolkit.geometry.Envelopes;
import org.geotoolkit.gml.xml.AbstractCurveSegment;
import org.geotoolkit.gml.xml.AbstractGeometry;
import org.geotoolkit.gml.xml.AbstractRing;
import org.geotoolkit.gml.xml.v321.AbstractCurveSegmentType;
import org.geotoolkit.gml.xml.v321.AbstractGeometryType;
import org.geotoolkit.gml.xml.v321.AbstractSurfaceType;
import org.geotoolkit.gml.xml.v321.CurveType;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.xml.MarshallerPool;
import org.opengis.cite.geomatics.Extents;
import org.opengis.cite.geomatics.GeodesyUtils;
import org.opengis.cite.geomatics.gml.CurveCoordinateListFactory;
import org.opengis.cite.geomatics.gml.CurveSegmentType;
import org.opengis.cite.geomatics.gml.GmlUtils;
import org.opengis.cite.geomatics.gml.SurfaceCoordinateListFactory;
import org.opengis.cite.iso19136.ErrorMessage;
import org.opengis.cite.iso19136.util.TestSuiteLogger;
import org.opengis.cite.iso19136.util.XMLUtils;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;
import org.testng.Assert;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GeometryAssert {
    private static final Logger LOGR = Logger.getLogger(GeometryAssert.class.getPackage().getName());
    private static final Unmarshaller GML_UNMARSHALLER = GeometryAssert.initGmlUnmarshaller();

    private static Unmarshaller initGmlUnmarshaller() {
        Unmarshaller unmarshaller = null;
        try {
            MarshallerPool pool = new MarshallerPool("org.geotoolkit.gml.xml.v321");
            unmarshaller = pool.acquireUnmarshaller();
        }
        catch (JAXBException je) {
            throw new RuntimeException(je);
        }
        return unmarshaller;
    }

    private GeometryAssert() {
    }

    public static void assertValidCRS(Element geom) {
        String srsName = GmlUtils.findCRSReference((Element)geom);
        if (srsName.isEmpty()) {
            String expr = "(./gml:posList | ./gml:pos)[1]/@srsName";
            try {
                srsName = (String)XMLUtils.evaluateXPath(geom, expr, null, XPathConstants.STRING);
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
        }
        Assert.assertFalse((boolean)srsName.isEmpty(), (String)String.format("%s[@gml:id='%s'] has no associated CRS.", geom.getLocalName(), geom.getAttributeNS("http://www.opengis.net/gml/3.2", "id")));
    }

    public static void assertGeometryCoveredByValidArea(AbstractGeometryType gmlGeom) {
        String srsName = gmlGeom.getSrsName();
        Assert.assertNotNull((Object)srsName, (String)String.format("CRS reference not found for %s with id = %s.", gmlGeom.getClass().getSimpleName(), gmlGeom.getId()));
        gmlGeom.setSrsName(GeodesyUtils.convertSRSNameToURN((String)srsName));
        Envelope crsDomain = Envelopes.getDomainOfValidity((CoordinateReferenceSystem)gmlGeom.getCoordinateReferenceSystem());
        Polygon validArea = Extents.envelopeAsPolygon((Envelope)crsDomain);
        Geometry geom = GmlUtils.computeConvexHull((AbstractGeometry)gmlGeom);
        if (geom.getClass().equals(GeometryCollection.class)) {
            return;
        }
        Assert.assertTrue((boolean)validArea.covers(geom), (String)String.format("%s[@gml:id='%s'] is not covered by valid area of CRS: %s", gmlGeom.getClass().getName(), gmlGeom.getId(), crsDomain.toString()));
    }

    public static void assertAllCurveSegmentsHaveRequiredLength(Element gmlCurve) {
        NodeList segments;
        try {
            segments = XMLUtils.evaluateXPath(gmlCurve, "//*[gml:posList]", null);
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        if (segments.getLength() == 0) {
            return;
        }
        int crsDim = 2;
        String srsName = gmlCurve.getAttribute("srsName");
        srsName = GeodesyUtils.convertSRSNameToURN((String)srsName);
        try {
            CoordinateReferenceSystem crs = CRS.decode((String)srsName);
            crsDim = crs.getCoordinateSystem().getDimension();
        }
        catch (FactoryException fe) {
            TestSuiteLogger.log(Level.WARNING, srsName, (Exception)((Object)fe));
        }
        for (int i = 0; i < segments.getLength(); ++i) {
            Element segment = (Element)segments.item(i);
            String segmentType = segment.getLocalName();
            int minLength = GmlUtils.minCurveSegmentLength((String)segmentType);
            Element posList = (Element)segment.getElementsByTagNameNS("http://www.opengis.net/gml/3.2", "posList").item(0);
            String[] values = posList.getTextContent().trim().split("\\s+");
            Assert.assertTrue((values.length >= crsDim * minLength ? 1 : 0) != 0, (String)String.format("gml:posList[%d] in %s[@gml:id='%s'] has fewer than %d values.", i + 1, gmlCurve.getLocalName(), gmlCurve.getAttributeNS("http://www.opengis.net/gml/3.2", "id"), crsDim * minLength));
            Assert.assertTrue((values.length % crsDim == 0 ? 1 : 0) != 0, (String)String.format("gml:posList[%d] in %s[@gml:id='%s'] is not consistent with a %dD CRS.", i + 1, gmlCurve.getLocalName(), gmlCurve.getAttributeNS("http://www.opengis.net/gml/3.2", "id"), crsDim));
        }
    }

    public static void assertCurveSegmentsAreConnected(Element gmlCurve) {
        CurveType curve;
        NodeList curveSegments;
        try {
            curveSegments = XMLUtils.evaluateXPath(gmlCurve, "gml:segments/*", null);
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        if (curveSegments.getLength() < 2) {
            return;
        }
        GmlUtils.findCRSReference((Element)gmlCurve);
        try {
            JAXBElement result = (JAXBElement)GML_UNMARSHALLER.unmarshal((Node)gmlCurve);
            curve = (CurveType)result.getValue();
        }
        catch (JAXBException je) {
            throw new RuntimeException(je);
        }
        Coordinate firstPoint = null;
        Coordinate lastPoint = null;
        List segmentList = curve.getSegments().getAbstractCurveSegment();
        for (int i = 0; i < segmentList.size(); ++i) {
            AbstractCurveSegmentType segment = (AbstractCurveSegmentType)segmentList.get(i);
            CurveSegmentType segmentType = (CurveSegmentType)CurveCoordinateListFactory.segmentTypeMap.get(segment.getClass().getName());
            List coordList = segmentType.getCoordinateList((AbstractCurveSegment)segment, curve.getCoordinateReferenceSystem());
            firstPoint = (Coordinate)coordList.get(0);
            if (i > 0) {
                GeometryAssert.assertCoordinateEquals(firstPoint, lastPoint, 2, String.format("In Curve with @gml:id='%s', segments %d and %d are not connected.", gmlCurve.getAttributeNS("http://www.opengis.net/gml/3.2", "id"), i, i + 1));
            }
            lastPoint = (Coordinate)coordList.get(coordList.size() - 1);
        }
    }

    public static void assertCurveComponentsAreConnected(Element gmlCurve) {
        NodeList curveMembers;
        try {
            curveMembers = XMLUtils.evaluateXPath(gmlCurve, "gml:curveMember/*", null);
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        if (curveMembers.getLength() < 2) {
            return;
        }
        CurveCoordinateListFactory coordFactory = new CurveCoordinateListFactory();
        Coordinate firstPoint = null;
        Coordinate lastPoint = null;
        for (int i = 0; i < curveMembers.getLength(); ++i) {
            JAXBElement curveType;
            Element curveElem = (Element)curveMembers.item(i);
            GmlUtils.findCRSReference((Element)curveElem);
            try {
                curveType = (JAXBElement)GML_UNMARSHALLER.unmarshal((Node)curveElem);
            }
            catch (JAXBException je) {
                throw new RuntimeException(je);
            }
            List coordList = coordFactory.createCoordinateList((AbstractGeometry)curveType.getValue());
            boolean negOrientation = curveElem.getAttribute("orientation").equals("-");
            firstPoint = negOrientation ? (Coordinate)coordList.get(coordList.size() - 1) : (Coordinate)coordList.get(0);
            if (i > 1) {
                GeometryAssert.assertCoordinateEquals(firstPoint, lastPoint, 2, String.format("In CompositeCurve with @gml:id='%s', curve members %d and %d are not connected.", gmlCurve.getAttributeNS("http://www.opengis.net/gml/3.2", "id"), i, i + 1));
            }
            lastPoint = negOrientation ? (Coordinate)coordList.get(0) : (Coordinate)coordList.get(coordList.size() - 1);
        }
    }

    public static void assertCoordinateEquals(Coordinate actualPos, Coordinate expectedPos, int tolerancePPM, String message) {
        double tolerance = (double)tolerancePPM * 1.0E-6;
        Assert.assertEquals((double)Math.abs(actualPos.x / expectedPos.x - 1.0), (double)0.0, (double)tolerance, (String)(message + String.format("\nFirst element of tuple is out of tolerance (%d ppm).", tolerancePPM)));
        Assert.assertEquals((double)Math.abs(actualPos.y / expectedPos.y - 1.0), (double)0.0, (double)tolerance, (String)(message + String.format("\nSecond element of tuple is out of tolerance (%d ppm).", tolerancePPM)));
    }

    public static void assertValidSurfaceBoundary(Element surfaceElem) {
        List extCoordList;
        if (LOGR.isLoggable(Level.FINE)) {
            LOGR.log(Level.FINE, "Checking boundary of {0} with @gml:id=\"{1}\"", new Object[]{surfaceElem.getNodeName(), surfaceElem.getAttributeNS("http://www.opengis.net/gml/3.2", "id")});
        }
        if (surfaceElem.getAttribute("srsName").isEmpty()) {
            GmlUtils.findCRSReference((Element)surfaceElem);
        }
        SurfaceCoordinateListFactory coordFactory = new SurfaceCoordinateListFactory();
        AbstractSurfaceType surfaceType = null;
        try {
            JAXBElement jaxbSurface = (JAXBElement)GML_UNMARSHALLER.unmarshal((Node)surfaceElem);
            surfaceType = (AbstractSurfaceType)jaxbSurface.getValue();
            extCoordList = coordFactory.createCoordinateList((AbstractGeometry)surfaceType);
        }
        catch (JAXBException je) {
            extCoordList = coordFactory.createCoordinateList(surfaceElem);
        }
        if (null != surfaceType) {
            GeometryAssert.assertGeometryCoveredByValidArea((AbstractGeometryType)surfaceType);
        }
        GeometryAssert.removeConsecutiveDuplicates(extCoordList, 0.5);
        GeometryFactory geomFactory = new GeometryFactory();
        LineString exteriorCurve = geomFactory.createLineString(extCoordList.toArray(new Coordinate[extCoordList.size()]));
        if (LOGR.isLoggable(Level.FINE)) {
            StringBuilder msg = new StringBuilder("Exterior boundary of ");
            msg.append(surfaceElem.getAttributeNS("http://www.opengis.net/gml/3.2", "id"));
            msg.append("\n").append(exteriorCurve.toString());
            LOGR.fine(msg.toString());
        }
        Assert.assertTrue((boolean)exteriorCurve.isSimple(), (String)String.format("Exterior boundary of surface with @gml:id='%s' is not simple.", surfaceElem.getAttributeNS("http://www.opengis.net/gml/3.2", "id")));
        Assert.assertTrue((boolean)exteriorCurve.isClosed(), (String)String.format("Exterior boundary of surface with @gml:id='%s' is not closed.", surfaceElem.getAttributeNS("http://www.opengis.net/gml/3.2", "id")));
        Polygon coveringPolygon = geomFactory.createPolygon(exteriorCurve.getCoordinates());
        Set interiorCoordSet = null;
        interiorCoordSet = null != surfaceType ? coordFactory.interiorCoordinatesSet((AbstractGeometry)surfaceType) : coordFactory.interiorCoordinatesSet(surfaceElem);
        for (List ringCoords : interiorCoordSet) {
            LineString interiorCurve = geomFactory.createLineString(ringCoords.toArray(new Coordinate[0]));
            Assert.assertTrue((boolean)interiorCurve.isSimple(), (String)String.format("Interior boundary of surface with @gml:id='%s' is not simple. Starting position: %s.", surfaceElem.getAttributeNS("http://www.opengis.net/gml/3.2", "id"), interiorCurve.getCoordinateN(0)));
            Assert.assertTrue((boolean)interiorCurve.isClosed(), (String)String.format("Interior boundary of surface with @gml:id='%s' is not closed. Starting position: %s.", surfaceElem.getAttributeNS("http://www.opengis.net/gml/3.2", "id"), interiorCurve.getCoordinateN(0)));
            Assert.assertTrue((boolean)interiorCurve.coveredBy((Geometry)coveringPolygon), (String)String.format("Interior boundary not covered by surface with @gml:id='%s'. Starting position: %s.", surfaceElem.getAttributeNS("http://www.opengis.net/gml/3.2", "id"), interiorCurve.getCoordinateN(0)));
        }
    }

    static void assertValidSurfaceOrientation(Element surfaceElem) {
        AbstractRing gmlRing = null;
        NodeList exteriorProps = surfaceElem.getElementsByTagNameNS("http://www.opengis.net/gml/3.2", "exterior");
        for (int i = 0; i < exteriorProps.getLength(); ++i) {
            Element extRingElem = (Element)XMLUtils.getPropertyValue(exteriorProps.item(i));
            try {
                JAXBElement jaxbRing = (JAXBElement)GML_UNMARSHALLER.unmarshal((Node)extRingElem);
                gmlRing = (AbstractRing)jaxbRing.getValue();
                gmlRing.setSrsName(surfaceElem.getAttribute("srsName"));
            }
            catch (JAXBException je) {
                throw new RuntimeException(je);
            }
            Coordinate[] exteriorCoords = GeodesyUtils.transformRingToRightHandedCS((AbstractRing)gmlRing);
            Assert.assertTrue((boolean)CGAlgorithms.isCCW((Coordinate[])exteriorCoords), (String)ErrorMessage.format("ExteriorBoundaryOrientation", surfaceElem.getAttributeNS("http://www.opengis.net/gml/3.2", "id")));
        }
        NodeList interiorProps = surfaceElem.getElementsByTagNameNS("http://www.opengis.net/gml/3.2", "interior");
        for (int j = 0; j < interiorProps.getLength(); ++j) {
            Element intRingElem = (Element)XMLUtils.getPropertyValue(interiorProps.item(j));
            try {
                JAXBElement jaxbRing = (JAXBElement)GML_UNMARSHALLER.unmarshal((Node)intRingElem);
                gmlRing = (AbstractRing)jaxbRing.getValue();
                gmlRing.setSrsName(surfaceElem.getAttribute("srsName"));
            }
            catch (JAXBException je) {
                throw new RuntimeException(je);
            }
            Coordinate[] interiorCoords = GeodesyUtils.transformRingToRightHandedCS((AbstractRing)gmlRing);
            Assert.assertFalse((boolean)CGAlgorithms.isCCW((Coordinate[])interiorCoords), (String)ErrorMessage.format("InteriorBoundaryOrientation", surfaceElem.getAttributeNS("http://www.opengis.net/gml/3.2", "id"), j + 1));
        }
    }

    static void removeConsecutiveDuplicates(List<Coordinate> coordList, double tolerancePPM) {
        if (coordList.size() < 2) {
            return;
        }
        double tolerance = tolerancePPM * 1.0E-6;
        ListIterator<Coordinate> itr = coordList.listIterator();
        Coordinate coord = itr.next();
        while (itr.hasNext()) {
            Coordinate nextCoord = itr.next();
            double xDelta = Math.abs(nextCoord.x / coord.x - 1.0);
            double yDelta = Math.abs(nextCoord.y / coord.y - 1.0);
            if (xDelta <= tolerance && yDelta <= tolerance) {
                if (!itr.hasNext()) {
                    coordList.remove(coordList.size() - 2);
                    break;
                }
                itr.remove();
                continue;
            }
            coord = nextCoord;
        }
    }
}

