/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.math;

public class ExtrapolationException
extends Exception {
    public double xi = Double.NaN;
    public byte raison = 0;
    public int index = -1;

    public ExtrapolationException() {
        super("Le vecteur des X ne contient pas suffisament de donn\u00e9es valides.");
    }

    public ExtrapolationException(double xi) {
        super(Double.isNaN(xi) ? "Je ne peux pas interpoler \u00e0 x=NaN." : "Le vecteur des X ne contient pas suffisament de donn\u00e9es valides.");
        this.xi = xi;
    }

    public ExtrapolationException(int raison) {
        super("La donn\u00e9e demand\u00e9e est en dehors de la plage de valeurs du vecteur des X.");
        this.raison = (byte)raison;
    }

    public ExtrapolationException(int raison, int index) {
        this(raison);
        this.index = index;
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        return message + " (" + this.xi + ')';
    }
}

