/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata;

import java.lang.reflect.Method;
import java.util.Comparator;
import net.jcip.annotations.Immutable;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.UML;

@Immutable
final class PropertyComparator
implements Comparator<Method> {
    static final Comparator<Method> INSTANCE = new PropertyComparator();

    private PropertyComparator() {
    }

    @Override
    public int compare(Method method, Method method2) {
        UML uML = method.getAnnotation(UML.class);
        UML uML2 = method2.getAnnotation(UML.class);
        if (uML != null) {
            if (uML2 == null) {
                return 1;
            }
            int n = this.order(uML) - this.order(uML2);
            if (n == 0) {
                n = uML.identifier().compareToIgnoreCase(uML2.identifier());
            }
            return n;
        }
        if (uML2 != null) {
            return -1;
        }
        return method.getName().compareToIgnoreCase(method2.getName());
    }

    private int order(UML uML) {
        Obligation obligation = uML.obligation();
        if (obligation != null) {
            switch (obligation) {
                case MANDATORY: {
                    return 1;
                }
                case CONDITIONAL: {
                    return 2;
                }
                case OPTIONAL: {
                    return 3;
                }
                case FORBIDDEN: {
                    return 4;
                }
            }
        }
        return 5;
    }
}

