/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata.iso.identification;

import java.util.Collection;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.metadata.iso.MetadataEntity;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.identification.Usage;
import org.opengis.util.InternationalString;

@ThreadSafe
@XmlType(name="MD_Usage_Type", propOrder={"specificUsage", "usageDate", "userDeterminedLimitations", "userContactInfo"})
@XmlRootElement(name="MD_Usage")
public class DefaultUsage
extends MetadataEntity
implements Usage {
    private static final long serialVersionUID = 4059324536168287490L;
    private InternationalString specificUsage;
    private long usageDate;
    private InternationalString userDeterminedLimitations;
    private Collection<ResponsibleParty> userContactInfo;

    public DefaultUsage() {
        this.usageDate = Long.MIN_VALUE;
    }

    public DefaultUsage(Usage usage) {
        super(usage);
        if (usage != null && this.usageDate == 0L && usage.getUsageDate() == null) {
            this.usageDate = Long.MIN_VALUE;
        }
    }

    public DefaultUsage(InternationalString internationalString, Collection<ResponsibleParty> collection) {
        this();
        this.setSpecificUsage(internationalString);
        this.setUserContactInfo(collection);
    }

    public static DefaultUsage castOrCopy(Usage usage) {
        return usage == null || usage instanceof DefaultUsage ? (DefaultUsage)usage : new DefaultUsage(usage);
    }

    @Override
    @XmlElement(name="specificUsage", required=true)
    public synchronized InternationalString getSpecificUsage() {
        return this.specificUsage;
    }

    public synchronized void setSpecificUsage(InternationalString internationalString) {
        this.checkWritePermission();
        this.specificUsage = internationalString;
    }

    @Override
    @XmlElement(name="usageDateTime")
    public synchronized Date getUsageDate() {
        return this.usageDate != Long.MIN_VALUE ? new Date(this.usageDate) : null;
    }

    public synchronized void setUsageDate(Date date) {
        this.checkWritePermission();
        this.usageDate = date != null ? date.getTime() : Long.MIN_VALUE;
    }

    @Override
    @XmlElement(name="userDeterminedLimitations")
    public synchronized InternationalString getUserDeterminedLimitations() {
        return this.userDeterminedLimitations;
    }

    public synchronized void setUserDeterminedLimitations(InternationalString internationalString) {
        this.checkWritePermission();
        this.userDeterminedLimitations = internationalString;
    }

    @XmlElement(name="userContactInfo", required=true)
    public synchronized Collection<ResponsibleParty> getUserContactInfo() {
        this.userContactInfo = this.nonNullCollection(this.userContactInfo, ResponsibleParty.class);
        return this.userContactInfo;
    }

    public synchronized void setUserContactInfo(Collection<? extends ResponsibleParty> collection) {
        this.userContactInfo = this.copyCollection(collection, this.userContactInfo, ResponsibleParty.class);
    }
}

