/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import java.awt.geom.AffineTransform;
import net.jcip.annotations.Immutable;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.referencing.operation.matrix.Matrix2;
import org.geotoolkit.referencing.operation.projection.Assertions;
import org.geotoolkit.referencing.operation.projection.ProjectionException;
import org.geotoolkit.referencing.operation.projection.UnitaryProjection;
import org.geotoolkit.util.ComparisonMode;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;

@Immutable
public class LambertAzimuthalEqualArea
extends UnitaryProjection {
    private static final long serialVersionUID = 1639914708790574760L;
    private static final double EPSILON = 1.0E-10;
    private static final double P00 = 0.3333333333333333;
    private static final double P01 = 0.17222222222222222;
    private static final double P02 = 0.10257936507936508;
    private static final double P10 = 0.06388888888888888;
    private static final double P11 = 0.0664021164021164;
    private static final double P20 = 0.016415012942191543;
    final boolean pole;
    final boolean north;
    final boolean oblique;
    final double latitudeOfOrigin;
    final double sinb1;
    final double cosb1;
    final double qp;
    final double rq;
    private final double APA0;
    private final double APA1;
    private final double APA2;

    public static MathTransform2D create(ParameterDescriptorGroup parameterDescriptorGroup, ParameterValueGroup parameterValueGroup) {
        UnitaryProjection.Parameters parameters = new UnitaryProjection.Parameters(parameterDescriptorGroup, parameterValueGroup);
        LambertAzimuthalEqualArea lambertAzimuthalEqualArea = parameters.isSpherical() ? new Spherical(parameters) : new LambertAzimuthalEqualArea(parameters);
        return lambertAzimuthalEqualArea.createConcatenatedTransform();
    }

    protected LambertAzimuthalEqualArea(UnitaryProjection.Parameters parameters) {
        super(parameters);
        this.latitudeOfOrigin = Math.toRadians(parameters.latitudeOfOrigin);
        double d = Math.abs(this.latitudeOfOrigin);
        if (Math.abs(d - 1.5707963267948966) < 1.0E-10) {
            this.pole = true;
            this.north = this.latitudeOfOrigin >= 0.0;
            this.oblique = false;
        } else {
            this.pole = false;
            this.north = false;
            this.oblique = Math.abs(d) >= 1.0E-10;
        }
        double d2 = this.excentricitySquared * this.excentricitySquared;
        double d3 = this.excentricitySquared * d2;
        this.APA0 = 0.10257936507936508 * d3 + 0.17222222222222222 * d2 + 0.3333333333333333 * this.excentricitySquared;
        this.APA1 = 0.0664021164021164 * d3 + 0.06388888888888888 * d2;
        this.APA2 = 0.016415012942191543 * d3;
        this.qp = this.qsfn(1.0);
        this.rq = Math.sqrt(0.5 * this.qp);
        double d4 = Math.sin(this.latitudeOfOrigin);
        boolean bl = this.isSpherical();
        if (bl) {
            this.sinb1 = d4;
            this.cosb1 = Math.cos(this.latitudeOfOrigin);
        } else {
            this.sinb1 = this.qsfn(d4) / this.qp;
            this.cosb1 = Math.sqrt(1.0 - this.sinb1 * this.sinb1);
        }
        AffineTransform affineTransform = parameters.normalize(true);
        AffineTransform affineTransform2 = parameters.normalize(false);
        parameters.validate();
        if (this.north) {
            affineTransform.scale(1.0, -1.0);
            affineTransform2.scale(1.0, -1.0);
        } else if (!bl && this.oblique) {
            double d5 = Math.cos(this.latitudeOfOrigin) / (Math.sqrt(1.0 - this.excentricitySquared * (d4 * d4)) * this.rq * this.cosb1);
            affineTransform2.scale(d5, 1.0 / d5);
        }
        this.finish();
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return org.geotoolkit.referencing.operation.provider.LambertAzimuthalEqualArea.PARAMETERS;
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7 = this.rollLongitude(dArray[n]);
        double d8 = dArray[n + 1];
        double d9 = Math.cos(d7);
        double d10 = Math.sin(d7);
        double d11 = Math.sin(d8);
        double d12 = this.qsfn(d11);
        if (!this.pole) {
            d6 = d12 / this.qp;
            d5 = Math.sqrt(1.0 - d6 * d6);
            if (this.oblique) {
                d4 = 1.0 + d6 * this.sinb1 + d5 * d9 * this.cosb1;
                d3 = this.rq * (d6 * this.cosb1 - d5 * d9 * this.sinb1);
                d2 = this.rq * d5 * d10;
            } else {
                d4 = 1.0 + d5 * d9;
                d3 = d6 * (0.5 * this.qp);
                d2 = d5 * d10;
            }
            d = Math.sqrt(2.0 / d4);
            d2 *= d;
            d3 *= d;
        } else {
            d4 = d8 - 1.5707963267948966;
            d = Math.sqrt(this.qp + d12);
            d2 = d * d10;
            d3 = d * d9;
        }
        if (Math.abs(d4) < 1.0E-10) {
            d3 = Double.NaN;
            d2 = Double.NaN;
        }
        if (dArray2 != null) {
            dArray2[n2] = d2;
            dArray2[n2 + 1] = d3;
        }
        if (!bl) {
            return null;
        }
        d6 = Math.cos(d8);
        d5 = this.dqsfn_d\u03c6(d11, d6);
        if (this.pole) {
            double d13 = 0.5 * d5 / d;
            return new Matrix2(d3, d13 * d10, -d2, d13 * d9);
        }
        double d14 = d12 / this.qp;
        double d15 = d5 / this.qp;
        double d16 = Math.sqrt(1.0 - d14 * d14);
        double d17 = -d15 * (d14 / d16);
        double d18 = d10 * d16;
        double d19 = d9 * d16;
        double d20 = d9 * d17;
        double d21 = this.cosb1 * d14 - this.sinb1 * d19;
        double d22 = this.sinb1 * d18;
        double d23 = this.cosb1 * d18 / (2.0 * d4);
        double d24 = this.cosb1 * d15 - this.sinb1 * d20;
        double d25 = -(this.sinb1 * d15 + this.cosb1 * d20) / (2.0 * d4);
        double d26 = 2.0 * this.rq / Math.sqrt(2.0 * d4);
        return new Matrix2(d26 * (d9 + d23 * d10) * d16, d26 * (d17 + d25 * d16) * d10, d26 * (d22 + d23 * d21), d26 * (d24 + d25 * d21));
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d;
        double d2;
        double d3 = dArray[n];
        double d4 = dArray[n + 1];
        if (this.pole) {
            d2 = (d3 * d3 + d4 * d4) / this.qp - 1.0;
        } else {
            if (!this.oblique) {
                d3 *= this.rq;
                d4 /= this.rq;
            }
            if ((d = Math.hypot(d3, d4)) < 1.0E-10) {
                dArray2[n2] = 0.0;
                dArray2[n2 + 1] = this.latitudeOfOrigin;
                return;
            }
            double d5 = 2.0 * Math.asin(0.5 * d / this.rq);
            double d6 = Math.cos(d5);
            d5 = Math.sin(d5);
            d3 *= d5;
            if (this.oblique) {
                d2 = d6 * this.sinb1 + d4 * d5 * this.cosb1 / d;
                d4 = d * this.cosb1 * d6 - d4 * this.sinb1 * d5;
            } else {
                d2 = d4 * d5 / d;
                d4 = d * d6;
            }
        }
        d = Math.abs(d2);
        d = d > 1.0 && d <= 1.000001 ? Math.copySign(1.5707963267948966, d2) : Math.asin(d2);
        double d7 = d;
        double d8 = d + d;
        d = d8;
        d += d;
        dArray2[n2 + 1] = d7 + this.APA0 * Math.sin(d8) + this.APA1 * Math.sin(d) + this.APA2 * Math.sin(d + d);
        dArray2[n2] = this.unrollLongitude(Math.atan2(d3, d4));
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (super.equals(object, comparisonMode)) {
            LambertAzimuthalEqualArea lambertAzimuthalEqualArea = (LambertAzimuthalEqualArea)object;
            return InternalUtilities.epsilonEqual(this.latitudeOfOrigin, lambertAzimuthalEqualArea.latitudeOfOrigin, comparisonMode);
        }
        return false;
    }

    @Immutable
    static final class Spherical
    extends LambertAzimuthalEqualArea {
        private static final long serialVersionUID = 2091431369806844342L;

        protected Spherical(UnitaryProjection.Parameters parameters) {
            super(parameters);
            parameters.ensureSpherical();
        }

        @Override
        final boolean isSpherical() {
            return true;
        }

        @Override
        public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
            double d;
            double d2;
            double d3 = this.rollLongitude(dArray[n]);
            double d4 = dArray[n + 1];
            double d5 = Math.sin(d3);
            double d6 = Math.cos(d3);
            if (!this.pole) {
                double d7 = Math.sin(d4);
                double d8 = Math.cos(d4);
                if (!this.oblique) {
                    d2 = 1.0 + d8 * d6;
                    if (d2 >= 1.0E-10) {
                        d2 = Math.sqrt(2.0 / d2);
                        d = d2 * d7;
                    } else {
                        d = Double.NaN;
                        d2 = Double.NaN;
                    }
                } else {
                    d = d8 * d6;
                    d2 = 1.0 + this.sinb1 * d7 + this.cosb1 * d;
                    if (d2 >= 1.0E-10) {
                        d2 = Math.sqrt(2.0 / d2);
                        d = d2 * (this.cosb1 * d7 - this.sinb1 * d);
                    } else {
                        d = Double.NaN;
                        d2 = Double.NaN;
                    }
                }
                d2 *= d8 * d5;
            } else if (Math.abs(d4 - 1.5707963267948966) >= 1.0E-10) {
                d = 2.0 * Math.cos(0.7853981633974483 - 0.5 * d4);
                d2 = d * d5;
                d *= d6;
            } else {
                d = Double.NaN;
                d2 = Double.NaN;
            }
            Matrix2 matrix2 = null;
            if (bl) {
                double d9;
                double d10;
                double d11;
                double d12;
                if (this.pole) {
                    double d13 = 2.0 * Math.cos(0.7853981633974483 - 0.5 * d4);
                    double d14 = Math.sin(0.7853981633974483 - 0.5 * d4);
                    d12 = d6 * d13;
                    d11 = -d5 * d13;
                    d10 = d5 * d14;
                    d9 = d6 * d14;
                } else {
                    double d15 = Math.sin(d4);
                    double d16 = Math.cos(d4);
                    double d17 = d16 * d6;
                    double d18 = d16 * d5;
                    double d19 = d15 * d6;
                    double d20 = 1.0 + this.sinb1 * d15 + this.cosb1 * d17;
                    double d21 = Math.sqrt(2.0 / d20);
                    d20 *= d20 * d21;
                    double d22 = this.cosb1 * d18 / d20;
                    double d23 = (this.cosb1 * d19 - this.sinb1 * d16) / d20;
                    d12 = d22 * d18 + d17 * d21;
                    d10 = d23 * d18 - d15 * d5 * d21;
                    d11 = this.cosb1 * d22 * d15 - this.sinb1 * (d22 * d17 - d18 * d21);
                    d9 = this.cosb1 * (d23 * d15 + d16 * d21) - this.sinb1 * (d23 * d17 - d19 * d21);
                }
                matrix2 = new Matrix2(d12, d10, d11, d9);
            }
            assert (Assertions.checkDerivative(matrix2, super.transform(dArray, n, dArray2, n2, bl)) && Assertions.checkTransform(dArray2, n2, d2, d));
            if (dArray2 != null) {
                dArray2[n2] = d2;
                dArray2[n2 + 1] = d;
            }
            return matrix2;
        }

        @Override
        protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
            double d;
            double d2 = dArray[n];
            double d3 = dArray[n + 1];
            double d4 = Math.hypot(d2, d3);
            double d5 = 2.0 * Math.asin(0.5 * d4);
            if (this.pole) {
                d5 -= 1.5707963267948966;
                d = Math.atan2(d2, d3);
            } else {
                double d6 = Math.sin(d5);
                double d7 = Math.cos(d5);
                if (!this.oblique) {
                    d5 = Math.abs(d4) <= 1.0E-10 ? 0.0 : Math.asin(d3 * d6 / d4);
                    d3 = d4 * d7;
                } else {
                    d5 = Math.abs(d4) <= 1.0E-10 ? this.latitudeOfOrigin : Math.asin(d7 * this.sinb1 + (d3 *= d6) * this.cosb1 / d4);
                    d3 = d4 * d7 * this.cosb1 - d3 * this.sinb1;
                }
                d = Math.atan2(d2 *= d6, d3);
            }
            d = this.unrollLongitude(d);
            assert (this.checkInverseTransform(dArray, n, dArray2, n2, d, d5));
            dArray2[n2] = d;
            dArray2[n2 + 1] = d5;
        }

        private boolean checkInverseTransform(double[] dArray, int n, double[] dArray2, int n2, double d, double d2) throws ProjectionException {
            super.inverseTransform(dArray, n, dArray2, n2);
            return Assertions.checkInverseTransform(dArray2, n2, d, d2);
        }
    }
}

