/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.geotoolkit.util.NumberRange;

public abstract class NotifiedCopyOnWriteArrayList<E>
extends CopyOnWriteArrayList<E> {
    protected abstract void notifyAdd(E var1, int var2);

    protected abstract void notifyAdd(Collection<? extends E> var1, NumberRange<Integer> var2);

    protected abstract void notifyRemove(E var1, int var2);

    protected abstract void notifyRemove(Collection<? extends E> var1, NumberRange<Integer> var2);

    @Override
    public boolean add(E element) throws IllegalArgumentException, UnsupportedOperationException {
        if (element == null) {
            return false;
        }
        boolean added = super.add(element);
        if (added) {
            int index = super.size() - 1;
            this.notifyAdd(element, index);
        }
        return added;
    }

    @Override
    public void add(int index, E element) throws IllegalArgumentException, UnsupportedOperationException {
        super.add(index, element);
        this.notifyAdd(element, index);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) throws IllegalArgumentException, UnsupportedOperationException {
        int startIndex = super.size();
        boolean added = super.addAll(collection);
        if (added) {
            this.notifyAdd(collection, (NumberRange<Integer>)NumberRange.create((int)startIndex, (int)(super.size() - 1)));
        }
        return added;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> collection) throws IllegalArgumentException, UnsupportedOperationException {
        boolean added = super.addAll(index, collection);
        if (added) {
            this.notifyAdd(collection, (NumberRange<Integer>)NumberRange.create((int)index, (int)(index + collection.size())));
        }
        return added;
    }

    @Override
    public boolean remove(Object o) throws UnsupportedOperationException {
        int index = super.indexOf(o);
        if (index >= 0) {
            super.remove(index);
            this.notifyRemove(o, index);
            return true;
        }
        return false;
    }

    @Override
    public E remove(int index) throws UnsupportedOperationException {
        Object removed = super.remove(index);
        this.notifyRemove(removed, index);
        return removed;
    }

    @Override
    public boolean removeAll(Collection<?> c) throws UnsupportedOperationException {
        boolean valid = false;
        for (Object i : c) {
            boolean val = this.remove(i);
            if (!val) continue;
            valid = val;
        }
        return valid;
    }

    @Override
    public void clear() throws UnsupportedOperationException {
        if (!this.isEmpty()) {
            ArrayList copy = new ArrayList(this);
            NumberRange range = NumberRange.create((int)0, (int)(copy.size() - 1));
            super.clear();
            this.notifyRemove(copy, (NumberRange<Integer>)range);
        }
    }
}

