/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.execute.ExecAggregator;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.OrderableAggregator;

public final class MaxMinAggregator
extends OrderableAggregator {
    private boolean isMax;

    public void setup(ClassFactory classFactory, String string, DataTypeDescriptor dataTypeDescriptor) {
        super.setup(classFactory, string, dataTypeDescriptor);
        this.isMax = string.equals("MAX");
    }

    protected void accumulate(DataValueDescriptor dataValueDescriptor) throws StandardException {
        if (this.value == null || this.isMax && this.value.compare(dataValueDescriptor) < 0 || !this.isMax && this.value.compare(dataValueDescriptor) > 0) {
            this.value = dataValueDescriptor.cloneValue(false);
        }
    }

    public ExecAggregator newAggregator() {
        MaxMinAggregator maxMinAggregator = new MaxMinAggregator();
        maxMinAggregator.isMax = this.isMax;
        return maxMinAggregator;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeBoolean(this.isMax);
        super.writeExternal(objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.isMax = objectInput.readBoolean();
        super.readExternal(objectInput);
    }

    public int getTypeFormatId() {
        return 152;
    }
}

