/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util;

import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.geotoolkit.lang.Static;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.logging.Logging;

public final class ImageIOUtilities
extends Static {
    private static final Logger LOGGER = Logging.getLogger(ImageIOUtilities.class);

    private ImageIOUtilities() {
    }

    public static void writeImage(RenderedImage image, String mime, Object output) throws IOException {
        ImageWriter writer = ImageIOUtilities.getImageWriter(image, mime, output);
        ImageWriterSpi spi = writer.getOriginatingProvider();
        ImageOutputStream stream = null;
        if (!ImageIOUtilities.isValidType(spi.getOutputTypes(), output)) {
            stream = ImageIO.createImageOutputStream(output);
            output = stream;
        }
        writer.setOutput(output);
        writer.write(image);
        writer.dispose();
        if (stream != null) {
            stream.close();
        }
    }

    public static void writeImage(RenderedImage image, Object output, ImageWriter writer) throws IOException {
        ImageWriterSpi spi = writer.getOriginatingProvider();
        ImageOutputStream stream = null;
        if (!ImageIOUtilities.isValidType(spi.getOutputTypes(), output)) {
            stream = ImageIO.createImageOutputStream(output);
            output = stream;
        }
        writer.setOutput(output);
        writer.write(image);
        writer.dispose();
        if (stream != null) {
            stream.close();
        }
    }

    public static void logImageWriterOrder(String mime) {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByMIMEType(mime);
        int i = 1;
        String line = "\n///////////////////////////////////////////\n";
        StringBuilder sb = new StringBuilder("\n///////////////////////////////////////////\n");
        while (writers.hasNext()) {
            ImageWriter writer = writers.next();
            ImageWriterSpi spi = writer.getOriginatingProvider();
            sb.append("\\").append(i).append(": description:").append(spi.getDescription(Locale.FRENCH)).append('\n');
            ++i;
        }
        sb.append("\n///////////////////////////////////////////\n");
        Logger.getAnonymousLogger().log(Level.INFO, sb.toString());
    }

    public static ImageWriter getImageWriter(RenderedImage image, String mime, Object output) throws IOException {
        ArgumentChecks.ensureNonNull((String)"image", (Object)image);
        int n = 0;
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByMIMEType(mime);
        while (writers.hasNext()) {
            ImageWriter writer = writers.next();
            ImageWriterSpi spi = writer.getOriginatingProvider();
            if (spi.canEncodeImage(image)) {
                return writer;
            }
            ++n;
        }
        throw new IOException("Can not write the image for the MIME type : " + mime + ". Found " + n + " writers, but none can encode the image. " + "Available MIME type are " + Arrays.toString(ImageIO.getWriterMIMETypes()));
    }

    public static boolean isValidType(Class<?>[] validTypes, Object type) {
        for (Class<?> t : validTypes) {
            if (!t.isInstance(type)) continue;
            return true;
        }
        return false;
    }

    public static String fileExtensionToMimeType(String extension) throws IIOException {
        Iterator<ImageReaderSpi> readers = IIORegistry.lookupProviders(ImageReaderSpi.class);
        while (readers.hasNext()) {
            String[] suffixes;
            ImageReaderSpi reader = readers.next();
            for (String suffixe : suffixes = reader.getFileSuffixes()) {
                String[] mimeTypes;
                if (!extension.equalsIgnoreCase(suffixe) || (mimeTypes = reader.getMIMETypes()) == null || mimeTypes.length <= 0) continue;
                return mimeTypes[0];
            }
        }
        throw new IIOException("No available image reader able to handle the extension specified: " + extension);
    }

    public static String formatNameToMimeType(String formatName) throws IIOException {
        Iterator<ImageReaderSpi> readers = IIORegistry.lookupProviders(ImageReaderSpi.class);
        while (readers.hasNext()) {
            String[] formats;
            ImageReaderSpi reader = readers.next();
            for (String format : formats = reader.getFormatNames()) {
                String[] mimeTypes;
                if (!formatName.equalsIgnoreCase(format) || (mimeTypes = reader.getMIMETypes()) == null || mimeTypes.length <= 0) continue;
                return mimeTypes[0];
            }
        }
        throw new IIOException("No available image reader able to handle the format name specified: " + formatName);
    }

    public static String mimeTypeToFormatName(String mimeType) throws IIOException {
        Iterator<ImageReaderSpi> readers = IIORegistry.lookupProviders(ImageReaderSpi.class);
        while (readers.hasNext()) {
            String[] mimes;
            ImageReaderSpi reader = readers.next();
            for (String mime : mimes = reader.getMIMETypes()) {
                String[] formats;
                if (!mimeType.equalsIgnoreCase(mime) || (formats = reader.getFormatNames()) == null || formats.length <= 0) continue;
                return formats[0];
            }
        }
        throw new IIOException("No available image reader able to handle the mime type specified: " + mimeType);
    }

    public static void releaseReader(ImageReader reader) {
        if (reader == null) {
            return;
        }
        Object readerinput = reader.getInput();
        if (readerinput instanceof InputStream) {
            try {
                ((InputStream)readerinput).close();
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, ex.getMessage(), ex);
            }
        } else if (readerinput instanceof ImageInputStream) {
            try {
                ((ImageInputStream)readerinput).close();
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, ex.getMessage(), ex);
            }
        }
        reader.dispose();
    }
}

