/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.io.wkt;

import javax.measure.quantity.Angle;
import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotoolkit.metadata.iso.citation.Citations;
import org.geotoolkit.metadata.iso.citation.DefaultCitation;
import org.geotoolkit.referencing.cs.DefaultCartesianCS;
import org.geotoolkit.referencing.cs.DefaultCoordinateSystemAxis;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;

public enum Convention {
    OGC(null, false),
    EPSG(null, false){

        @Override
        public CoordinateSystem toConformCS(CoordinateSystem coordinateSystem) {
            if (coordinateSystem instanceof CartesianCS) {
                coordinateSystem = 1.replace((CartesianCS)coordinateSystem, false);
            }
            return coordinateSystem;
        }
    }
    ,
    ESRI((Unit<Angle>)NonSI.DEGREE_ANGLE, true),
    ORACLE(null, true),
    NETCDF(null, false),
    GEOTIFF(null, false),
    PROJ4((Unit<Angle>)NonSI.DEGREE_ANGLE, false),
    INTERNAL(null, false){

        @Override
        public CoordinateSystem toConformCS(CoordinateSystem coordinateSystem) {
            return coordinateSystem;
        }

        @Override
        Citation createCitation() {
            DefaultCitation defaultCitation = new DefaultCitation((CharSequence)"Internal WKT");
            defaultCitation.setCitedResponsibleParties(Citations.GEOTOOLKIT.getCitedResponsibleParties());
            defaultCitation.freeze();
            return defaultCitation;
        }
    };

    private static final DefaultCartesianCS LEGACY;
    public final Unit<Angle> forcedAngularUnit;
    final boolean unitUS;
    private transient Citation citation;

    private Convention(Unit<Angle> unit, boolean bl) {
        this.forcedAngularUnit = unit;
        this.unitUS = bl;
    }

    public Citation getCitation() {
        Citation citation = this.citation;
        if (citation == null) {
            this.citation = citation = this.createCitation();
        }
        return citation;
    }

    Citation createCitation() {
        try {
            return (Citation)Citations.class.getField(this.name()).get(null);
        }
        catch (Exception exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public static Convention forCitation(Citation citation, Convention convention) {
        if (citation != null) {
            for (Convention convention2 : Convention.values()) {
                if (!Citations.identifierMatches((Citation)convention2.getCitation(), (Citation)citation)) continue;
                return convention2;
            }
        }
        return convention;
    }

    public static Convention forIdentifier(String string, Convention convention) {
        if (string != null) {
            for (Convention convention2 : Convention.values()) {
                if (!Citations.identifierMatches((Citation)convention2.getCitation(), (String)string)) continue;
                return convention2;
            }
        }
        return convention;
    }

    public CoordinateSystem toConformCS(CoordinateSystem coordinateSystem) {
        if (coordinateSystem instanceof CartesianCS) {
            coordinateSystem = Convention.replace((CartesianCS)coordinateSystem, true);
        }
        return coordinateSystem;
    }

    static CartesianCS replace(CartesianCS cartesianCS, boolean bl) {
        DefaultCartesianCS defaultCartesianCS = bl ? DefaultCartesianCS.GEOCENTRIC : LEGACY;
        int n = defaultCartesianCS.getDimension();
        if (cartesianCS.getDimension() != n) {
            return cartesianCS;
        }
        for (int i = 0; i < n; ++i) {
            if (cartesianCS.getAxis(i).getDirection().equals(defaultCartesianCS.getAxis(i).getDirection())) continue;
            return cartesianCS;
        }
        return bl ? LEGACY : DefaultCartesianCS.GEOCENTRIC;
    }

    static {
        LEGACY = new DefaultCartesianCS("Legacy", (CoordinateSystemAxis)new DefaultCoordinateSystemAxis("X", AxisDirection.OTHER, (Unit<?>)SI.METRE), (CoordinateSystemAxis)new DefaultCoordinateSystemAxis("Y", AxisDirection.EAST, (Unit<?>)SI.METRE), (CoordinateSystemAxis)new DefaultCoordinateSystemAxis("Z", AxisDirection.NORTH, (Unit<?>)SI.METRE));
    }
}

