/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.parameter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.unit.Unit;
import org.geotoolkit.lang.Static;
import org.geotoolkit.metadata.iso.quality.DefaultConformanceResult;
import org.geotoolkit.parameter.AbstractParameter;
import org.geotoolkit.parameter.DefaultParameterDescriptorGroup;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.geotoolkit.resources.Descriptions;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.resources.Vocabulary;
import org.geotoolkit.util.logging.Logging;
import org.opengis.metadata.quality.ConformanceResult;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.InternationalString;

public final class Parameters
extends Static {
    private static final double EPS = 1.0E-8;
    private static final InternationalString EXPLAIN = Descriptions.formatInternational((int)6);
    public static final ParameterDescriptorGroup EMPTY_GROUP = new DefaultParameterDescriptorGroup(Vocabulary.format((int)94), new GeneralParameterDescriptor[0]);

    private Parameters() {
    }

    public static <T> ParameterDescriptor<T> cast(ParameterDescriptor<?> parameterDescriptor, Class<T> clazz) throws ClassCastException {
        Class<?> clazz2;
        if (parameterDescriptor != null && !clazz.equals(clazz2 = parameterDescriptor.getValueClass())) {
            throw new ClassCastException(Errors.format((int)13, (Object)parameterDescriptor.getName().getCode(), clazz2));
        }
        return parameterDescriptor;
    }

    public static <T> ParameterValue<T> cast(ParameterValue<?> parameterValue, Class<T> clazz) throws ClassCastException {
        ParameterDescriptor<?> parameterDescriptor;
        Class<?> clazz2;
        if (parameterValue != null && !clazz.equals(clazz2 = (parameterDescriptor = parameterValue.getDescriptor()).getValueClass())) {
            throw new ClassCastException(Errors.format((int)13, (Object)parameterDescriptor.getName().getCode(), clazz2));
        }
        return parameterValue;
    }

    public static boolean isValid(ParameterValue<?> parameterValue) {
        return Parameters.isValidValue(parameterValue.getDescriptor(), parameterValue.getValue(), false) == null;
    }

    private static <T> InternationalString isValidValue(ParameterDescriptor<T> parameterDescriptor, Object object, boolean bl) {
        if (object == null) {
            if (parameterDescriptor.getMinimumOccurs() == 0) {
                return null;
            }
            return bl ? Errors.formatInternational((int)119, (Object)AbstractParameter.getName(parameterDescriptor)) : EXPLAIN;
        }
        Class<?> clazz = object.getClass();
        Class<T> clazz2 = parameterDescriptor.getValueClass();
        if (!clazz2.isAssignableFrom(clazz)) {
            return bl ? Errors.formatInternational((int)76, (Object[])new Object[]{clazz, clazz2}) : EXPLAIN;
        }
        T t = clazz2.cast(object);
        Comparable<T> comparable = parameterDescriptor.getMinimumValue();
        Comparable<T> comparable2 = parameterDescriptor.getMaximumValue();
        if (comparable != null && comparable.compareTo(t) > 0 || comparable2 != null && comparable2.compareTo(t) < 0) {
            return bl ? Errors.formatInternational((int)246, (Object[])new Object[]{object, comparable, comparable2}) : EXPLAIN;
        }
        Set<T> set = parameterDescriptor.getValidValues();
        if (set != null && !set.contains(object)) {
            return bl ? Errors.formatInternational((int)73, (Object[])new Object[]{AbstractParameter.getName(parameterDescriptor), object}) : EXPLAIN;
        }
        return null;
    }

    public static ConformanceResult isValid(GeneralParameterValue generalParameterValue, GeneralParameterDescriptor generalParameterDescriptor) {
        DefaultConformanceResult defaultConformanceResult = new DefaultConformanceResult(generalParameterDescriptor.getName().getAuthority(), EXPLAIN, true);
        GeneralParameterValue generalParameterValue2 = Parameters.isValid(generalParameterValue, generalParameterDescriptor, defaultConformanceResult);
        if (generalParameterValue2 != null) {
            ReferenceIdentifier referenceIdentifier = generalParameterValue2.getDescriptor().getName();
            defaultConformanceResult.setExplanation(Descriptions.formatInternational((int)10, (Object[])new Object[]{referenceIdentifier, defaultConformanceResult.getExplanation()}));
            defaultConformanceResult.setSpecification(referenceIdentifier.getAuthority());
            defaultConformanceResult.setPass(Boolean.FALSE);
        }
        return defaultConformanceResult;
    }

    private static GeneralParameterValue isValid(GeneralParameterValue generalParameterValue, GeneralParameterDescriptor generalParameterDescriptor, DefaultConformanceResult defaultConformanceResult) {
        if (generalParameterDescriptor instanceof ParameterDescriptor) {
            if (generalParameterValue instanceof ParameterValue) {
                InternationalString internationalString = Parameters.isValidValue((ParameterDescriptor)generalParameterDescriptor, ((ParameterValue)generalParameterValue).getValue(), true);
                if (internationalString != null) {
                    defaultConformanceResult.setExplanation(internationalString);
                    return generalParameterValue;
                }
                return null;
            }
        } else if (generalParameterDescriptor instanceof ParameterDescriptorGroup && generalParameterValue instanceof ParameterValueGroup) {
            Object object;
            HashMap<GeneralParameterDescriptor, Integer> hashMap = new HashMap<GeneralParameterDescriptor, Integer>();
            ParameterDescriptorGroup parameterDescriptorGroup = (ParameterDescriptorGroup)generalParameterDescriptor;
            for (GeneralParameterValue object2 : ((ParameterValueGroup)generalParameterValue).values()) {
                GeneralParameterDescriptor generalParameterDescriptor2;
                object = Parameters.getName(object2.getDescriptor(), parameterDescriptorGroup);
                try {
                    generalParameterDescriptor2 = parameterDescriptorGroup.descriptor((String)object);
                }
                catch (ParameterNotFoundException n3) {
                    defaultConformanceResult.setExplanation(Errors.formatInternational((int)210, (Object)object));
                    return generalParameterValue;
                }
                GeneralParameterValue generalParameterValue2 = Parameters.isValid(object2, generalParameterDescriptor2, defaultConformanceResult);
                if (generalParameterValue2 != null) {
                    return generalParameterValue2;
                }
                Integer n = hashMap.put(generalParameterDescriptor2, 1);
                if (n == null) continue;
                hashMap.put(generalParameterDescriptor2, n + 1);
            }
            for (GeneralParameterDescriptor generalParameterDescriptor3 : parameterDescriptorGroup.descriptors()) {
                Object[] objectArray;
                int n;
                object = (Integer)hashMap.get(generalParameterDescriptor3);
                int n2 = object != null ? (Integer)object : 0;
                int n3 = generalParameterDescriptor3.getMinimumOccurs();
                int n4 = generalParameterDescriptor3.getMaximumOccurs();
                if (n2 >= n3 && n2 <= n4) continue;
                String string = generalParameterDescriptor3.getName().getCode();
                if (n2 == 0) {
                    n = 119;
                    objectArray = new Object[]{string};
                } else {
                    n = 86;
                    objectArray = new Object[]{string, object, n3, n4};
                }
                defaultConformanceResult.setExplanation(Errors.formatInternational((int)n, (Object[])objectArray));
                return generalParameterValue;
            }
            return null;
        }
        Class clazz = generalParameterValue instanceof ParameterValue ? ParameterValue.class : (generalParameterValue instanceof ParameterValueGroup ? ParameterValueGroup.class : GeneralParameterValue.class);
        defaultConformanceResult.setExplanation(Errors.formatInternational((int)87, clazz));
        return generalParameterValue;
    }

    private static String getName(GeneralParameterDescriptor generalParameterDescriptor, ParameterDescriptorGroup parameterDescriptorGroup) {
        String string = IdentifiedObjects.getName(generalParameterDescriptor, parameterDescriptorGroup.getName().getAuthority());
        if (string == null) {
            string = generalParameterDescriptor.getName().getCode();
        }
        return string;
    }

    private static ParameterValue<?> getParameter(ParameterDescriptor<?> parameterDescriptor, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        String string = Parameters.getName(parameterDescriptor, parameterValueGroup.getDescriptor());
        if (parameterDescriptor.getMinimumOccurs() != 0) {
            return parameterValueGroup.parameter(string);
        }
        GeneralParameterDescriptor generalParameterDescriptor = parameterValueGroup.getDescriptor().descriptor(string);
        if (generalParameterDescriptor instanceof ParameterDescriptor) {
            for (GeneralParameterValue generalParameterValue : parameterValueGroup.values()) {
                if (!generalParameterDescriptor.equals(generalParameterValue.getDescriptor())) continue;
                return (ParameterValue)generalParameterValue;
            }
        }
        return null;
    }

    public static ParameterValue<?> getOrCreate(ParameterDescriptor<?> parameterDescriptor, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        return Parameters.cast(parameterValueGroup.parameter(Parameters.getName(parameterDescriptor, parameterValueGroup.getDescriptor())), parameterDescriptor.getValueClass());
    }

    public static <T> T value(ParameterDescriptor<T> parameterDescriptor, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        ParameterValue<?> parameterValue = Parameters.getParameter(parameterDescriptor, parameterValueGroup);
        return parameterValue != null ? (T)parameterDescriptor.getValueClass().cast(parameterValue.getValue()) : null;
    }

    public static String stringValue(ParameterDescriptor<?> parameterDescriptor, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        ParameterValue<?> parameterValue = Parameters.getParameter(parameterDescriptor, parameterValueGroup);
        return parameterValue != null ? parameterValue.stringValue() : null;
    }

    public static Boolean booleanValue(ParameterDescriptor<?> parameterDescriptor, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        ParameterValue<?> parameterValue = Parameters.getParameter(parameterDescriptor, parameterValueGroup);
        return parameterValue != null ? Boolean.valueOf(parameterValue.booleanValue()) : null;
    }

    public static Integer integerValue(ParameterDescriptor<?> parameterDescriptor, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        ParameterValue<?> parameterValue = Parameters.getParameter(parameterDescriptor, parameterValueGroup);
        return parameterValue != null ? Integer.valueOf(parameterValue.intValue()) : null;
    }

    public static int[] integerValueList(ParameterDescriptor<?> parameterDescriptor, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        ParameterValue<?> parameterValue = Parameters.getParameter(parameterDescriptor, parameterValueGroup);
        return parameterValue != null ? parameterValue.intValueList() : null;
    }

    public static double doubleValue(ParameterDescriptor<?> parameterDescriptor, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        Unit<?> unit = parameterDescriptor.getUnit();
        ParameterValue<?> parameterValue = Parameters.getParameter(parameterDescriptor, parameterValueGroup);
        return parameterValue == null ? Double.NaN : (unit != null ? parameterValue.doubleValue(unit) : parameterValue.doubleValue());
    }

    public static double[] doubleValueList(ParameterDescriptor<?> parameterDescriptor, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        Unit<?> unit = parameterDescriptor.getUnit();
        ParameterValue<?> parameterValue = Parameters.getParameter(parameterDescriptor, parameterValueGroup);
        return parameterValue == null ? null : (unit != null ? parameterValue.doubleValueList(unit) : parameterValue.doubleValueList());
    }

    public static List<GeneralParameterValue> search(GeneralParameterValue generalParameterValue, String string, int n) {
        ArrayList<GeneralParameterValue> arrayList = new ArrayList<GeneralParameterValue>();
        Parameters.search(generalParameterValue, string, n, arrayList);
        return arrayList;
    }

    private static void search(GeneralParameterValue generalParameterValue, String string, int n, Collection<GeneralParameterValue> collection) {
        if (n >= 0) {
            if (IdentifiedObjects.nameMatches((IdentifiedObject)generalParameterValue.getDescriptor(), string)) {
                collection.add(generalParameterValue);
            }
            if (n != 0 && generalParameterValue instanceof ParameterValueGroup) {
                for (GeneralParameterValue generalParameterValue2 : ((ParameterValueGroup)generalParameterValue).values()) {
                    Parameters.search(generalParameterValue2, string, n - 1, collection);
                }
            }
        }
    }

    public static void copy(GeneralParameterValue generalParameterValue, Map<? super String, Object> map) {
        Parameters.copy(generalParameterValue, map, null, 0, true);
    }

    /*
     * WARNING - void declaration
     */
    private static StringBuilder copy(GeneralParameterValue generalParameterValue, Map<? super String, Object> map, StringBuilder stringBuilder, int n, boolean bl) {
        String string = generalParameterValue.getDescriptor().getName().getCode();
        if (generalParameterValue instanceof ParameterValue) {
            void var7_9;
            Object object;
            Object t = ((ParameterValue)generalParameterValue).getValue();
            String object2 = string;
            if (n > 0) {
                stringBuilder.setLength(n);
                String string2 = stringBuilder.append(string).toString();
            }
            if ((object = map.put((String)var7_9, t)) != null && !object.equals(t)) {
                throw new IllegalArgumentException(Errors.format((int)95));
            }
        }
        if (generalParameterValue instanceof ParameterValueGroup) {
            if (!bl) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(32);
                }
                stringBuilder.setLength(n);
                n = stringBuilder.append(string).append(':').length();
            }
            for (GeneralParameterValue generalParameterValue2 : ((ParameterValueGroup)generalParameterValue).values()) {
                stringBuilder = Parameters.copy(generalParameterValue2, map, stringBuilder, n, false);
            }
        }
        return stringBuilder;
    }

    public static void copy(ParameterValueGroup parameterValueGroup, ParameterValueGroup parameterValueGroup2) {
        for (GeneralParameterValue generalParameterValue : parameterValueGroup.values()) {
            String string = generalParameterValue.getDescriptor().getName().getCode();
            if (generalParameterValue instanceof ParameterValueGroup) {
                Parameters.copy((ParameterValueGroup)generalParameterValue, parameterValueGroup2.addGroup(string));
                continue;
            }
            parameterValueGroup2.parameter(string).setValue(((ParameterValue)generalParameterValue).getValue());
        }
    }

    public static boolean ensureSet(ParameterValueGroup parameterValueGroup, String string, double d, Unit<?> unit, boolean bl) throws ParameterNotFoundException {
        ParameterValue<?> parameterValue = parameterValueGroup.parameter(string);
        try {
            double d2 = parameterValue.doubleValue(unit);
            if (Math.abs(d2 / d - 1.0) <= 1.0E-8) {
                return false;
            }
            if (Double.isNaN(d2)) {
                bl = true;
            }
        }
        catch (IllegalStateException illegalStateException) {
            bl = true;
        }
        if (bl) {
            parameterValue.setValue(d, unit);
        } else {
            Logging.log(Parameters.class, (String)"ensureSet", (LogRecord)new LogRecord(Level.FINE, Errors.format((int)245, (Object)string)));
        }
        return true;
    }
}

