/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.operation.projection;

import net.jcip.annotations.Immutable;
import org.geotoolkit.referencing.operation.matrix.Matrix2;
import org.geotoolkit.referencing.operation.projection.Assertions;
import org.geotoolkit.referencing.operation.projection.ProjectionException;
import org.geotoolkit.referencing.operation.projection.Stereographic;
import org.geotoolkit.referencing.operation.projection.UnitaryProjection;
import org.opengis.referencing.operation.Matrix;

@Immutable
public class EquatorialStereographic
extends Stereographic {
    private static final long serialVersionUID = -5098015759558831875L;

    protected EquatorialStereographic(UnitaryProjection.Parameters parameters) {
        super(parameters);
        assert (this.\u03c60 == 0.0) : this.\u03c60;
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6 = this.rollLongitude(dArray[n]);
        double d7 = dArray[n + 1];
        double d8 = Math.sin(d7);
        double d9 = Math.sin(d6);
        double d10 = Math.cos(d6);
        double d11 = this.ssfn(d7, d8);
        if (dArray2 != null) {
            d5 = 2.0 * Math.atan(d11) - 1.5707963267948966;
            d4 = Math.cos(d5);
            d3 = 1.0 + d4 * d10;
            d2 = d4 * d9 / d3;
            d = Math.sin(d5) / d3;
            assert (super.transform(dArray, n, dArray2, n2, false) == null && Assertions.checkTransform(dArray2, n2, d2, d));
            dArray2[n2] = d2;
            dArray2[n2 + 1] = d;
        }
        if (!bl) {
            return null;
        }
        d5 = 1.0 + d11 * d11;
        d4 = 2.0 * this.dssfn_d\u03c6(d7, d8, Math.cos(d7)) * d11 / d5;
        d3 = (d11 * d11 - 1.0) / d5;
        d2 = 2.0 * d11 / d5;
        d = d2 * d10;
        double d12 = d2 * d9;
        double d13 = d3 * d10;
        double d14 = 1.0 + d;
        return new Matrix2((d12 * d12 / d14 + d) / d14, (d13 * d12 / d14 - d3 * d9) * d4 / d14, d12 * d3 / (d14 * d14), (d13 * d3 / d14 + d2) * d4 / d14);
    }

    @Immutable
    static final class Spherical
    extends EquatorialStereographic {
        private static final long serialVersionUID = -4790138052004333003L;

        protected Spherical(UnitaryProjection.Parameters parameters) {
            super(parameters);
            parameters.ensureSpherical();
        }

        @Override
        final boolean isSpherical() {
            return true;
        }

        @Override
        public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
            double d = this.rollLongitude(dArray[n]);
            double d2 = dArray[n + 1];
            double d3 = Math.sin(d2);
            double d4 = Math.sin(d);
            double d5 = Math.cos(d2);
            double d6 = Math.cos(d);
            double d7 = d5 * d6;
            double d8 = d5 * d4;
            double d9 = 1.0 + d7;
            double d10 = d8 / d9;
            double d11 = d3 / d9;
            Matrix2 matrix2 = null;
            if (bl) {
                double d12 = d3 * d6;
                matrix2 = new Matrix2((d8 * d8 / d9 + d7) / d9, (d12 * d8 / d9 - d3 * d4) / d9, d8 * d3 / (d9 * d9), (d12 * d3 / d9 + d5) / d9);
            }
            assert (Assertions.checkDerivative(matrix2, super.transform(dArray, n, dArray2, n2, bl)) && Assertions.checkTransform(dArray2, n2, d10, d11));
            if (dArray2 != null) {
                dArray2[n2] = d10;
                dArray2[n2 + 1] = d11;
            }
            return matrix2;
        }

        @Override
        protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
            double d = dArray[n];
            double d2 = dArray[n + 1];
            double d3 = Math.hypot(d, d2);
            if (d3 < 1.0E-6) {
                d2 = 0.0;
                d = 0.0;
            } else {
                double d4 = 2.0 * Math.atan(d3);
                double d5 = Math.sin(d4);
                double d6 = d3 * Math.cos(d4);
                double d7 = d * d5;
                d2 = Math.asin(d2 * d5 / d3);
                d = Math.atan2(d7, d6);
            }
            d = this.unrollLongitude(d);
            assert (this.checkInverseTransform(dArray, n, dArray2, n2, d, d2));
            dArray2[n2] = d;
            dArray2[n2 + 1] = d2;
        }

        private boolean checkInverseTransform(double[] dArray, int n, double[] dArray2, int n2, double d, double d2) throws ProjectionException {
            super.inverseTransform(dArray, n, dArray2, n2);
            return Assertions.checkInverseTransform(dArray2, n2, d, d2);
        }
    }
}

