/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.math;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.Serializable;
import javax.vecmath.MismatchedSizeException;
import org.geotoolkit.util.Cloneable;
import org.geotoolkit.util.Utilities;

public class Line
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 2185952238314399110L;
    private static final double EPS = 1.0E-12;
    private double slope;
    private double y0;
    private double x0;

    public Line() {
        this.x0 = Double.NaN;
        this.y0 = Double.NaN;
        this.slope = Double.NaN;
    }

    public Line(double d, double d2) {
        this.slope = d;
        this.y0 = d2;
        this.x0 = -d2 / d;
    }

    public void setLine(double d, double d2) {
        this.slope = d;
        this.y0 = d2;
        this.x0 = -d2 / d;
    }

    public void setLine(Line2D line2D) {
        this.setLine(line2D.getX1(), line2D.getY1(), line2D.getX2(), line2D.getY2());
    }

    public void setLine(Point2D point2D, Point2D point2D2) {
        this.setLine(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
    }

    private void setLine(double d, double d2, double d3, double d4) {
        this.slope = (d4 - d2) / (d3 - d);
        this.x0 = d3 - d4 / this.slope;
        this.y0 = d4 - this.slope * d3;
        if (Double.isNaN(this.x0) && this.slope == 0.0) {
            this.x0 = Double.POSITIVE_INFINITY;
        }
        if (Double.isNaN(this.y0) && Double.isInfinite(this.slope)) {
            this.y0 = Double.POSITIVE_INFINITY;
        }
    }

    public double fit(double[] dArray, double[] dArray2) throws MismatchedSizeException {
        int n = dArray.length;
        if (n != dArray2.length) {
            throw new MismatchedSizeException();
        }
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d5 = dArray[i];
            double d6 = dArray2[i];
            if (Double.isNaN(d5) || Double.isNaN(d6)) continue;
            d2 = d5 + (d - (d += (d5 += d2)));
            d4 = d6 + (d3 - (d3 += (d6 += d4)));
            ++n2;
        }
        d /= (double)n2;
        d3 /= (double)n2;
        double d7 = 0.0;
        d2 = 0.0;
        double d8 = 0.0;
        d4 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d11 = dArray[i];
            double d12 = dArray2[i];
            if (Double.isNaN(d11) || Double.isNaN(d12)) continue;
            double d13 = (d11 -= d) * d11;
            double d14 = d12 * d12;
            double d15 = d11 * d12;
            d2 = d13 + (d7 - (d7 += (d13 += d2)));
            d4 = d14 + (d8 - (d8 += (d14 += d4)));
            d10 = d15 + (d9 - (d9 += (d15 += d10)));
        }
        double d16 = (d9 /= (double)n2) / (d7 /= (double)n2);
        this.setLine(d16, d3 - d * d16);
        return d9 / Math.sqrt(d7 * ((d8 /= (double)n2) - d3 * d3));
    }

    public void translate(double d, double d2) {
        if (this.slope == 0.0 || Double.isInfinite(this.slope)) {
            this.x0 += d;
            this.y0 += d2;
        } else {
            this.x0 += d - d2 / this.slope;
            this.y0 += d2 - this.slope * d;
        }
    }

    public final double y(double d) {
        return this.slope * d + this.y0;
    }

    public final double x(double d) {
        return d / this.slope + this.x0;
    }

    public final double getY0() {
        return this.y0;
    }

    public final double getX0() {
        return this.x0;
    }

    public final double getSlope() {
        return this.slope;
    }

    public Point2D intersectionPoint(Line line) {
        double d;
        double d2;
        if (Double.isInfinite(this.slope)) {
            if (Double.isInfinite(line.slope)) {
                return null;
            }
            d2 = this.x0;
            d = d2 * line.slope + line.y0;
        } else {
            if (!Double.isInfinite(line.slope)) {
                d2 = (this.y0 - line.y0) / (line.slope - this.slope);
                if (Double.isInfinite(d2)) {
                    return null;
                }
            } else {
                d2 = line.x0;
            }
            d = d2 * this.slope + this.y0;
        }
        return new Point2D.Double(d2, d);
    }

    public Point2D intersectionPoint(Line2D line2D) {
        double d;
        double d2;
        double d3 = line2D.getX1();
        double d4 = line2D.getY1();
        double d5 = line2D.getX2();
        double d6 = line2D.getY2();
        double d7 = (d6 - d4) / (d5 - d3);
        if (Double.isInfinite(this.slope)) {
            d2 = this.x0;
            d = d2 * d7 + (d6 - d7 * d5);
        } else {
            d2 = !Double.isInfinite(d7) ? (this.y0 - (d6 - d7 * d5)) / (d7 - this.slope) : 0.5 * (d3 + d5);
            d = d2 * this.slope + this.y0;
        }
        double d8 = 1.0E-12 * Math.abs(d2);
        if (d3 <= d5 ? !(d2 >= d3 - d8) || !(d2 <= d5 + d8) : !(d2 <= d3 + d8) || !(d2 >= d5 - d8)) {
            return null;
        }
        d8 = 1.0E-12 * Math.abs(d);
        if (d4 <= d6 ? !(d >= d4 - d8) || !(d <= d6 + d8) : !(d <= d4 - d8) || !(d >= d6 + d8)) {
            return null;
        }
        return new Point2D.Double(d2, d);
    }

    public Point2D nearestColinearPoint(Point2D point2D) {
        if (!Double.isInfinite(this.slope)) {
            double d = ((point2D.getY() - this.y0) * this.slope + point2D.getX()) / (this.slope * this.slope + 1.0);
            return new Point2D.Double(d, d * this.slope + this.y0);
        }
        return new Point2D.Double(this.x0, point2D.getY());
    }

    public Line2D isoscelesTriangleBase(Point2D point2D, double d) {
        double d2;
        d *= d;
        if (this.slope == 0.0) {
            double d3 = point2D.getX();
            double d4 = this.y0 - point2D.getY();
            double d5 = Math.sqrt(d - d4 * d4);
            if (Double.isNaN(d5)) {
                return null;
            }
            return new Line2D.Double(d3 + d5, this.y0, d3 - d5, this.y0);
        }
        if (Double.isInfinite(this.slope)) {
            double d6 = point2D.getY();
            double d7 = this.x0 - point2D.getX();
            double d8 = Math.sqrt(d - d7 * d7);
            if (Double.isNaN(d8)) {
                return null;
            }
            return new Line2D.Double(this.x0, d6 + d8, this.x0, d6 - d8);
        }
        double d9 = point2D.getX();
        double d10 = point2D.getY();
        double d11 = this.y0 - d10 + this.slope * d9;
        double d12 = -this.slope * d11;
        double d13 = Math.sqrt(d12 * d12 + (d2 = this.slope * this.slope + 1.0) * (d - d11 * d11));
        if (Double.isNaN(d13)) {
            return null;
        }
        double d14 = (d12 + d13) / d2 + d9;
        double d15 = (d12 - d13) / d2 + d9;
        return new Line2D.Double(d14, this.slope * d14 + this.y0, d15, this.slope * d15 + this.y0);
    }

    public String toString() {
        if (!Double.isInfinite(this.slope)) {
            StringBuilder stringBuilder = new StringBuilder("y= ");
            if (this.slope != 0.0) {
                stringBuilder.append(this.slope).append("*x");
                if (this.y0 != 0.0) {
                    stringBuilder.append(" + ");
                } else {
                    return stringBuilder.toString();
                }
            }
            return stringBuilder.append(this.y0).toString();
        }
        return "x= " + this.x0;
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass() == object.getClass()) {
            Line line = (Line)object;
            return Utilities.equals(this.slope, line.slope) && Utilities.equals(this.y0, line.y0) && Utilities.equals(this.x0, line.x0);
        }
        return false;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.slope) + 31L * Double.doubleToLongBits(this.y0);
        return (int)l ^ (int)(l >>> 32) ^ 0xA4B32586;
    }

    @Override
    public Line clone() {
        try {
            return (Line)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }
}

