/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.resources;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.resources.Loader;
import org.geotoolkit.util.Strings;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.logging.Logging;
import org.opengis.util.InternationalString;

@ThreadSafe
public class IndexedResourceBundle
extends ResourceBundle {
    public static volatile boolean immediateLocalization;
    private static final int MAX_STRING_LENGTH = 200;
    private final String filename;
    private String[] values;
    private transient Locale formatLocale;
    private transient MessageFormat format;
    private transient int lastKey;

    protected IndexedResourceBundle(String string) {
        this.filename = string;
    }

    protected static <T extends IndexedResourceBundle> T getBundle(Class<T> clazz, Locale locale) throws MissingResourceException {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return (T)((IndexedResourceBundle)clazz.cast(IndexedResourceBundle.getBundle(clazz.getName(), locale, clazz.getClassLoader(), Loader.INSTANCE)));
    }

    private Locale getFormatLocale() {
        if (this.formatLocale == null) {
            this.formatLocale = Locale.getDefault();
            Locale locale = this.getLocale();
            if (locale != null && !this.formatLocale.getLanguage().equalsIgnoreCase(locale.getLanguage())) {
                this.formatLocale = locale;
            }
        }
        return this.formatLocale;
    }

    public final void list(Writer writer) throws IOException {
        IndexedResourceBundle.list(writer, this.ensureLoaded(null));
    }

    private static void list(Writer writer, String[] stringArray) throws IOException {
        String string = System.getProperty("line.separator", "\n");
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            String string2 = stringArray[i];
            if (string2 == null) continue;
            int n2 = string2.indexOf(13);
            if (n2 < 0) {
                n2 = string2.length();
            }
            if ((n = string2.indexOf(10)) < 0) {
                n = string2.length();
            }
            String string3 = String.valueOf(i);
            writer.write(Strings.spaces(5 - string3.length()));
            writer.write(string3);
            writer.write(":\t");
            writer.write(string2, 0, Math.min(n2, n));
            writer.write(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] ensureLoaded(String string) throws MissingResourceException {
        String string2 = string != null ? "getObject" : "getKeys";
        LogRecord logRecord = null;
        try {
            String[] stringArray;
            IndexedResourceBundle indexedResourceBundle = this;
            synchronized (indexedResourceBundle) {
                int n;
                InputStream inputStream;
                stringArray = this.values;
                if (stringArray != null) {
                    return stringArray;
                }
                logRecord = new LogRecord(Level.FINER, "Loaded resources for {0} from bundle \"{1}\".");
                String string3 = this.filename;
                while ((inputStream = this.getClass().getResourceAsStream(string3)) == null) {
                    int n2 = string3.lastIndexOf(46);
                    n = string3.lastIndexOf(95, n2 - 1);
                    if (n <= 0) {
                        throw new FileNotFoundException(this.filename);
                    }
                    int n3 = string3.length();
                    string3 = new StringBuilder(n + (n3 - n2)).append(string3, 0, n).append(string3, n2, n3).toString();
                }
                DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
                stringArray = new String[dataInputStream.readInt()];
                this.values = stringArray;
                for (n = 0; n < stringArray.length; ++n) {
                    stringArray[n] = dataInputStream.readUTF();
                    if (!stringArray[n].isEmpty()) continue;
                    stringArray[n] = null;
                }
                dataInputStream.close();
                String string4 = null;
                Locale locale = this.getLocale();
                if (locale != null) {
                    string4 = locale.getDisplayName(Locale.US);
                }
                if (string4 == null || string4.isEmpty()) {
                    string4 = "<default>";
                }
                logRecord.setParameters(new String[]{string4, this.getClass().getCanonicalName()});
            }
            Logging.log(IndexedResourceBundle.class, string2, logRecord);
            return stringArray;
        }
        catch (IOException iOException) {
            logRecord.setLevel(Level.WARNING);
            logRecord.setMessage(iOException.getLocalizedMessage());
            logRecord.setThrown(iOException);
            Logging.log(IndexedResourceBundle.class, string2, logRecord);
            MissingResourceException missingResourceException = new MissingResourceException(iOException.getLocalizedMessage(), this.getClass().getCanonicalName(), string);
            missingResourceException.initCause(iOException);
            throw missingResourceException;
        }
    }

    @Override
    public final Enumeration<String> getKeys() {
        return new KeyEnum(this.ensureLoaded(null));
    }

    @Override
    protected final Object handleGetObject(String string) {
        int n;
        String[] stringArray = this.ensureLoaded(string);
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return n >= 0 && n < stringArray.length ? stringArray[n] : null;
    }

    private static String summarize(String string, int n) {
        int n2;
        int n3 = (string = Strings.trim(string)).length();
        if (n3 <= n) {
            return string;
        }
        if ((n = n - 7 >> 1) <= 0) {
            return string;
        }
        int n4 = n3 - n;
        int n5 = n >> 1;
        for (n2 = n; n2 >= n5; --n2) {
            if (Character.isUnicodeIdentifierPart(string.charAt(n2))) continue;
            while (--n2 >= n5 && !Character.isUnicodeIdentifierPart(string.charAt(n2))) {
            }
            break;
        }
        n5 = n3 - (n >> 1);
        while (n4 < n5) {
            if (!Character.isUnicodeIdentifierPart(string.charAt(n4))) {
                while (++n4 < n5 && !Character.isUnicodeIdentifierPart(string.charAt(n4))) {
                }
                break;
            }
            ++n4;
        }
        return Strings.trim(new StringBuilder(n2 + (n3 - n4) + 6).append(string, 0, n2 + 1).append(" (\u2026) ").append(string, n4, n3).toString());
    }

    private Object[] toArray(Object object) {
        Object[] objectArray = object instanceof Object[] ? (Object[])object : new Object[]{object};
        for (int i = 0; i < objectArray.length; ++i) {
            String string;
            Object object2 = objectArray[i];
            if (object2 instanceof CharSequence) {
                String string2;
                string = object2 instanceof InternationalString ? ((InternationalString)object2).toString(this.getFormatLocale()) : object2.toString();
                if (string.equals(string2 = IndexedResourceBundle.summarize(string, 200))) continue;
                if (objectArray == object) {
                    objectArray = new Object[objectArray.length];
                    System.arraycopy(object, 0, objectArray, 0, objectArray.length);
                }
                objectArray[i] = string2;
                continue;
            }
            if (object2 instanceof Throwable) {
                string = ((Throwable)object2).getLocalizedMessage();
                if (string == null) {
                    string = Classes.getShortClassName(object2);
                }
                objectArray[i] = string;
                continue;
            }
            if (!(object2 instanceof Class)) continue;
            objectArray[i] = Classes.getShortName((Class)object2);
        }
        return objectArray;
    }

    public final String getMenuLabel(int n) throws MissingResourceException {
        return this.getString(n) + "...";
    }

    public final String getLabel(int n) throws MissingResourceException {
        return this.getString(n) + ": ";
    }

    public final String getString(int n) throws MissingResourceException {
        return this.getString(String.valueOf(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getString(int n, Object object) throws MissingResourceException {
        String string = this.getString(n);
        Object[] objectArray = this.toArray(object);
        IndexedResourceBundle indexedResourceBundle = this;
        synchronized (indexedResourceBundle) {
            if (this.format == null) {
                this.format = new MessageFormat(string, this.getFormatLocale());
            } else if (n != this.lastKey) {
                this.format.applyPattern(string);
                this.lastKey = n;
            }
            try {
                return this.format.format(objectArray);
            }
            catch (RuntimeException runtimeException) {
                return "[Unformattable message: " + runtimeException + ']';
            }
        }
    }

    public final String getString(int n, Object object, Object object2) throws MissingResourceException {
        return this.getString(n, new Object[]{object, object2});
    }

    public final String getString(int n, Object object, Object object2, Object object3) throws MissingResourceException {
        return this.getString(n, new Object[]{object, object2, object3});
    }

    public final String getString(int n, Object object, Object object2, Object object3, Object object4) throws MissingResourceException {
        return this.getString(n, new Object[]{object, object2, object3, object4});
    }

    public final String getString(int n, Object object, Object object2, Object object3, Object object4, Object object5) throws MissingResourceException {
        return this.getString(n, new Object[]{object, object2, object3, object4, object5});
    }

    public LogRecord getLogRecord(Level level, int n) {
        return this.getLogRecord(level, n, null);
    }

    public LogRecord getLogRecord(Level level, int n, Object object) {
        if (immediateLocalization) {
            return new LogRecord(level, this.getString(n, object));
        }
        LogRecord logRecord = new LogRecord(level, String.valueOf(n));
        logRecord.setResourceBundle(this);
        if (object != null) {
            logRecord.setParameters(this.toArray(object));
        }
        return logRecord;
    }

    public LogRecord getLogRecord(Level level, int n, Object object, Object object2) {
        return this.getLogRecord(level, n, new Object[]{object, object2});
    }

    public LogRecord getLogRecord(Level level, int n, Object object, Object object2, Object object3) {
        return this.getLogRecord(level, n, new Object[]{object, object2, object3});
    }

    public LogRecord getLogRecord(Level level, int n, Object object, Object object2, Object object3, Object object4) {
        return this.getLogRecord(level, n, new Object[]{object, object2, object3, object4});
    }

    public static String format(LogRecord logRecord) {
        String string = logRecord.getMessage();
        ResourceBundle resourceBundle = logRecord.getResourceBundle();
        if (resourceBundle instanceof IndexedResourceBundle) {
            int n = -1;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                IndexedResourceBundle.unexpectedException(numberFormatException);
            }
            if (n >= 0) {
                Object[] objectArray = logRecord.getParameters();
                return ((IndexedResourceBundle)resourceBundle).getString(n, objectArray);
            }
        }
        if (resourceBundle != null) {
            char c;
            int n;
            try {
                string = resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                IndexedResourceBundle.unexpectedException(missingResourceException);
            }
            Object[] objectArray = logRecord.getParameters();
            if (objectArray != null && objectArray.length != 0 && (n = string.indexOf(123)) >= 0 && n < string.length() - 1 && (c = string.charAt(n)) >= '0' && c <= '9') {
                try {
                    return MessageFormat.format(string, objectArray);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    IndexedResourceBundle.unexpectedException(illegalArgumentException);
                }
            }
        }
        return string;
    }

    private static void unexpectedException(RuntimeException runtimeException) {
        Logging.unexpectedException(IndexedResourceBundle.class, "format", runtimeException);
    }

    public synchronized String toString() {
        return Classes.getShortClassName(this) + '[' + this.getLocale() + ']';
    }

    private static final class KeyEnum
    implements Enumeration<String> {
        private final String[] values;
        private int next = 0;

        KeyEnum(String[] stringArray) {
            this.values = stringArray;
            while (this.next < stringArray.length && stringArray[this.next] == null) {
                ++this.next;
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.next < this.values.length;
        }

        @Override
        public String nextElement() {
            while (this.next < this.values.length) {
                if (this.values[this.next] != null) {
                    return String.valueOf(this.next++);
                }
                ++this.next;
            }
            throw new NoSuchElementException();
        }
    }
}

