/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry;

import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.geotoolkit.display.shape.ShapeUtilities;
import org.geotoolkit.display.shape.XRectangle2D;
import org.geotoolkit.geometry.AbstractEnvelope;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.geometry.GeneralEnvelope;
import org.geotoolkit.internal.referencing.DirectPositionView;
import org.geotoolkit.lang.Static;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.operation.matrix.XAffineTransform;
import org.geotoolkit.referencing.operation.transform.AbstractMathTransform;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.Strings;
import org.geotoolkit.util.logging.Logging;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.RangeMeaning;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class Envelopes
extends Static {
    private static final boolean[] CORNERS = new boolean[]{false, false, false, true, true, true, true, false, false, false};

    private Envelopes() {
    }

    public static Envelope getDomainOfValidity(CoordinateReferenceSystem coordinateReferenceSystem) {
        return CRS.getEnvelope(coordinateReferenceSystem);
    }

    private static Matrix derivativeAndTransform(MathTransform mathTransform, double[] dArray, double[] dArray2, int n, boolean bl) throws TransformException {
        if (mathTransform instanceof AbstractMathTransform) {
            return ((AbstractMathTransform)mathTransform).transform(dArray, 0, dArray2, n, bl);
        }
        Matrix matrix = bl ? mathTransform.derivative(new DirectPositionView(dArray, 0, mathTransform.getSourceDimensions())) : null;
        mathTransform.transform(dArray, 0, dArray2, n, 1);
        return matrix;
    }

    public static Envelope transform(Envelope envelope, CoordinateReferenceSystem coordinateReferenceSystem) throws TransformException {
        CoordinateReferenceSystem coordinateReferenceSystem2;
        if (envelope != null && coordinateReferenceSystem != null && (coordinateReferenceSystem2 = envelope.getCoordinateReferenceSystem()) != coordinateReferenceSystem) {
            if (coordinateReferenceSystem2 == null) {
                envelope = new GeneralEnvelope(envelope);
                ((GeneralEnvelope)envelope).setCoordinateReferenceSystem(coordinateReferenceSystem);
            } else {
                CoordinateOperation coordinateOperation;
                CoordinateOperationFactory coordinateOperationFactory = CRS.getCoordinateOperationFactory(true);
                try {
                    coordinateOperation = coordinateOperationFactory.createOperation(coordinateReferenceSystem2, coordinateReferenceSystem);
                }
                catch (FactoryException factoryException) {
                    throw new TransformException(Errors.format(40), factoryException);
                }
                envelope = Envelopes.transform(coordinateOperation, envelope);
            }
            assert (AbstractEnvelope.equalsIgnoreMetadata(coordinateReferenceSystem, envelope.getCoordinateReferenceSystem(), true));
        }
        return envelope;
    }

    public static GeneralEnvelope transform(MathTransform mathTransform, Envelope envelope) throws TransformException {
        ArgumentChecks.ensureNonNull("transform", mathTransform);
        if (envelope == null) {
            return null;
        }
        if (mathTransform instanceof MathTransform2D && envelope.getDimension() == 2) {
            XRectangle2D xRectangle2D = XRectangle2D.createFromExtremums(envelope.getMinimum(0), envelope.getMinimum(1), envelope.getMaximum(0), envelope.getMaximum(1));
            Envelopes.transform((MathTransform2D)mathTransform, (Rectangle2D)xRectangle2D, (Rectangle2D)xRectangle2D);
            return new GeneralEnvelope(xRectangle2D);
        }
        return Envelopes.transform(mathTransform, envelope, null);
    }

    private static GeneralEnvelope transform(MathTransform mathTransform, Envelope envelope, double[] dArray) throws TransformException {
        int n;
        if (mathTransform.isIdentity()) {
            GeneralEnvelope generalEnvelope = new GeneralEnvelope(envelope);
            generalEnvelope.setCoordinateReferenceSystem(null);
            if (dArray != null) {
                int n2 = envelope.getDimension();
                while (--n2 >= 0) {
                    dArray[n2] = generalEnvelope.getMedian(n2);
                }
            }
            return generalEnvelope;
        }
        int n3 = mathTransform.getSourceDimensions();
        int n4 = mathTransform.getTargetDimensions();
        if (envelope.getDimension() != n3) {
            throw new MismatchedDimensionException(Errors.format(112, n3, envelope.getDimension()));
        }
        int n5 = 0;
        boolean bl = true;
        GeneralEnvelope generalEnvelope = null;
        Matrix[] matrixArray = new Matrix[(int)Math.round(Math.pow(3.0, n3))];
        double[] dArray2 = new double[matrixArray.length * n4];
        double[] dArray3 = new double[n3];
        int n6 = n3;
        while (--n6 >= 0) {
            dArray3[n6] = envelope.getMinimum(n6);
        }
        block14: while (true) {
            n6 = n5 * n4;
            try {
                matrixArray[n5] = Envelopes.derivativeAndTransform(mathTransform, dArray3, dArray2, n6, bl);
            }
            catch (TransformException transformException) {
                if (!bl) {
                    throw transformException;
                }
                bl = false;
                mathTransform.transform(dArray3, 0, dArray2, n6, 1);
                Envelopes.recoverableException(transformException);
            }
            if (generalEnvelope == null) {
                generalEnvelope = new GeneralEnvelope(n4);
                for (int i = 0; i < n4; ++i) {
                    double d = dArray2[n6 + i];
                    generalEnvelope.setRange(i, d, d);
                }
            } else {
                generalEnvelope.add(dArray2, n6);
            }
            int n7 = ++n5;
            n = n3;
            while (--n >= 0) {
                switch (n7 % 3) {
                    case 0: {
                        dArray3[n] = envelope.getMinimum(n);
                        break;
                    }
                    case 1: {
                        dArray3[n] = envelope.getMaximum(n);
                        continue block14;
                    }
                    case 2: {
                        dArray3[n] = envelope.getMedian(n);
                        continue block14;
                    }
                    default: {
                        throw new AssertionError(n7);
                    }
                }
                n7 /= 3;
            }
            break;
        }
        assert (n5 == matrixArray.length) : n5;
        double[] dArray4 = dArray;
        for (n5 = 0; n5 < matrixArray.length; ++n5) {
            Matrix matrix = matrixArray[n5];
            if (matrix == null) continue;
            n = n5;
            int n8 = 1;
            int n9 = n3;
            while (--n9 >= 0) {
                int n10;
                Matrix matrix2;
                int n11 = n % 3;
                if (n11 != 2 && (matrix2 = matrixArray[n10 = n5 + n8 * (2 - n11)]) != null) {
                    double d = envelope.getMinimum(n9);
                    double d2 = envelope.getMaximum(n9);
                    double d3 = envelope.getMedian(n9);
                    double d4 = n11 == 0 ? d : d2;
                    int n12 = n4 * n5;
                    int n13 = n4 * n10;
                    for (int i = 0; i < n4; ++i) {
                        Line2D.Double double_ = ShapeUtilities.cubicCurveExtremum(d4, dArray2[n12 + i], matrix.getElement(i, n9), d3, dArray2[n13 + i], matrix2.getElement(i, n9));
                        boolean bl2 = false;
                        do {
                            double d5;
                            double d6;
                            double d7 = d6 = bl2 ? double_.x2 : double_.x1;
                            if (!(d6 > d) || !(d6 < d2)) continue;
                            double d8 = d5 = bl2 ? double_.y2 : double_.y1;
                            if (!(d5 < generalEnvelope.getMinimum(i)) && !(d5 > generalEnvelope.getMaximum(i))) continue;
                            int n14 = n5;
                            int n15 = n3;
                            while (--n15 >= 0) {
                                double d9;
                                if (n15 == n9) {
                                    d9 = d6;
                                } else {
                                    switch (n14 % 3) {
                                        case 0: {
                                            d9 = envelope.getMinimum(n15);
                                            break;
                                        }
                                        case 1: {
                                            d9 = envelope.getMaximum(n15);
                                            break;
                                        }
                                        case 2: {
                                            d9 = envelope.getMedian(n15);
                                            break;
                                        }
                                        default: {
                                            throw new AssertionError(n14);
                                        }
                                    }
                                }
                                dArray3[n15] = d9;
                                n14 /= 3;
                            }
                            if (dArray4 == null) {
                                dArray4 = new double[n4];
                            }
                            mathTransform.transform(dArray3, 0, dArray4, 0, 1);
                            generalEnvelope.add(dArray4, 0);
                        } while (bl2 = !bl2);
                    }
                }
                n /= 3;
                n8 *= 3;
            }
            matrixArray[n5] = null;
        }
        if (dArray != null) {
            System.arraycopy(dArray2, dArray2.length - n4, dArray, 0, n4);
        }
        return generalEnvelope;
    }

    public static GeneralEnvelope transform(CoordinateOperation coordinateOperation, Envelope envelope) throws TransformException {
        int n;
        int n2;
        int n3;
        Object object;
        Object object2;
        Object object3;
        IdentifiedObject identifiedObject;
        Object object4;
        Object object5;
        ArgumentChecks.ensureNonNull("operation", coordinateOperation);
        if (envelope == null) {
            return null;
        }
        CoordinateReferenceSystem coordinateReferenceSystem = coordinateOperation.getSourceCRS();
        if (coordinateReferenceSystem != null && (object5 = envelope.getCoordinateReferenceSystem()) != null && !CRS.equalsIgnoreMetadata(object5, coordinateReferenceSystem)) {
            try {
                object4 = CRS.findMathTransform((CoordinateReferenceSystem)object5, coordinateReferenceSystem, false);
            }
            catch (FactoryException factoryException) {
                throw new TransformException(Errors.format(40), factoryException);
            }
            if (!object4.isIdentity()) {
                envelope = Envelopes.transform((MathTransform)object4, envelope);
            }
        }
        object5 = coordinateOperation.getMathTransform();
        object4 = new double[object5.getTargetDimensions()];
        GeneralEnvelope generalEnvelope = Envelopes.transform((MathTransform)object5, envelope, (double[])object4);
        if (coordinateReferenceSystem != null && (identifiedObject = coordinateReferenceSystem.getCoordinateSystem()) != null) {
            object3 = null;
            object2 = null;
            int n4 = identifiedObject.getDimension();
            for (int i = 0; i < n4; ++i) {
                object = identifiedObject.getAxis(i);
                if (object == null) continue;
                double d = envelope.getMinimum(i);
                double d2 = envelope.getMaximum(i);
                double d3 = object.getMinimumValue();
                double d4 = object.getMaximumValue();
                n3 = d3 > d && d3 < d2 ? 1 : 0;
                int n5 = n2 = d4 > d && d4 < d2 ? 1 : 0;
                if (n3 == 0 && n2 == 0) continue;
                if (object3 == null) {
                    object3 = new GeneralDirectPosition(n4);
                    for (int j = 0; j < n4; ++j) {
                        object3.setOrdinate(j, envelope.getMedian(j));
                    }
                }
                if (n3 != 0) {
                    object3.setOrdinate(i, d3);
                    object2 = object5.transform((DirectPosition)object3, (DirectPosition)object2);
                    generalEnvelope.add((DirectPosition)object2);
                }
                if (n2 != 0) {
                    object3.setOrdinate(i, d4);
                    object2 = object5.transform((DirectPosition)object3, (DirectPosition)object2);
                    generalEnvelope.add((DirectPosition)object2);
                }
                object3.setOrdinate(i, envelope.getMedian(i));
            }
        }
        if ((identifiedObject = coordinateOperation.getTargetCRS()) == null) {
            return generalEnvelope;
        }
        generalEnvelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)identifiedObject);
        object3 = identifiedObject.getCoordinateSystem();
        if (object3 == null) {
            return generalEnvelope;
        }
        object2 = null;
        AbstractEnvelope abstractEnvelope = null;
        DirectPosition directPosition = null;
        object = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 1L;
        n3 = object3.getDimension();
        n2 = 0;
        while (n2 < n3) {
            CoordinateSystemAxis coordinateSystemAxis = object3.getAxis(n2);
            if (coordinateSystemAxis != null) {
                n = 0;
                do {
                    double d;
                    double d5 = d = n != 0 ? coordinateSystemAxis.getMaximumValue() : coordinateSystemAxis.getMinimumValue();
                    if (Double.isInfinite(d) || Double.isNaN(d)) continue;
                    if (object == null) {
                        try {
                            object5 = object5.inverse();
                        }
                        catch (NoninvertibleTransformException noninvertibleTransformException) {
                            if (n3 >= object5.getSourceDimensions()) {
                                Envelopes.recoverableException(noninvertibleTransformException);
                            }
                            return generalEnvelope;
                        }
                        object = new GeneralDirectPosition(object5.getSourceDimensions());
                        for (int i = 0; i < n3; ++i) {
                            object.setOrdinate(i, (double)object4[i]);
                        }
                        abstractEnvelope = AbstractEnvelope.castOrCopy(envelope);
                    }
                    object.setOrdinate(n2, d);
                    try {
                        directPosition = object5.transform((DirectPosition)object, directPosition);
                    }
                    catch (TransformException transformException) {
                        if (object2 != null) continue;
                        object2 = transformException;
                        continue;
                    }
                    if (!abstractEnvelope.contains(directPosition)) continue;
                    generalEnvelope.add((DirectPosition)object);
                    if (n != 0) {
                        l2 |= l4;
                        continue;
                    }
                    l |= l4;
                } while ((n = n == 0 ? 1 : 0) == 1);
                if ((l & l2 & l4) == 0L && Envelopes.isWrapAround(coordinateSystemAxis)) {
                    l3 |= l4;
                }
                if (object != null) {
                    object.setOrdinate(n2, (double)object4[n2]);
                }
            }
            ++n2;
            l4 <<= 1;
        }
        long l5 = l | l2;
        if (l5 != 0L) {
            while (l3 != 0L) {
                long l6;
                n = Long.numberOfTrailingZeros(l3);
                l4 = 1 << n;
                l3 &= l4 ^ 0xFFFFFFFFFFFFFFFFL;
                CoordinateSystemAxis coordinateSystemAxis = object3.getAxis(n);
                double d = coordinateSystemAxis.getMinimumValue();
                double d6 = coordinateSystemAxis.getMaximumValue();
                for (long i = l5 & (l4 ^ 0xFFFFFFFFFFFFFFFFL); i != 0L; i &= l6 ^ 0xFFFFFFFFFFFFFFFFL) {
                    l6 = Long.lowestOneBit(i);
                    int n6 = Long.numberOfTrailingZeros(l6);
                    CoordinateSystemAxis coordinateSystemAxis2 = object3.getAxis(n6);
                    for (int j = 0; j < 4; ++j) {
                        double d7 = d6;
                        if ((j & 1) == 0) {
                            if (((j == 0 ? l : l2) & l6) == 0L) {
                                ++j;
                                continue;
                            }
                            object.setOrdinate(n6, j == 0 ? coordinateSystemAxis2.getMinimumValue() : coordinateSystemAxis2.getMaximumValue());
                            d7 = d;
                        }
                        object.setOrdinate(n, d7);
                        try {
                            directPosition = object5.transform((DirectPosition)object, directPosition);
                        }
                        catch (TransformException transformException) {
                            if (object2 != null) continue;
                            object2 = transformException;
                            continue;
                        }
                        if (!abstractEnvelope.contains(directPosition)) continue;
                        generalEnvelope.add((DirectPosition)object);
                    }
                    object.setOrdinate(n6, (double)object4[n6]);
                }
                object.setOrdinate(n, (double)object4[n]);
            }
        }
        if (object2 != null) {
            Envelopes.recoverableException(object2);
        }
        return generalEnvelope;
    }

    public static Rectangle2D transform(MathTransform2D mathTransform2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) throws TransformException {
        ArgumentChecks.ensureNonNull("transform", mathTransform2D);
        if (mathTransform2D instanceof AffineTransform) {
            return XAffineTransform.transform((AffineTransform)((Object)mathTransform2D), rectangle2D, rectangle2D2);
        }
        return Envelopes.transform(mathTransform2D, rectangle2D, rectangle2D2, new double[2]);
    }

    private static Rectangle2D transform(MathTransform2D mathTransform2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, double[] dArray) throws TransformException {
        if (rectangle2D == null) {
            return null;
        }
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        Matrix matrix = null;
        Matrix matrix2 = null;
        Matrix matrix3 = null;
        boolean bl = true;
        for (int i = 0; i <= 8; ++i) {
            double d13;
            double d14;
            switch (i) {
                case 0: 
                case 6: 
                case 7: {
                    d14 = rectangle2D.getMinX();
                    break;
                }
                case 1: 
                case 5: 
                case 8: {
                    d14 = rectangle2D.getCenterX();
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    d14 = rectangle2D.getMaxX();
                    break;
                }
                default: {
                    throw new AssertionError(i);
                }
            }
            switch (i) {
                case 0: 
                case 1: 
                case 2: {
                    d13 = rectangle2D.getMinY();
                    break;
                }
                case 3: 
                case 7: 
                case 8: {
                    d13 = rectangle2D.getCenterY();
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    d13 = rectangle2D.getMaxY();
                    break;
                }
                default: {
                    throw new AssertionError(i);
                }
            }
            dArray[0] = d14;
            dArray[1] = d13;
            try {
                matrix2 = matrix3;
                matrix3 = Envelopes.derivativeAndTransform(mathTransform2D, dArray, dArray, 0, bl && i != 8);
            }
            catch (TransformException transformException) {
                if (!bl) {
                    throw transformException;
                }
                bl = false;
                matrix3 = null;
                dArray[0] = d14;
                dArray[1] = d13;
                mathTransform2D.transform(dArray, 0, dArray, 0, 1);
                Envelopes.recoverableException(transformException);
            }
            double d15 = dArray[0];
            double d16 = dArray[1];
            if (d15 < d) {
                d = d15;
            }
            if (d15 > d3) {
                d3 = d15;
            }
            if (d16 < d2) {
                d2 = d16;
            }
            if (d16 > d4) {
                d4 = d16;
            }
            switch (i) {
                case 0: {
                    d7 = d14;
                    d5 = d15;
                    d8 = d13;
                    d6 = d16;
                    matrix = matrix3;
                    break;
                }
                case 8: {
                    d14 = d7;
                    d15 = d5;
                    d13 = d8;
                    d16 = d6;
                    matrix3 = matrix;
                }
            }
            if (matrix2 != null && matrix3 != null) {
                double d17;
                double d18;
                double d19;
                double d20;
                int n;
                switch (i) {
                    case 1: 
                    case 2: 
                    case 5: 
                    case 6: {
                        assert (d13 == d12);
                        n = 0;
                        d20 = d11;
                        d19 = d14;
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 7: 
                    case 8: {
                        assert (d14 == d11);
                        n = 1;
                        d20 = d12;
                        d19 = d13;
                        break;
                    }
                    default: {
                        throw new AssertionError(i);
                    }
                }
                if (d20 < d19) {
                    d18 = d20;
                    d17 = d19;
                } else {
                    d18 = d19;
                    d17 = d20;
                }
                int n2 = 0;
                do {
                    Line2D.Double double_ = ShapeUtilities.cubicCurveExtremum(d20, n2 == 0 ? d9 : d10, matrix2.getElement(n2, n), d19, n2 == 0 ? d15 : d16, matrix3.getElement(n2, n));
                    boolean bl2 = false;
                    do {
                        double d21;
                        double d22;
                        double d23 = d22 = bl2 ? double_.x2 : double_.x1;
                        if (!(d22 > d18) || !(d22 < d17)) continue;
                        double d24 = d21 = bl2 ? double_.y2 : double_.y1;
                        if (!(n2 == 0 ? d21 < d || d21 > d3 : d21 < d2 || d21 > d4)) continue;
                        double d25 = dArray[0];
                        double d26 = dArray[1];
                        if (n == 0) {
                            dArray[0] = d22;
                            dArray[1] = d12;
                        } else {
                            dArray[0] = d11;
                            dArray[1] = d22;
                        }
                        mathTransform2D.transform(dArray, 0, dArray, 0, 1);
                        double d27 = dArray[0];
                        double d28 = dArray[1];
                        if (d27 < d) {
                            d = d27;
                        }
                        if (d27 > d3) {
                            d3 = d27;
                        }
                        if (d28 < d2) {
                            d2 = d28;
                        }
                        if (d28 > d4) {
                            d4 = d28;
                        }
                        dArray[0] = d25;
                        dArray[1] = d26;
                    } while (bl2 = !bl2);
                } while (++n2 == 1);
            }
            d11 = d14;
            d9 = d15;
            d12 = d13;
            d10 = d16;
            matrix2 = matrix3;
        }
        if (rectangle2D2 != null) {
            rectangle2D2.setRect(d, d2, d3 - d, d4 - d2);
        } else {
            rectangle2D2 = XRectangle2D.createFromExtremums(d, d2, d3, d4);
        }
        return rectangle2D2;
    }

    public static Rectangle2D transform(CoordinateOperation coordinateOperation, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) throws TransformException {
        int n;
        int n2;
        IdentifiedObject identifiedObject;
        IdentifiedObject identifiedObject2;
        ArgumentChecks.ensureNonNull("operation", coordinateOperation);
        if (rectangle2D == null) {
            return null;
        }
        MathTransform mathTransform = coordinateOperation.getMathTransform();
        if (!(mathTransform instanceof MathTransform2D)) {
            throw new MismatchedDimensionException(Errors.format(168));
        }
        MathTransform2D mathTransform2D = (MathTransform2D)mathTransform;
        double[] dArray = new double[2];
        rectangle2D2 = Envelopes.transform(mathTransform2D, rectangle2D, rectangle2D2, dArray);
        CoordinateReferenceSystem coordinateReferenceSystem = coordinateOperation.getSourceCRS();
        if (coordinateReferenceSystem != null && (identifiedObject2 = coordinateReferenceSystem.getCoordinateSystem()) != null && identifiedObject2.getDimension() == 2) {
            identifiedObject = identifiedObject2.getAxis(0);
            double d = rectangle2D.getMinX();
            double d2 = rectangle2D.getMaxX();
            Point2D.Double double_ = null;
            for (n2 = 0; n2 < 4; ++n2) {
                double d3;
                if (n2 == 2) {
                    identifiedObject = identifiedObject2.getAxis(1);
                    d = rectangle2D.getMinY();
                    d2 = rectangle2D.getMaxY();
                }
                double d4 = d3 = (n2 & 1) == 0 ? identifiedObject.getMinimumValue() : identifiedObject.getMaximumValue();
                if (!(d3 > d) || !(d3 < d2)) continue;
                if (double_ == null) {
                    double_ = new Point2D.Double();
                }
                if ((n2 & 2) == 0) {
                    double_.x = d3;
                    double_.y = rectangle2D.getCenterY();
                } else {
                    double_.x = rectangle2D.getCenterX();
                    double_.y = d3;
                }
                rectangle2D2.add(mathTransform2D.transform(double_, double_));
            }
        }
        if ((identifiedObject2 = coordinateOperation.getTargetCRS()) == null) {
            return rectangle2D2;
        }
        identifiedObject = identifiedObject2.getCoordinateSystem();
        if (identifiedObject == null || identifiedObject.getDimension() != 2) {
            return rectangle2D2;
        }
        TransformException transformException = null;
        Point2D point2D = null;
        Point2D point2D2 = null;
        int n3 = 0;
        for (n = 0; n < 4; ++n) {
            double d;
            n2 = n >>> 1;
            CoordinateSystemAxis coordinateSystemAxis = identifiedObject.getAxis(n2);
            if (coordinateSystemAxis == null) continue;
            double d5 = d = (n & 1) == 0 ? coordinateSystemAxis.getMinimumValue() : coordinateSystemAxis.getMaximumValue();
            if (Double.isInfinite(d) || Double.isNaN(d)) continue;
            if (point2D2 == null) {
                try {
                    mathTransform2D = mathTransform2D.inverse();
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    Envelopes.recoverableException(noninvertibleTransformException);
                    return rectangle2D2;
                }
                point2D2 = new Point2D.Double();
            }
            switch (n2) {
                case 0: {
                    point2D2.setLocation(d, dArray[1]);
                    break;
                }
                case 1: {
                    point2D2.setLocation(dArray[0], d);
                    break;
                }
                default: {
                    throw new AssertionError(n);
                }
            }
            try {
                point2D = mathTransform2D.transform(point2D2, point2D);
            }
            catch (TransformException transformException2) {
                if (transformException != null) continue;
                transformException = transformException2;
                continue;
            }
            if (!rectangle2D.contains(point2D)) continue;
            rectangle2D2.add(point2D2);
            n3 |= 1 << n;
        }
        if (n3 != 0) {
            n = (n3 & 1) << 3 | (n3 & 4) >>> 1 | (n3 & 2) << 6 | (n3 & 8) << 2;
            n |= n >>> 1;
            if (((n &= ~(n3 | n3 << 4)) & 0x33333333) != 0 && !Envelopes.isWrapAround(identifiedObject.getAxis(0))) {
                n &= 0xCCCCCCCC;
            }
            if ((n & 0xCCCCCCCC) != 0 && !Envelopes.isWrapAround(identifiedObject.getAxis(1))) {
                n &= 0x33333333;
            }
            while (n != 0) {
                double d;
                n2 = Integer.numberOfTrailingZeros(n);
                int n4 = 1 << n2;
                n &= ~n4;
                int n5 = n2 >>> 1 & 1;
                CoordinateSystemAxis coordinateSystemAxis = identifiedObject.getAxis(n5);
                CoordinateSystemAxis coordinateSystemAxis2 = identifiedObject.getAxis(n5 ^ 1);
                double d6 = (n2 & 1) == 0 ? coordinateSystemAxis.getMinimumValue() : coordinateSystemAxis.getMaximumValue();
                double d7 = d = (n2 & 4) == 0 ? coordinateSystemAxis2.getMinimumValue() : coordinateSystemAxis2.getMaximumValue();
                if (n5 != 0) {
                    double d8 = d6;
                    d6 = d;
                    d = d8;
                }
                point2D2.setLocation(d6, d);
                try {
                    point2D = mathTransform2D.transform(point2D2, point2D);
                }
                catch (TransformException transformException3) {
                    if (transformException != null) continue;
                    transformException = transformException3;
                    continue;
                }
                if (!rectangle2D.contains(point2D)) continue;
                rectangle2D2.add(point2D2);
            }
        }
        if (transformException != null) {
            Envelopes.recoverableException(transformException);
        }
        return rectangle2D2;
    }

    private static boolean isWrapAround(CoordinateSystemAxis coordinateSystemAxis) {
        return RangeMeaning.WRAPAROUND.equals(coordinateSystemAxis.getRangeMeaning());
    }

    private static void recoverableException(TransformException transformException) {
        Logging.recoverableException(Envelopes.class, "transform", transformException);
    }

    public static Envelope parseWKT(String string) throws FactoryException {
        ArgumentChecks.ensureNonNull("wkt", string);
        try {
            return new GeneralEnvelope(string);
        }
        catch (RuntimeException runtimeException) {
            throw new FactoryException(Errors.format(27, Envelope.class), runtimeException);
        }
    }

    public static String toWKT(Envelope envelope) {
        return AbstractEnvelope.toString(envelope);
    }

    public static String toPolygonWKT(Envelope envelope) throws IllegalArgumentException {
        double d;
        int n;
        for (n = envelope.getDimension(); n != 0 && (Double.isNaN(d = envelope.getSpan(n - 1)) || Double.isInfinite(d)); --n) {
        }
        if (n < 2) {
            throw new IllegalArgumentException(Errors.format(60));
        }
        StringBuilder stringBuilder = new StringBuilder("POLYGON(");
        String string = "(";
        for (int i = 0; i < CORNERS.length; i += 2) {
            for (int j = 0; j < n; ++j) {
                double d2;
                switch (j) {
                    case 0: 
                    case 1: {
                        d2 = CORNERS[i + j] ? envelope.getMaximum(j) : envelope.getMinimum(j);
                        break;
                    }
                    default: {
                        d2 = envelope.getMedian(j);
                    }
                }
                Strings.trimFractionalPart(stringBuilder.append(string).append(d2));
                string = " ";
            }
            string = ", ";
        }
        return stringBuilder.append("))").toString();
    }
}

