/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.isoonjts.spatialschema.geometry.primitive;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineString;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.geotoolkit.geometry.isoonjts.JTSUtils;
import org.geotoolkit.geometry.isoonjts.spatialschema.geometry.complex.JTSCompositeCurve;
import org.opengis.geometry.complex.CompositeCurve;
import org.opengis.geometry.primitive.Ring;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@XmlRootElement(name="Ring", namespace="http://www.opengis.net/gml")
@XmlType(name="RingType", namespace="http://www.opengis.net/gml")
public class JTSRing
extends JTSCompositeCurve
implements Ring {
    public JTSRing() {
        this(null, null);
    }

    public JTSRing(CoordinateReferenceSystem crs) {
        this(null, crs);
    }

    public JTSRing(CompositeCurve parentCurve) {
        this(parentCurve, parentCurve.getCoordinateReferenceSystem());
    }

    public JTSRing(CompositeCurve parentCurve, CoordinateReferenceSystem crs) {
        super(parentCurve, crs);
    }

    public boolean isValid() {
        Coordinate[] coords = this.computeJTSPeer().getCoordinates();
        int count = coords.length;
        if (count > 2) {
            if (!coords[0].equals(coords)) {
                Coordinate[] tmp = new Coordinate[count + 1];
                System.arraycopy(coords, 0, tmp, 0, count);
                tmp[count] = coords[0];
                coords = tmp;
            }
            LineString jtsLineString = JTSUtils.GEOMETRY_FACTORY.createLineString(coords);
            return jtsLineString.isRing();
        }
        return false;
    }
}

