/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml.v311;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlType;
import org.geotoolkit.gml.xml.Envelope;
import org.geotoolkit.gml.xml.LineString;
import org.geotoolkit.gml.xml.v311.AbstractCurveType;
import org.geotoolkit.gml.xml.v311.CoordinatesType;
import org.geotoolkit.gml.xml.v311.DirectPositionListType;
import org.geotoolkit.gml.xml.v311.DirectPositionType;
import org.geotoolkit.gml.xml.v311.EnvelopeType;
import org.geotoolkit.util.ComparisonMode;
import org.geotoolkit.util.Utilities;
import org.opengis.geometry.DirectPosition;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="LineStringType", propOrder={"pointPropertyOrPointRep", "pos", "posList", "coordinates"})
public class LineStringType
extends AbstractCurveType
implements LineString {
    @XmlElementRefs(value={@XmlElementRef(name="pointProperty", namespace="http://www.opengis.net/gml", type=JAXBElement.class), @XmlElementRef(name="coord", namespace="http://www.opengis.net/gml", type=JAXBElement.class), @XmlElementRef(name="pointRep", namespace="http://www.opengis.net/gml", type=JAXBElement.class)})
    private List<JAXBElement<?>> pointPropertyOrPointRep;
    @XmlElement(name="pos", namespace="http://www.opengis.net/gml")
    private List<DirectPositionType> pos;
    private DirectPositionListType posList;
    private CoordinatesType coordinates;

    LineStringType() {
    }

    public LineStringType(CoordinatesType coordinates) {
        this.coordinates = coordinates;
    }

    public LineStringType(List<DirectPosition> positions) {
        this.pos = new ArrayList<DirectPositionType>();
        for (DirectPosition currentPos : positions) {
            DirectPositionType position = currentPos instanceof DirectPositionType ? (DirectPositionType)currentPos : new DirectPositionType(currentPos);
            this.pos.add(position);
        }
    }

    public LineStringType(String id, String srsname, Collection<DirectPositionType> positions) {
        super(id, srsname);
        this.pos = new ArrayList<DirectPositionType>();
        for (DirectPositionType currentPos : positions) {
            this.pos.add(currentPos);
        }
    }

    public List<DirectPositionType> getPos() {
        if (this.pos == null) {
            this.pos = new ArrayList<DirectPositionType>();
        }
        return this.pos;
    }

    public List<JAXBElement<?>> getPointPropertyOrPointRep() {
        if (this.pointPropertyOrPointRep == null) {
            this.pointPropertyOrPointRep = new ArrayList();
        }
        return this.pointPropertyOrPointRep;
    }

    @Override
    public DirectPositionListType getPosList() {
        return this.posList;
    }

    public void setPosList(DirectPositionListType value) {
        this.posList = value;
    }

    @Override
    public CoordinatesType getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(CoordinatesType value) {
        this.coordinates = value;
    }

    @Override
    public Envelope getBounds() {
        double minx = Double.MAX_VALUE;
        double miny = Double.MAX_VALUE;
        double maxx = -1.7976931348623157E308;
        double maxy = -1.7976931348623157E308;
        if (this.pos != null && !this.pos.isEmpty()) {
            for (DirectPositionType p : this.pos) {
                double x = p.getOrdinate(0);
                double y = p.getOrdinate(1);
                if (x < minx) {
                    minx = x;
                }
                if (x > maxx) {
                    maxx = x;
                }
                if (y < miny) {
                    miny = y;
                }
                if (!(y > maxy)) continue;
                maxy = y;
            }
            DirectPositionType lowerCorner = new DirectPositionType(minx, miny);
            DirectPositionType upperCorner = new DirectPositionType(maxx, maxy);
            return new EnvelopeType("bound-1", lowerCorner, upperCorner, this.getSrsName());
        }
        return null;
    }

    @Override
    public void emptySrsNameOnChild() {
        if (this.pos != null && !this.pos.isEmpty()) {
            for (DirectPositionType p : this.pos) {
                p.srsName = null;
                p.srsDimension = null;
            }
        } else if (this.posList != null) {
            this.posList.setSrsName(null);
            this.posList.setSrsDimension(null);
        }
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (object instanceof LineStringType) {
            LineStringType that = (LineStringType)object;
            boolean jb = false;
            if (this.getPointPropertyOrPointRep().size() == that.getPointPropertyOrPointRep().size()) {
                jb = true;
                for (int i = 0; i < this.getPointPropertyOrPointRep().size(); ++i) {
                    if (this.JAXBElementEquals(this.getPointPropertyOrPointRep().get(i), that.getPointPropertyOrPointRep().get(i))) continue;
                    jb = false;
                }
            }
            return Utilities.equals(this.coordinates, that.coordinates) && Utilities.equals(this.posList, that.posList) && Utilities.equals(this.pos, that.pos) && jb;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (this.pointPropertyOrPointRep != null ? ((Object)this.pointPropertyOrPointRep).hashCode() : 0);
        hash = 79 * hash + (this.posList != null ? this.posList.hashCode() : 0);
        hash = 79 * hash + (this.coordinates != null ? this.coordinates.hashCode() : 0);
        hash = 79 * hash + (this.pos != null ? ((Object)this.pos).hashCode() : 0);
        return hash;
    }

    private boolean JAXBElementEquals(JAXBElement a, JAXBElement b) {
        if (a != null && b != null) {
            return Utilities.equals(a.getValue(), b.getValue());
        }
        return a == null && b == null;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder(super.toString());
        if (this.posList != null) {
            s.append("posList").append(this.posList).append('\n');
        }
        if (this.coordinates != null) {
            s.append("coordinates=").append(this.coordinates).append('\n');
        }
        if (this.pointPropertyOrPointRep != null) {
            s.append("point :").append('\n');
            for (JAXBElement jAXBElement : this.pointPropertyOrPointRep) {
                s.append(jAXBElement.getValue()).append('\n');
            }
        }
        if (this.pos != null) {
            s.append("pos :").append('\n');
            for (DirectPositionType directPositionType : this.pos) {
                s.append(directPositionType).append('\n');
            }
        }
        return s.toString();
    }
}

