/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml.v321;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.geotoolkit.gml.xml.DirectPosition;
import org.geotoolkit.gml.xml.Envelope;
import org.geotoolkit.gml.xml.v321.CoordinatesType;
import org.geotoolkit.gml.xml.v321.DirectPositionType;
import org.geotoolkit.gml.xml.v321.EnvelopeWithTimePeriodType;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.logging.Logging;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="EnvelopeType", propOrder={"lowerCorner", "upperCorner", "pos", "coordinates"})
@XmlSeeAlso(value={EnvelopeWithTimePeriodType.class})
public class EnvelopeType
implements org.opengis.geometry.Envelope,
Envelope {
    private static final Logger LOGGER = Logging.getLogger(EnvelopeType.class);
    private DirectPositionType lowerCorner;
    private DirectPositionType upperCorner;
    private List<DirectPositionType> pos;
    private CoordinatesType coordinates;
    @XmlAttribute
    @XmlSchemaType(name="anyURI")
    private String srsName;
    @XmlAttribute
    @XmlSchemaType(name="positiveInteger")
    private Integer srsDimension;
    @XmlAttribute
    private List<String> axisLabels;
    @XmlAttribute
    private List<String> uomLabels;

    protected EnvelopeType() {
    }

    public EnvelopeType(DirectPositionType lowerCorner, DirectPositionType upperCorner, String srsName) {
        this.lowerCorner = lowerCorner;
        this.upperCorner = upperCorner;
        this.srsName = srsName;
    }

    public EnvelopeType(EnvelopeType that) {
        if (that != null) {
            if (that.axisLabels != null) {
                this.axisLabels = new ArrayList<String>(that.axisLabels);
            }
            if (that.uomLabels != null) {
                this.uomLabels = new ArrayList<String>(that.uomLabels);
            }
            if (that.coordinates != null) {
                this.coordinates = new CoordinatesType(that.coordinates);
            }
            if (that.lowerCorner != null) {
                this.lowerCorner = new DirectPositionType(that.lowerCorner);
            }
            if (that.upperCorner != null) {
                this.upperCorner = new DirectPositionType(that.upperCorner);
            }
            if (that.pos != null) {
                this.pos = new ArrayList<DirectPositionType>();
                for (DirectPositionType dp : that.pos) {
                    this.pos.add(new DirectPositionType(dp));
                }
            }
            this.srsDimension = that.srsDimension;
            this.srsName = that.srsName;
        }
    }

    public EnvelopeType(Envelope that) {
        if (that != null) {
            if (that.getLowerCorner() != null) {
                this.lowerCorner = new DirectPositionType(that.getLowerCorner(), false);
            }
            if (that.getUpperCorner() != null) {
                this.upperCorner = new DirectPositionType(that.getUpperCorner(), false);
            }
            this.srsDimension = that.getSrsDimension();
            this.srsName = that.getSrsName();
            this.axisLabels = that.getAxisLabels();
            this.uomLabels = that.getUomLabels();
            if (that.getCoordinates() != null) {
                this.coordinates = new CoordinatesType(that.getCoordinates());
            }
            if (that.getPos() != null) {
                this.pos = new ArrayList<DirectPositionType>();
                for (DirectPosition directPosition : that.getPos()) {
                    this.pos.add(new DirectPositionType(directPosition));
                }
            }
        }
    }

    @Override
    public DirectPositionType getLowerCorner() {
        return this.lowerCorner;
    }

    public void setLowerCorner(DirectPositionType value) {
        this.lowerCorner = value;
    }

    @Override
    public DirectPositionType getUpperCorner() {
        return this.upperCorner;
    }

    public void setUpperCorner(DirectPositionType value) {
        this.upperCorner = value;
    }

    public List<DirectPositionType> getPos() {
        if (this.pos == null) {
            this.pos = new ArrayList<DirectPositionType>();
        }
        return this.pos;
    }

    @Override
    public CoordinatesType getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(CoordinatesType value) {
        this.coordinates = value;
    }

    @Override
    public String getSrsName() {
        return this.srsName;
    }

    public void setSrsName(String value) {
        this.srsName = value;
    }

    @Override
    public Integer getSrsDimension() {
        return this.srsDimension;
    }

    @Override
    public void setSrsDimension(Integer value) {
        this.srsDimension = value;
    }

    @Override
    public List<String> getAxisLabels() {
        if (this.axisLabels == null) {
            this.axisLabels = new ArrayList<String>();
        }
        return this.axisLabels;
    }

    @Override
    public void setAxisLabels(List<String> axisLabels) {
        this.axisLabels = axisLabels;
    }

    public void setAxisLabels(String axisLabel) {
        if (axisLabel != null) {
            if (this.axisLabels == null) {
                this.axisLabels = new ArrayList<String>();
            }
            this.axisLabels.add(axisLabel);
        }
    }

    @Override
    public List<String> getUomLabels() {
        if (this.uomLabels == null) {
            this.uomLabels = new ArrayList<String>();
        }
        return this.uomLabels;
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        if (this.srsName != null) {
            try {
                return CRS.decode(this.srsName);
            }
            catch (NoSuchAuthorityCodeException ex) {
                LOGGER.log(Level.SEVERE, "NoSuchAuthorityCodeException while looking for GML envelope crs:" + this.srsName, ex);
            }
            catch (FactoryException ex) {
                LOGGER.log(Level.SEVERE, "FactoryException while looking for GML envelope crs:" + this.srsName, ex);
            }
        }
        return null;
    }

    @Override
    public int getDimension() {
        return this.srsDimension;
    }

    @Override
    public double getMinimum(int i) throws IndexOutOfBoundsException {
        if (this.lowerCorner != null) {
            return this.lowerCorner.getOrdinate(i);
        }
        return -1.0;
    }

    @Override
    public double getMaximum(int i) throws IndexOutOfBoundsException {
        if (this.upperCorner != null) {
            return this.upperCorner.getOrdinate(i);
        }
        return -1.0;
    }

    @Override
    public double getMedian(int i) throws IndexOutOfBoundsException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public double getSpan(int i) throws IndexOutOfBoundsException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public boolean isCompleteEnvelope2D() {
        return this.getLowerCorner() != null && this.getUpperCorner() != null && this.getLowerCorner().getValue().size() == 2 && this.getUpperCorner().getValue().size() == 2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof EnvelopeType) {
            EnvelopeType that = (EnvelopeType)object;
            return Utilities.equals(this.getAxisLabels(), that.getAxisLabels()) && Utilities.equals(this.coordinates, that.coordinates) && Utilities.equals(this.lowerCorner, that.lowerCorner) && Utilities.equals(this.getPos(), that.getPos()) && Utilities.equals(this.srsDimension, that.srsDimension) && Utilities.equals(this.getUomLabels(), that.getUomLabels()) && Utilities.equals(this.srsName, that.srsName);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (this.lowerCorner != null ? this.lowerCorner.hashCode() : 0);
        hash = 79 * hash + (this.upperCorner != null ? this.upperCorner.hashCode() : 0);
        hash = 79 * hash + (this.pos != null ? ((Object)this.pos).hashCode() : 0);
        hash = 79 * hash + (this.coordinates != null ? this.coordinates.hashCode() : 0);
        hash = 79 * hash + (this.srsName != null ? this.srsName.hashCode() : 0);
        hash = 79 * hash + (this.srsDimension != null ? this.srsDimension.hashCode() : 0);
        hash = 79 * hash + (this.axisLabels != null ? ((Object)this.axisLabels).hashCode() : 0);
        hash = 79 * hash + (this.uomLabels != null ? ((Object)this.uomLabels).hashCode() : 0);
        return hash;
    }

    public String toString() {
        int i;
        StringBuilder s = new StringBuilder();
        if (this.srsDimension != null) {
            s.append("srsDImension:").append(this.srsDimension).append(" ");
        }
        if (this.srsName != null) {
            s.append("srsName:").append(this.srsName).append(" ");
        }
        if (this.lowerCorner != null) {
            s.append('\n').append("lowerCorner:").append(this.lowerCorner.toString());
        }
        if (this.upperCorner != null) {
            s.append('\n').append("upperCorner:").append(this.upperCorner.toString());
        }
        if (this.pos != null) {
            i = 0;
            for (DirectPositionType posi : this.pos) {
                s.append('\n').append("pos").append(i).append(":").append(posi.toString());
                ++i;
            }
            s.append('\n');
        }
        if (this.coordinates != null) {
            s.append("coordinates:").append(this.coordinates.toString());
        }
        if (this.axisLabels != null) {
            i = 0;
            for (String axis : this.axisLabels) {
                s.append('\n').append("axis").append(i).append(":").append(axis);
                ++i;
            }
            s.append('\n');
        }
        if (this.uomLabels != null) {
            i = 0;
            for (String uom : this.uomLabels) {
                s.append('\n').append("uom").append(i).append(":").append(uom);
                ++i;
            }
            s.append('\n');
        }
        return s.toString();
    }
}

