/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.io;

import java.io.IOException;
import java.io.Writer;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.io.FilterWriter;
import org.geotoolkit.io.NumberedLineWriter;

@ThreadSafe
public class EchoWriter
extends FilterWriter {
    private final Writer echo;

    public EchoWriter(Writer writer) {
        super(writer);
        this.echo = NumberedLineWriter.getStandardOutput();
    }

    public EchoWriter(Writer writer, Writer writer2) {
        super(writer);
        this.echo = writer2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.write(n);
            this.echo.write(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.write(cArray);
            this.echo.write(cArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.write(cArray, n, n2);
            this.echo.write(cArray, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String string) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.write(string);
            this.echo.write(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String string, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.write(string, n, n2);
            this.echo.write(string, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.flush();
            this.echo.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.out.close();
            this.echo.close();
        }
    }

    @Override
    final String content() {
        String string = super.content();
        if (string == null) {
            string = EchoWriter.content(this.echo);
        }
        return string;
    }
}

