/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.util.Strings;
import org.opengis.referencing.IdentifiedObject;

final class CacheRecord
implements Comparable<CacheRecord> {
    private final String key;
    private final String value;
    private final String identity;
    private final int code;

    private CacheRecord(Object object, Object object2) {
        int n;
        this.identity = InternalUtilities.identity(object2);
        if (object2 instanceof Collection) {
            Iterator iterator = ((Collection)object2).iterator();
            object2 = iterator.hasNext() ? iterator.next() : null;
        }
        String string = object2 instanceof IdentifiedObject ? String.valueOf(((IdentifiedObject)object2).getName()) : null;
        this.value = string;
        this.key = string = String.valueOf(object);
        int n2 = (string = string.substring(string.indexOf(91) + 1)).indexOf(32);
        if (n2 >= 1) {
            string = string.substring(0, n2);
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = Integer.MAX_VALUE;
        }
        this.code = n;
    }

    @Override
    public int compareTo(CacheRecord cacheRecord) {
        if (this.code < cacheRecord.code) {
            return -1;
        }
        if (this.code > cacheRecord.code) {
            return 1;
        }
        return this.key.compareTo(cacheRecord.key);
    }

    public static void printCacheContent(Map<?, ?> map, PrintWriter printWriter) {
        ArrayList<CacheRecord> arrayList = new ArrayList<CacheRecord>(map.size() + 10);
        int n = 0;
        int n2 = 0;
        for (Map.Entry<?, ?> objectArray : map.entrySet()) {
            CacheRecord cacheRecord = new CacheRecord(objectArray.getKey(), objectArray.getValue());
            int n3 = cacheRecord.key.length();
            if (n3 > n) {
                n = n3;
            }
            if ((n3 = cacheRecord.identity.length()) > n2) {
                n2 = n3;
            }
            arrayList.add(cacheRecord);
        }
        n += 2;
        n2 += 2;
        Object[] objectArray = arrayList.toArray(new CacheRecord[arrayList.size()]);
        Arrays.sort(objectArray);
        if (printWriter == null) {
            printWriter = IOUtilities.standardPrintWriter();
        }
        for (Object object : objectArray) {
            printWriter.print(((CacheRecord)object).key);
            printWriter.print(Strings.spaces(n - ((CacheRecord)object).key.length()));
            printWriter.print(((CacheRecord)object).identity);
            if (((CacheRecord)object).value != null) {
                printWriter.print(Strings.spaces(n2 - ((CacheRecord)object).identity.length()));
                printWriter.println(((CacheRecord)object).value);
                continue;
            }
            printWriter.println();
        }
        printWriter.flush();
    }
}

