/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.referencing.factory.epsg;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.geotoolkit.referencing.factory.epsg.DirectEpsgFactory;
import org.geotoolkit.referencing.factory.epsg.TableInfo;
import org.geotoolkit.util.logging.Logging;
import org.opengis.referencing.operation.Projection;
import org.opengis.util.NoSuchIdentifierException;

final class AuthorityCodes
extends AbstractSet<String>
implements Serializable {
    private static final long serialVersionUID = 7105664579449680562L;
    private final DirectEpsgFactory factory;
    final Class<?> type;
    private final boolean isProjection;
    private transient java.util.Map<String, String> asMap;
    final String sqlAll;
    private final String sqlSingle;
    private transient PreparedStatement querySingle;
    private final Connection connection;
    private int size = -1;

    AuthorityCodes(Connection connection, TableInfo tableInfo, Class<?> clazz, DirectEpsgFactory directEpsgFactory) {
        int n;
        this.factory = directEpsgFactory;
        this.connection = connection;
        StringBuilder stringBuilder = new StringBuilder("SELECT ").append(tableInfo.codeColumn);
        if (tableInfo.nameColumn != null) {
            stringBuilder.append(", ").append(tableInfo.nameColumn);
        }
        stringBuilder.append(" FROM ").append(tableInfo.table);
        boolean bl = false;
        Class<?> clazz2 = tableInfo.type;
        if (tableInfo.typeColumn != null) {
            for (n = 0; n < tableInfo.subTypes.length; ++n) {
                Class<?> clazz3 = tableInfo.subTypes[n];
                if (!clazz3.isAssignableFrom(clazz)) continue;
                stringBuilder.append(" WHERE (").append(tableInfo.typeColumn).append(" LIKE '").append(tableInfo.typeNames[n]).append("%'");
                bl = true;
                clazz2 = clazz3;
                break;
            }
            if (bl) {
                stringBuilder.append(')');
            }
        }
        this.type = clazz2;
        this.isProjection = Projection.class.isAssignableFrom(clazz2);
        n = stringBuilder.length();
        stringBuilder.append(" ORDER BY ").append(tableInfo.codeColumn);
        this.sqlAll = directEpsgFactory.adaptSQL(stringBuilder.toString());
        stringBuilder.setLength(n);
        stringBuilder.append(bl ? " AND " : " WHERE ").append(tableInfo.codeColumn).append(" = ?");
        this.sqlSingle = directEpsgFactory.adaptSQL(stringBuilder.toString());
    }

    private ResultSet getSingle(Object object) throws SQLException {
        assert (Thread.holdsLock(this));
        if (this.querySingle == null) {
            this.querySingle = this.connection.prepareStatement(this.sqlSingle);
        }
        if (object instanceof Number) {
            this.querySingle.setInt(1, ((Number)object).intValue());
            return this.querySingle.executeQuery();
        }
        try {
            return DirectEpsgFactory.executeQuery(this.querySingle, object.toString());
        }
        catch (NoSuchIdentifierException noSuchIdentifierException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAcceptable(ResultSet resultSet) throws SQLException {
        if (!this.isProjection) {
            return true;
        }
        String string = resultSet.getString(1);
        try {
            DirectEpsgFactory directEpsgFactory = this.factory;
            synchronized (directEpsgFactory) {
                return this.factory.isProjection(string);
            }
        }
        catch (NoSuchIdentifierException noSuchIdentifierException) {
            throw new SQLDataException(noSuchIdentifierException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isAcceptable(String string) throws SQLException {
        if (!this.isProjection) {
            return true;
        }
        try {
            DirectEpsgFactory directEpsgFactory = this.factory;
            synchronized (directEpsgFactory) {
                return this.factory.isProjection(string);
            }
        }
        catch (NoSuchIdentifierException noSuchIdentifierException) {
            throw new SQLDataException(noSuchIdentifierException);
        }
    }

    @Override
    public synchronized boolean isEmpty() {
        if (this.size == -1) {
            this.size = this.count(true);
            if (this.size != 0) {
                this.size = -2;
            }
        }
        return this.size == 0;
    }

    @Override
    public synchronized int size() {
        if (this.size < 0) {
            this.size = this.count(false);
        }
        return this.size;
    }

    private int count(boolean bl) {
        int n = 0;
        try {
            Statement statement = this.connection.createStatement();
            ResultSet resultSet = statement.executeQuery(this.sqlAll);
            while (resultSet.next()) {
                if (!this.isAcceptable(resultSet)) continue;
                ++n;
                if (!bl) continue;
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            AuthorityCodes.unexpectedException(bl ? "isEmpty" : "size", sQLException);
        }
        return n;
    }

    @Override
    public synchronized boolean contains(Object object) {
        boolean bl = false;
        if (object != null) {
            try {
                ResultSet resultSet = this.getSingle(object);
                if (resultSet != null) {
                    while (resultSet.next()) {
                        if (!this.isAcceptable(resultSet)) continue;
                        bl = true;
                        break;
                    }
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                AuthorityCodes.unexpectedException("contains", sQLException);
            }
        }
        return bl;
    }

    @Override
    public synchronized java.util.Iterator<String> iterator() {
        try {
            return new Iterator(this.connection.createStatement().executeQuery(this.sqlAll));
        }
        catch (SQLException sQLException) {
            AuthorityCodes.unexpectedException("iterator", sQLException);
            return Collections.emptySet().iterator();
        }
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new LinkedHashSet<String>(this);
    }

    protected synchronized void finalize() throws SQLException {
        if (this.querySingle != null) {
            this.querySingle.close();
            this.querySingle = null;
        }
    }

    private static void unexpectedException(String string, SQLException sQLException) {
        AuthorityCodes.unexpectedException(AuthorityCodes.class, string, sQLException);
    }

    static void unexpectedException(Class<?> clazz, String string, SQLException sQLException) {
        Logging.unexpectedException(clazz, string, sQLException);
    }

    final java.util.Map<String, String> asMap() {
        if (this.asMap == null) {
            this.asMap = new Map();
        }
        return this.asMap;
    }

    private final class Map
    extends AbstractMap<String, String> {
        private Map() {
        }

        @Override
        public int size() {
            return AuthorityCodes.this.size();
        }

        @Override
        public boolean isEmpty() {
            return AuthorityCodes.this.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String get(Object object) {
            String string = null;
            if (object != null) {
                try {
                    AuthorityCodes authorityCodes = AuthorityCodes.this;
                    synchronized (authorityCodes) {
                        ResultSet resultSet = AuthorityCodes.this.getSingle(object);
                        if (resultSet != null) {
                            while (resultSet.next()) {
                                if (!AuthorityCodes.this.isAcceptable(resultSet)) continue;
                                string = resultSet.getString(2);
                                break;
                            }
                            resultSet.close();
                        }
                    }
                }
                catch (SQLException sQLException) {
                    AuthorityCodes.unexpectedException("get", sQLException);
                }
            }
            return string;
        }

        @Override
        public boolean containsKey(Object object) {
            return AuthorityCodes.this.contains(object);
        }

        @Override
        public Set<String> keySet() {
            return AuthorityCodes.this;
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            throw new UnsupportedOperationException();
        }
    }

    private final class Iterator
    implements java.util.Iterator<String> {
        private ResultSet results;
        private transient String next;

        Iterator(ResultSet resultSet) throws SQLException {
            assert (Thread.holdsLock(AuthorityCodes.this));
            this.results = resultSet;
            this.toNext();
        }

        private void toNext() throws SQLException {
            while (this.results.next()) {
                this.next = this.results.getString(1);
                if (!AuthorityCodes.this.isAcceptable(this.next)) continue;
                return;
            }
            this.finalize();
        }

        @Override
        public boolean hasNext() {
            return this.results != null;
        }

        @Override
        public String next() {
            if (this.results == null) {
                throw new NoSuchElementException();
            }
            String string = this.next;
            try {
                this.toNext();
            }
            catch (SQLException sQLException) {
                try {
                    this.finalize();
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
                AuthorityCodes.unexpectedException(Iterator.class, "next", sQLException);
            }
            return string;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected void finalize() throws SQLException {
            this.next = null;
            if (this.results != null) {
                Statement statement = this.results.getStatement();
                this.results.close();
                this.results = null;
                statement.close();
            }
        }
    }
}

