/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.converter;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import net.jcip.annotations.Immutable;
import org.geotoolkit.util.converter.NonconvertibleObjectException;
import org.geotoolkit.util.converter.SimpleConverter;

@Immutable
abstract class URLConverter<T>
extends SimpleConverter<URL, T>
implements Serializable {
    private static final long serialVersionUID = 4843540356265851861L;

    URLConverter() {
    }

    @Override
    public final Class<URL> getSourceClass() {
        return URL.class;
    }

    @Override
    public boolean isOrderPreserving() {
        return false;
    }

    @Immutable
    static final class URI
    extends URLConverter<java.net.URI> {
        private static final long serialVersionUID = -1653233667050600894L;
        public static final URI INSTANCE = new URI();

        private URI() {
        }

        @Override
        public Class<java.net.URI> getTargetClass() {
            return java.net.URI.class;
        }

        @Override
        public java.net.URI convert(URL uRL) throws NonconvertibleObjectException {
            if (uRL == null) {
                return null;
            }
            try {
                return uRL.toURI();
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new NonconvertibleObjectException(URI.formatErrorMessage("URL", uRL, uRISyntaxException), uRISyntaxException);
            }
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class File
    extends URLConverter<java.io.File> {
        private static final long serialVersionUID = 1228852836485762335L;
        public static final File INSTANCE = new File();

        private File() {
        }

        @Override
        public Class<java.io.File> getTargetClass() {
            return java.io.File.class;
        }

        @Override
        public java.io.File convert(URL uRL) throws NonconvertibleObjectException {
            if (uRL == null) {
                return null;
            }
            try {
                return new java.io.File(uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new NonconvertibleObjectException(File.formatErrorMessage("URL", uRL, uRISyntaxException), uRISyntaxException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new NonconvertibleObjectException(File.formatErrorMessage("URL", uRL, illegalArgumentException), illegalArgumentException);
            }
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class String
    extends URLConverter<java.lang.String> {
        private static final long serialVersionUID = 8091677760312351740L;
        public static final String INSTANCE = new String();

        private String() {
        }

        @Override
        public Class<java.lang.String> getTargetClass() {
            return java.lang.String.class;
        }

        @Override
        public java.lang.String convert(URL uRL) throws NonconvertibleObjectException {
            return uRL != null ? uRL.toExternalForm() : null;
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }
}

