/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.geomatics.time;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import org.geotoolkit.temporal.factory.DefaultTemporalFactory;
import org.geotoolkit.temporal.object.DefaultPosition;
import org.opengis.temporal.Instant;
import org.opengis.temporal.Period;
import org.opengis.temporal.RelativePosition;
import org.opengis.temporal.TemporalFactory;
import org.opengis.temporal.TemporalGeometricPrimitive;

public class TemporalUtils {
    private static final TemporalFactory TM_FACTORY = new DefaultTemporalFactory();

    public static void assertTemporalRelation(RelativePosition temporalRelation, TemporalGeometricPrimitive t1, TemporalGeometricPrimitive t2) {
        RelativePosition relPos = t1.relativePosition(t2);
        if (!relPos.equals(temporalRelation)) {
            throw new AssertionError((Object)String.format("t1 (%s) is not related to t2 (%s): %s. The actual temporal relation is %s.", TemporalUtils.temporalGeometricPrimitiveToString(t1), TemporalUtils.temporalGeometricPrimitiveToString(t2), temporalRelation.name(), null != relPos ? relPos.name() : "UNDEFINED"));
        }
    }

    public static String temporalGeometricPrimitiveToString(TemporalGeometricPrimitive timeObj) {
        StringBuilder strBuilder = new StringBuilder();
        if (Instant.class.isInstance(timeObj)) {
            strBuilder.append("Instant: ");
            Instant instant = (Instant)Instant.class.cast(timeObj);
            strBuilder.append(instant.getPosition().getDateTime());
        } else {
            strBuilder.append("Period: ");
            Period period = (Period)Period.class.cast(timeObj);
            strBuilder.append(period.getBeginning().getPosition().getDateTime()).append('/');
            strBuilder.append(period.getEnding().getPosition().getDateTime());
        }
        return strBuilder.toString();
    }

    public static Period temporalExtent(TreeSet<TemporalGeometricPrimitive> tmSet) {
        Instant endOfPeriod;
        if (tmSet.isEmpty()) {
            throw new IllegalArgumentException("Empty Set<TemporalGeometricPrimitive>");
        }
        TemporalGeometricPrimitive first = tmSet.first();
        TemporalGeometricPrimitive last = tmSet.last();
        Instant startOfPeriod = first instanceof Instant ? (Instant)Instant.class.cast(first) : ((Period)Period.class.cast(first)).getBeginning();
        startOfPeriod = TemporalUtils.add(startOfPeriod, -1, ChronoUnit.HOURS);
        if (last instanceof Instant) {
            endOfPeriod = (Instant)Instant.class.cast(last);
            if (first instanceof Period && endOfPeriod.relativePosition(((Period)Period.class.cast(first)).getEnding()).equals(RelativePosition.BEFORE)) {
                endOfPeriod = ((Period)Period.class.cast(first)).getEnding();
            }
        } else {
            endOfPeriod = ((Period)Period.class.cast(last)).getEnding();
        }
        endOfPeriod = TemporalUtils.add(endOfPeriod, 1, ChronoUnit.HOURS);
        return TM_FACTORY.createPeriod(startOfPeriod, endOfPeriod);
    }

    public static Instant add(Instant instant, int amount, TemporalUnit unit) {
        DateTimeFormatter xsdDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXX");
        ZonedDateTime dateTime = ZonedDateTime.parse(instant.getPosition().getDateTime().toString(), xsdDateTimeFormatter);
        ZonedDateTime newDateTime = dateTime.plus(amount, unit);
        Instant newInstant = TM_FACTORY.createInstant(new DefaultPosition(Date.from(newDateTime.toInstant())));
        return newInstant;
    }

    public static List<Period> splitInterval(Period period, int size) {
        DateTimeFormatter xsdDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXX");
        ZonedDateTime startDateTime = ZonedDateTime.parse(period.getBeginning().getPosition().getDateTime().toString(), xsdDateTimeFormatter);
        ZonedDateTime endDateTime = ZonedDateTime.parse(period.getEnding().getPosition().getDateTime().toString(), xsdDateTimeFormatter);
        Duration duration = Duration.between(startDateTime, endDateTime).dividedBy(size);
        ArrayList<Period> subIntervals = new ArrayList<Period>();
        for (int i = 0; i < size; ++i) {
            Instant startInstant = TM_FACTORY.createInstant(new DefaultPosition(Date.from(startDateTime.toInstant())));
            endDateTime = startDateTime.plus(duration);
            Instant endInstant = TM_FACTORY.createInstant(new DefaultPosition(Date.from(endDateTime.toInstant())));
            subIntervals.add(TM_FACTORY.createPeriod(startInstant, endInstant));
            startDateTime = endDateTime;
        }
        return subIntervals;
    }
}

