/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19136.general;

import java.util.List;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.opengis.cite.iso19136.ErrorMessage;
import org.opengis.cite.iso19136.general.SchemaModelFixture;
import org.opengis.cite.iso19136.util.XMLSchemaModelUtils;
import org.opengis.cite.validation.ErrorSeverity;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ModelAndSyntaxTests
extends SchemaModelFixture {
    @Test(description="See ISO 19136: 7.1.3, A.1.1.7")
    public void verifyGMLObjectPropertyPattern() {
        ValidationErrorHandler errCollector = new ValidationErrorHandler();
        for (XSElementDeclaration gmlObject : this.gmlObjects) {
            XSComplexTypeDefinition typeDef = (XSComplexTypeDefinition)gmlObject.getTypeDefinition();
            List<XSElementDeclaration> elemDecls = XMLSchemaModelUtils.getAllElementsInParticle(typeDef.getParticle());
            for (XSElementDeclaration elem : elemDecls) {
                if (this.isGMLObject(elem)) {
                    errCollector.addError(ErrorSeverity.ERROR, ErrorMessage.format("PropertyIsGMLObject", elem.getNamespace(), elem.getName(), typeDef.getName()), null);
                }
                if (!this.hasIDTypeAttribute(elem)) continue;
                errCollector.addError(ErrorSeverity.ERROR, ErrorMessage.format("PropertyHasIDAttr", elem.getNamespace(), elem.getName(), typeDef.getName()), null);
            }
        }
        Assert.assertFalse(errCollector.errorsDetected(), errCollector.toString());
    }

    boolean isGMLObject(XSElementDeclaration elemDecl) {
        XSTypeDefinition typeDef = elemDecl.getTypeDefinition();
        if (typeDef.getTypeCategory() == 16) {
            return false;
        }
        boolean isGMLObject = typeDef.derivedFrom("http://www.opengis.net/gml/3.2", "AbstractGMLType", (short)1) || typeDef.derivedFrom("http://www.opengis.net/gml/3.2", "AbstractGMLType", (short)2);
        return isGMLObject;
    }

    boolean hasIDTypeAttribute(XSElementDeclaration elemDecl) {
        XSTypeDefinition typeDef = elemDecl.getTypeDefinition();
        if (typeDef.getTypeCategory() == 16) {
            return false;
        }
        XSComplexTypeDefinition complexType = (XSComplexTypeDefinition)typeDef;
        XSObjectList attrUses = complexType.getAttributeUses();
        boolean foundIDAttr = false;
        for (int i = 0; i < attrUses.getLength(); ++i) {
            XSAttributeUse attrUse = (XSAttributeUse)attrUses.item(i);
            XSSimpleTypeDefinition attrType = attrUse.getAttrDeclaration().getTypeDefinition();
            if (attrType.getBuiltInKind() != 27) continue;
            foundIDAttr = true;
            break;
        }
        return foundIDAttr;
    }
}

