/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.logging;

import java.text.AttributedCharacterIterator;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Strings;
import org.geotoolkit.util.converter.Classes;
import org.geotoolkit.util.logging.Logging;

public class LoggedFormat<T>
extends Format {
    private static final long serialVersionUID = 4578880360344271325L;
    private final Format format;
    private final Class<T> type;
    private Level level;
    private String logger;
    private String className;
    private String methodName;

    protected LoggedFormat(Format format, Class<T> clazz) {
        this.format = format;
        this.type = clazz;
        this.level = Level.WARNING;
    }

    public static <T> LoggedFormat<T> getInstance(Format format, Class<T> clazz) {
        return new LoggedFormat<T>(format, clazz);
    }

    public void setLogger(String string) {
        this.logger = string;
    }

    public void setLevel(Level level) {
        if (level != null) {
            this.level = level;
        }
    }

    public void setCaller(Class<?> clazz, String string) {
        this.className = clazz != null ? clazz.getCanonicalName() : null;
        this.methodName = string;
    }

    public T parse(String string) {
        if (string == null || (string = string.trim()).isEmpty()) {
            return null;
        }
        ParsePosition parsePosition = new ParsePosition(0);
        Object object = this.parseObject(string, parsePosition);
        int n = parsePosition.getIndex();
        int n2 = parsePosition.getErrorIndex();
        if (n2 >= 0 && n2 < n) {
            n = n2;
        }
        if (n < string.length()) {
            this.doLogWarning(LoggedFormat.formatUnparsable(string, 0, n, this.getWarningLocale(), this.level));
        } else if (object != null && !this.type.isInstance(object)) {
            this.doLogWarning(Errors.getResources(this.getWarningLocale()).getLogRecord(this.level, 76, object.getClass(), this.type));
            return null;
        }
        return this.type.cast(object);
    }

    @Override
    public Object parseObject(String string) throws ParseException {
        return this.format.parseObject(string);
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        return this.format.parseObject(string, parsePosition);
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format.format(object, stringBuffer, fieldPosition);
    }

    @Override
    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        return this.format.formatToCharacterIterator(object);
    }

    private void doLogWarning(LogRecord logRecord) {
        if (this.className != null) {
            logRecord.setSourceClassName(this.className);
        }
        if (this.methodName != null) {
            logRecord.setSourceMethodName(this.methodName);
        }
        this.logWarning(logRecord);
    }

    protected void logWarning(LogRecord logRecord) {
        if (this.logger != null) {
            Logger logger = Logging.getLogger(this.logger);
            if (logRecord.getLoggerName() == null) {
                logRecord.setLoggerName(logger.getName());
            }
            logger.log(logRecord);
        }
    }

    protected Locale getWarningLocale() {
        return Locale.getDefault();
    }

    public static String formatUnparsable(String string, int n, int n2, Locale locale) {
        return (String)LoggedFormat.doFormatUnparsable(string, n, n2, locale, null);
    }

    public static LogRecord formatUnparsable(String string, int n, int n2, Locale locale, Level level) {
        if (level == null) {
            level = Level.WARNING;
        }
        return (LogRecord)LoggedFormat.doFormatUnparsable(string, n, n2, locale, level);
    }

    private static Object doFormatUnparsable(String string, int n, int n2, Locale locale, Level level) {
        Errors errors = Errors.getResources(locale);
        int n3 = string.length();
        if (n2 < n) {
            n2 = n;
        }
        if (n2 == n3) {
            if (level != null) {
                return errors.getLogRecord(level, 208);
            }
            return errors.getString(208);
        }
        String string2 = ((Object)Strings.token(string, n2)).toString();
        string = string.substring(n);
        if (level != null) {
            return errors.getLogRecord(level, 233, string, string2);
        }
        return errors.getString(233, string, string2);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(Classes.getShortClassName(this)).append('[').append(Classes.getShortClassName(this.format));
        if (this.logger != null) {
            stringBuilder.append(", logger=").append(this.logger);
        }
        return stringBuilder.append(']').toString();
    }
}

