/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19136.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.saxon.s9api.DOMDestination;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.opengis.cite.iso19136.util.NamespaceBindings;
import org.opengis.cite.iso19136.util.TestSuiteLogger;
import org.opengis.cite.iso19136.util.URIUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtils {
    private static final Logger LOGR = Logger.getLogger(XMLUtils.class.getPackage().getName());
    private static final XPathFactory XPATH_FACTORY = XMLUtils.initXPathFactory();

    private static XPathFactory initXPathFactory() {
        XPathFactory factory = XPathFactory.newInstance();
        return factory;
    }

    public static String writeNodeToString(Node node) {
        if (null == node) {
            return "";
        }
        Object writer = null;
        try {
            Transformer idTransformer = TransformerFactory.newInstance().newTransformer();
            Properties outProps = new Properties();
            outProps.setProperty("encoding", "US-ASCII");
            outProps.setProperty("omit-xml-declaration", "yes");
            outProps.setProperty("indent", "yes");
            idTransformer.setOutputProperties(outProps);
            writer = new StringWriter();
            idTransformer.transform(new DOMSource(node), new StreamResult((Writer)writer));
        }
        catch (TransformerException ex) {
            TestSuiteLogger.log(Level.WARNING, "Failed to serialize node " + node.getNodeName(), ex);
        }
        return writer.toString();
    }

    public static String resultToString(Result result) {
        if (null == result) {
            throw new IllegalArgumentException("Result is null.");
        }
        StringWriter writer = new StringWriter();
        if (result instanceof DOMResult) {
            Node node = ((DOMResult)DOMResult.class.cast(result)).getNode();
            Properties outProps = new Properties();
            outProps.setProperty("encoding", "UTF-8");
            outProps.setProperty("omit-xml-declaration", "yes");
            outProps.setProperty("indent", "yes");
            try {
                Transformer idTransformer = TransformerFactory.newInstance().newTransformer();
                idTransformer.setOutputProperties(outProps);
                idTransformer.transform(new DOMSource(node), new StreamResult(writer));
            }
            catch (TransformerException | TransformerFactoryConfigurationError e) {
                LOGR.warning(e.getMessage());
            }
        } else if (result instanceof StreamResult) {
            StreamResult streamResult = (StreamResult)StreamResult.class.cast(result);
            OutputStream os = streamResult.getOutputStream();
            if (null != os) {
                writer.write(os.toString());
            } else {
                Path path = Paths.get(URI.create(streamResult.getSystemId()));
                try {
                    byte[] data = Files.readAllBytes(path);
                    writer.write(new String(data));
                }
                catch (IOException e) {
                    LOGR.warning(e.getMessage());
                }
            }
        } else {
            throw new IllegalArgumentException("Unsupported Result type:" + result.getClass());
        }
        return writer.toString();
    }

    public static void writeNode(Node node, OutputStream outputStream) {
        try {
            Transformer idTransformer = TransformerFactory.newInstance().newTransformer();
            Properties outProps = new Properties();
            outProps.setProperty("method", "xml");
            outProps.setProperty("encoding", "UTF-8");
            outProps.setProperty("omit-xml-declaration", "yes");
            outProps.setProperty("indent", "yes");
            idTransformer.setOutputProperties(outProps);
            idTransformer.transform(new DOMSource(node), new StreamResult(outputStream));
        }
        catch (TransformerException ex) {
            String nodeName = node.getNodeType() == 9 ? ((Document)Document.class.cast(node)).getDocumentElement().getNodeName() : node.getNodeName();
            TestSuiteLogger.log(Level.WARNING, "Failed to serialize DOM node: " + nodeName, ex);
        }
    }

    public static NodeList evaluateXPath(Node context, String expr, Map<String, String> namespaceBindings) throws XPathExpressionException {
        Object result = XMLUtils.evaluateXPath(context, expr, namespaceBindings, XPathConstants.NODESET);
        if (!NodeList.class.isInstance(result)) {
            throw new XPathExpressionException("Expression does not evaluate to a NodeList: " + expr);
        }
        return (NodeList)result;
    }

    public static Object evaluateXPath(Node context, String expr, Map<String, String> namespaceBindings, QName returnType) throws XPathExpressionException {
        NamespaceBindings bindings = NamespaceBindings.withStandardBindings();
        bindings.addAllBindings(namespaceBindings);
        XPathFactory factory = XPATH_FACTORY;
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(bindings);
        Object result = xpath.evaluate(expr, context, returnType);
        return result;
    }

    public static Object evaluateXPath(Source source, String expr, Map<String, String> namespaceBindings, QName returnType) throws XPathExpressionException {
        if (StAXSource.class.isInstance(source)) {
            throw new IllegalArgumentException("StAXSource not supported.");
        }
        if (DOMSource.class.isInstance(source)) {
            DOMSource domSource = (DOMSource)source;
            return XMLUtils.evaluateXPath(domSource.getNode(), expr, namespaceBindings, returnType);
        }
        InputSource xmlSource = null;
        if (StreamSource.class.isInstance(source)) {
            StreamSource streamSource = (StreamSource)source;
            xmlSource = new InputSource(streamSource.getInputStream());
            xmlSource.setSystemId(source.getSystemId());
        }
        if (SAXSource.class.isInstance(source)) {
            SAXSource saxSource = (SAXSource)source;
            xmlSource = saxSource.getInputSource();
            xmlSource.setSystemId(source.getSystemId());
        }
        NamespaceBindings bindings = NamespaceBindings.withStandardBindings();
        bindings.addAllBindings(namespaceBindings);
        XPath xpath = XPATH_FACTORY.newXPath();
        xpath.setNamespaceContext(bindings);
        return xpath.evaluate(expr, xmlSource, returnType);
    }

    public static XdmValue evaluateXPath2(Source xmlSource, String expr, Map<String, String> nsBindings) throws SaxonApiException {
        Processor proc = new Processor(false);
        XPathCompiler compiler = proc.newXPathCompiler();
        if (null != nsBindings) {
            for (String nsURI : nsBindings.keySet()) {
                compiler.declareNamespace(nsBindings.get(nsURI), nsURI);
            }
        }
        XPathSelector xpath = compiler.compile(expr).load();
        DocumentBuilder builder = proc.newDocumentBuilder();
        XdmNode node = null;
        if (DOMSource.class.isInstance(xmlSource)) {
            DOMSource domSource = (DOMSource)xmlSource;
            node = builder.wrap((Object)domSource.getNode());
        } else {
            node = builder.build(xmlSource);
        }
        xpath.setContextItem((XdmItem)node);
        return xpath.evaluate();
    }

    public static Element createElement(QName qName) {
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        Element elem = doc.createElementNS(qName.getNamespaceURI(), qName.getLocalPart());
        return elem;
    }

    public static List<Element> getElementsByNamespaceURI(Node node, String namespaceURI) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getNamespaceURI().equals(namespaceURI)) continue;
            list.add((Element)child);
        }
        return list;
    }

    public static Document transform(Source xslt, Node source) {
        Document sourceDoc = null;
        Document resultDoc = null;
        try {
            resultDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            if (source.getNodeType() == 9) {
                sourceDoc = (Document)source;
            } else {
                sourceDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                sourceDoc.appendChild(sourceDoc.importNode(source, true));
            }
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce);
        }
        Processor processor = new Processor(false);
        XsltCompiler compiler = processor.newXsltCompiler();
        try {
            XsltExecutable exec = compiler.compile(xslt);
            XsltTransformer transformer = exec.load();
            transformer.setSource((Source)new DOMSource(sourceDoc));
            transformer.setDestination((Destination)new DOMDestination(resultDoc));
            transformer.transform();
        }
        catch (SaxonApiException e) {
            throw new RuntimeException(e);
        }
        return resultDoc;
    }

    public static Node getPropertyValue(Node propertyNode) {
        Element value = null;
        Element propElem = (Element)propertyNode;
        String href = propElem.getAttributeNS("http://www.w3.org/1999/xlink", "href");
        if (href.isEmpty()) {
            value = (Element)propElem.getElementsByTagName("*").item(0);
        } else {
            URI uriRef = null;
            try {
                Document referent = null;
                uriRef = URI.create(href);
                if (!uriRef.isAbsolute()) {
                    String baseURI = propertyNode.getOwnerDocument().getBaseURI();
                    uriRef = URIUtils.resolveRelativeURI(baseURI, uriRef.toString());
                }
                referent = URIUtils.parseURI(uriRef);
                value = null == uriRef.getFragment() ? referent.getDocumentElement() : XMLUtils.getFragment(referent, uriRef.getFragment());
            }
            catch (IOException | SAXException e) {
                TestSuiteLogger.log(Level.WARNING, String.format("Failed to read value of property %s from %s", propertyNode.getNodeName(), uriRef));
            }
        }
        return value;
    }

    public static Element getFragment(Document doc, String fragmentId) {
        if (fragmentId.indexOf(40) > 0) {
            throw new UnsupportedOperationException("Scheme-based pointers are not currently supported.");
        }
        Element fragment = null;
        String expr = String.format("//*[@gml:id='%s']", fragmentId);
        try {
            NodeList nodeList = XMLUtils.evaluateXPath(doc, expr, null);
            if (nodeList.getLength() > 0) {
                fragment = (Element)nodeList.item(0).cloneNode(true);
            }
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        return fragment;
    }
}

