/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.spi.util;

import com.occamlab.te.spi.stats.SessionDetails;
import com.occamlab.te.spi.stats.TEStatisticsErrorHandler;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.management.AttributeNotFoundException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class TEStatisticsUtil {
    static Logger logger = Logger.getLogger(TEStatisticsUtil.class.getName());
    public static Map<String, Long> testSuiteFailedTestDrillDownMap = new HashMap<String, Long>();

    public static Map<String, List<SessionDetails>> processUserDir(File usersDir) {
        HashMap<String, List<SessionDetails>> userDetails = new HashMap<String, List<SessionDetails>>();
        Object[] userDirList = usersDir.list();
        if (null != userDirList && 0 < userDirList.length) {
            Arrays.sort(userDirList);
            Integer i = 0;
            while (i < userDirList.length) {
                Object[] sessionDirs = new File(usersDir, (String)userDirList[i]).list();
                if (null != sessionDirs && 0 < sessionDirs.length) {
                    Arrays.sort(sessionDirs);
                    ArrayList<SessionDetails> sessions = new ArrayList<SessionDetails>();
                    Integer j = 0;
                    while (j < sessionDirs.length) {
                        File sessionDir = new File(new File(usersDir, (String)userDirList[i]), (String)sessionDirs[j]);
                        File sessionFile = new File(sessionDir, "session.xml");
                        File logFile = null;
                        if (sessionFile.exists()) {
                            try {
                                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                                dbf.setValidating(false);
                                dbf.setNamespaceAware(true);
                                DocumentBuilder db = dbf.newDocumentBuilder();
                                db.setErrorHandler(new TEStatisticsErrorHandler());
                                Document doc = db.parse(sessionFile);
                                Element session = (Element)doc.getElementsByTagName("session").item(0);
                                SessionDetails user = new SessionDetails();
                                if (!session.hasAttribute("id")) {
                                    throw new AttributeNotFoundException("'id' attribute not found in : '" + sessionFile + "'");
                                }
                                user.setId(session.getAttribute("id"));
                                if (!session.hasAttribute("sourcesId")) {
                                    throw new AttributeNotFoundException("'sourceId' attribute not found in : '" + sessionFile + "'");
                                }
                                user.setEtsName(session.getAttribute("sourcesId"));
                                if (!session.hasAttribute("date")) {
                                    throw new AttributeNotFoundException("'date' attribute not found in : '" + sessionFile + "'");
                                }
                                user.setDate(session.getAttribute("date"));
                                sessions.add(user);
                                logFile = new File(sessionDir, "log.xml");
                                List<String> failedTestList = null;
                                Integer status = TEStatisticsUtil.getSessionResult(logFile);
                                if (status == 6) {
                                    failedTestList = TEStatisticsUtil.getListOfFailedTest(sessionDir);
                                }
                                user.setStatus(status);
                                user.setFailedTestList(failedTestList);
                            }
                            catch (SAXParseException pe) {
                                logger.log(Level.SEVERE, "Error: Unable to parse xml >> Public ID: " + pe.getPublicId() + ", System ID: " + pe.getSystemId() + ", Line number: " + pe.getLineNumber() + ", Column number: " + pe.getColumnNumber() + ", Message: " + pe.getMessage());
                            }
                            catch (FileNotFoundException fnfe) {
                                logger.log(Level.SEVERE, "Error: Log file not found at -> " + logFile);
                            }
                            catch (NullPointerException npe) {
                                logger.log(Level.SEVERE, "Error:" + npe.getMessage() + " at -> " + logFile);
                            }
                            catch (AttributeNotFoundException anfe) {
                                logger.log(Level.SEVERE, "Error: Attribute not found in session." + anfe.getMessage() + " at -> " + logFile);
                            }
                            catch (Exception e) {
                                logger.log(Level.SEVERE, "Error: Mandatory values are not valid: ' " + e.getMessage() + " ' at -> " + logFile);
                            }
                        }
                        Integer n = j;
                        Integer n2 = j = Integer.valueOf(j + 1);
                    }
                    userDetails.put((String)userDirList[i], sessions);
                }
                Integer n = i;
                Integer n3 = i = Integer.valueOf(i + 1);
            }
        }
        return userDetails;
    }

    public static Integer getSessionResult(File logFile) {
        if (logFile.exists()) {
            Document doc = TEStatisticsUtil.parse(logFile);
            NodeList logElementList = doc.getElementsByTagName("log");
            Element logElement = (Element)logElementList.item(0);
            NodeList testResult = logElement.getElementsByTagName("endtest");
            if (testResult.getLength() == 0) {
                throw new NoSuchElementException("The 'endtest' element not found in log file.");
            }
            Element resultStatus = (Element)testResult.item(0);
            if (resultStatus.hasAttribute("result") && !resultStatus.getAttribute("result").equals("")) {
                return Integer.parseInt(resultStatus.getAttribute("result"));
            }
            throw new RuntimeException("The 'result' attribute not found or having the NULL value in log file.");
        }
        return 0;
    }

    public static List<String> getListOfFailedTest(File sessionDir) {
        File testngDir = new File(sessionDir, "testng");
        ArrayList<String> failedTestList = new ArrayList<String>();
        File testngResult = null;
        if (testngDir.exists()) {
            String[] dir2 = testngDir.list();
            File testngUuidDirectory = new File(testngDir, dir2[0]);
            if (testngUuidDirectory.isDirectory()) {
                testngResult = new File(testngUuidDirectory, "testng-results.xml");
            }
            if (testngResult.exists()) {
                Document doc = TEStatisticsUtil.parse(testngResult);
                NodeList failedNodeList = null;
                try {
                    failedNodeList = TEStatisticsUtil.evaluateXPath(doc, "//test/class/test-method[@status='FAIL']");
                    Integer i = 0;
                    while (i < failedNodeList.getLength()) {
                        Element testElement = (Element)failedNodeList.item(i);
                        if (testElement.hasAttribute("name")) {
                            failedTestList.add(testElement.getAttribute("name"));
                        }
                        Integer n = i;
                        Integer n2 = i = Integer.valueOf(i + 1);
                    }
                }
                catch (XPathExpressionException xpe) {
                    throw new RuntimeException(xpe);
                }
            }
        }
        return failedTestList;
    }

    public static NodeList evaluateXPath(Node context, String expr) throws XPathExpressionException {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        Object result = xpath.evaluate(expr, context, XPathConstants.NODESET);
        if (!NodeList.class.isInstance(result)) {
            throw new XPathExpressionException("Expression does not evaluate to a NodeList: " + expr);
        }
        return (NodeList)result;
    }

    public static Document parse(File configFile) {
        Document doc = null;
        try {
            FileInputStream inputStream = new FileInputStream(configFile);
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            InputSource is = new InputSource(reader);
            is.setEncoding("UTF-8");
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setValidating(false);
            dbFactory.setNamespaceAware(true);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            dBuilder.setErrorHandler(new TEStatisticsErrorHandler());
            doc = dBuilder.parse(is);
            doc.getDocumentElement().normalize();
        }
        catch (SAXParseException pe) {
            logger.log(Level.SEVERE, "Error: Unable to parse xml >> Public ID: " + pe.getPublicId() + ", System ID: " + pe.getSystemId() + ", Line number: " + pe.getLineNumber() + ", Column number: " + pe.getColumnNumber() + ", Message: " + pe.getMessage());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error: In main method Mandatory values are not valid: ' " + e.getMessage() + " '");
            e.printStackTrace();
        }
        return doc;
    }

    public static ArrayList<Long> numberOfUsersExecutedTestSuitePerMonth(String testSuiteName, Map<String, List<SessionDetails>> sessionDetailsList) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern("yyyy/MM/dd  HH:mm:ss");
        DateTime currentTime = DateTime.now();
        ArrayList<Integer> monthList = new ArrayList<Integer>(Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12));
        ArrayList<Long> testSuiteUsersPerMonth = new ArrayList<Long>();
        for (Integer month : monthList) {
            long count = 0L;
            long cnt = 0L;
            for (Map.Entry<String, List<SessionDetails>> userSessions : sessionDetailsList.entrySet()) {
                List<SessionDetails> sessionList = userSessions.getValue();
                count = sessionList.stream().filter(session -> session.getEtsName().contains(testSuiteName) && formatter.parseDateTime(session.getDate()).getYear() == currentTime.getYear() && formatter.parseDateTime(session.getDate()).getMonthOfYear() == month.intValue()).collect(Collectors.counting());
                if (count <= 0L) continue;
                ++cnt;
            }
            testSuiteUsersPerMonth.add(cnt);
        }
        return testSuiteUsersPerMonth;
    }

    public static ArrayList<Long> testSuiteRunPerMonth(String testSuiteName, Map<String, List<SessionDetails>> sessionDetailsList) {
        long jan = 0L;
        long feb = 0L;
        long mar = 0L;
        long apr = 0L;
        long may = 0L;
        long jun = 0L;
        long jul = 0L;
        long aug = 0L;
        long sep = 0L;
        long oct = 0L;
        long nov = 0L;
        long dec = 0L;
        DateTimeFormatter formatter = DateTimeFormat.forPattern("yyyy/MM/dd  HH:mm:ss");
        DateTime currentTime = DateTime.now();
        List foundSessions = null;
        for (Map.Entry<String, List<SessionDetails>> userSessions : sessionDetailsList.entrySet()) {
            List<SessionDetails> sessionList = userSessions.getValue();
            foundSessions = sessionList.stream().filter(session -> session.getEtsName().contains(testSuiteName) && formatter.parseDateTime(session.getDate()).getYear() == currentTime.getYear()).collect(Collectors.toList());
            if (foundSessions == null || foundSessions.isEmpty()) continue;
            for (SessionDetails session2 : foundSessions) {
                DateTime sessionDate = formatter.parseDateTime(session2.getDate());
                Integer sessionMonth = sessionDate.getMonthOfYear();
                switch (sessionMonth) {
                    case 1: {
                        ++jan;
                        break;
                    }
                    case 2: {
                        ++feb;
                        break;
                    }
                    case 3: {
                        ++mar;
                        break;
                    }
                    case 4: {
                        ++apr;
                        break;
                    }
                    case 5: {
                        ++may;
                        break;
                    }
                    case 6: {
                        ++jun;
                        break;
                    }
                    case 7: {
                        ++jul;
                        break;
                    }
                    case 8: {
                        ++aug;
                        break;
                    }
                    case 9: {
                        ++sep;
                        break;
                    }
                    case 10: {
                        ++oct;
                        break;
                    }
                    case 11: {
                        ++nov;
                        break;
                    }
                    case 12: {
                        ++dec;
                    }
                }
            }
        }
        ArrayList<Long> testSuiteRunsPerMonth = new ArrayList<Long>(Arrays.asList(jan, feb, mar, apr, may, jun, jul, aug, sep, oct, nov, dec));
        return testSuiteRunsPerMonth;
    }

    public static Map<String, ArrayList<Long>> testSuiteStatusPerMonth(String testSuiteName, Map<String, List<SessionDetails>> sessionDetailsList, Map<String, Integer> testStatus) {
        HashMap<String, ArrayList<Long>> testSuiteStatusPerMonth = new HashMap<String, ArrayList<Long>>();
        for (Map.Entry<String, Integer> status : testStatus.entrySet()) {
            long jan = 0L;
            long feb = 0L;
            long mar = 0L;
            long apr = 0L;
            long may = 0L;
            long jun = 0L;
            long jul = 0L;
            long aug = 0L;
            long sep = 0L;
            long oct = 0L;
            long nov = 0L;
            long dec = 0L;
            DateTimeFormatter formatter = DateTimeFormat.forPattern("yyyy/MM/dd  HH:mm:ss");
            DateTime currentTime = DateTime.now();
            List foundSessions = null;
            for (Map.Entry<String, List<SessionDetails>> userSessions : sessionDetailsList.entrySet()) {
                List<SessionDetails> sessionList = userSessions.getValue();
                if (status.getValue() == 0) {
                    foundSessions = sessionList.stream().filter(session -> session.getEtsName().contains(testSuiteName) && formatter.parseDateTime(session.getDate()).getYear() == currentTime.getYear() && session.getStatus() != ((Integer)testStatus.get("Success")).intValue() && session.getStatus() != ((Integer)testStatus.get("Failure")).intValue()).collect(Collectors.toList());
                } else if (status.getValue() == 6) {
                    foundSessions = sessionList.stream().filter(session -> session.getEtsName().contains(testSuiteName) && formatter.parseDateTime(session.getDate()).getYear() == currentTime.getYear()).collect(Collectors.toList());
                    foundSessions = foundSessions.stream().filter(session -> session.getStatus() == 5 || session.getStatus() == ((Integer)testStatus.get("Failure")).intValue()).collect(Collectors.toList());
                } else {
                    foundSessions = sessionList.stream().filter(session -> session.getEtsName().contains(testSuiteName) && formatter.parseDateTime(session.getDate()).getYear() == currentTime.getYear() && session.getStatus() == ((Integer)status.getValue()).intValue()).collect(Collectors.toList());
                }
                if (foundSessions == null || foundSessions.isEmpty()) continue;
                for (SessionDetails session2 : foundSessions) {
                    DateTime sessionDt = formatter.parseDateTime(session2.getDate());
                    Integer sessionMonth = sessionDt.getMonthOfYear();
                    switch (sessionMonth) {
                        case 1: {
                            ++jan;
                            break;
                        }
                        case 2: {
                            ++feb;
                            break;
                        }
                        case 3: {
                            ++mar;
                            break;
                        }
                        case 4: {
                            ++apr;
                            break;
                        }
                        case 5: {
                            ++may;
                            break;
                        }
                        case 6: {
                            ++jun;
                            break;
                        }
                        case 7: {
                            ++jul;
                            break;
                        }
                        case 8: {
                            ++aug;
                            break;
                        }
                        case 9: {
                            ++sep;
                            break;
                        }
                        case 10: {
                            ++oct;
                            break;
                        }
                        case 11: {
                            ++nov;
                            break;
                        }
                        case 12: {
                            ++dec;
                        }
                    }
                }
            }
            ArrayList<Long> statusPerMonth = new ArrayList<Long>(Arrays.asList(jan, feb, mar, apr, may, jun, jul, aug, sep, oct, nov, dec));
            testSuiteStatusPerMonth.put(status.getKey(), statusPerMonth);
        }
        return testSuiteStatusPerMonth;
    }

    public static Map<String, Object> testSuiteStatusWithDrilldown(String testSuiteName, Map<String, List<SessionDetails>> sessionDetailsList, Map<String, Integer> testStatus) {
        HashMap<String, Object> testSuiteStatusDrillDownMap = new HashMap<String, Object>();
        HashMap<String, Long> testSuiteFailedTestMap = new HashMap<String, Long>();
        for (Map.Entry<String, Integer> status : testStatus.entrySet()) {
            long testCount = 0L;
            DateTimeFormatter formatter = DateTimeFormat.forPattern("yyyy/MM/dd  HH:mm:ss");
            DateTime currentTime = DateTime.now();
            List foundSessions = null;
            for (Map.Entry<String, List<SessionDetails>> userSessions : sessionDetailsList.entrySet()) {
                List<SessionDetails> sessionList = userSessions.getValue();
                long count = 0L;
                if (status.getValue() == 0) {
                    count = sessionList.stream().filter(session -> session.getEtsName().contains(testSuiteName) && formatter.parseDateTime(session.getDate()).getYear() == currentTime.getYear() && session.getStatus() != ((Integer)testStatus.get("Success")).intValue() && session.getStatus() != ((Integer)testStatus.get("Failure")).intValue()).collect(Collectors.counting());
                    if (count <= 0L) continue;
                    testCount += count;
                    continue;
                }
                if (status.getValue() == 6) {
                    foundSessions = sessionList.stream().filter(session -> session.getEtsName().contains(testSuiteName) && formatter.parseDateTime(session.getDate()).getYear() == currentTime.getYear()).collect(Collectors.toList());
                    count = foundSessions.stream().filter(session -> session.getStatus() == 5 || session.getStatus() == ((Integer)testStatus.get("Failure")).intValue()).collect(Collectors.counting());
                    if (count > 0L) {
                        testCount += count;
                    }
                    if ((foundSessions = foundSessions.stream().filter(session -> session.getStatus() == 5 || session.getStatus() == ((Integer)testStatus.get("Failure")).intValue()).collect(Collectors.toList())) == null || foundSessions.isEmpty()) continue;
                    for (SessionDetails session2 : foundSessions) {
                        List<String> testList = session2.getFailedTestList();
                        if (testList == null || testList.isEmpty()) continue;
                        for (String test : testList) {
                            testSuiteFailedTestMap.compute(test, (k, v) -> v == null ? 1L : v + 1L);
                        }
                    }
                    continue;
                }
                count = sessionList.stream().filter(session -> session.getEtsName().contains(testSuiteName) && formatter.parseDateTime(session.getDate()).getYear() == currentTime.getYear() && session.getStatus() == ((Integer)status.getValue()).intValue()).collect(Collectors.counting());
                if (count <= 0L) continue;
                testCount += count;
            }
            testSuiteStatusDrillDownMap.put(status.getKey(), testCount);
        }
        testSuiteFailedTestDrillDownMap.clear();
        testSuiteFailedTestDrillDownMap.putAll(testSuiteFailedTestMap);
        return testSuiteStatusDrillDownMap;
    }

    public static String getArrayListAsString(ArrayList<Long> usersPerMonth) {
        Iterator<Long> it = usersPerMonth.iterator();
        String arrayList = "[";
        while (it.hasNext()) {
            arrayList = arrayList + it.next();
            if (it.hasNext()) {
                arrayList = arrayList + ",";
                continue;
            }
            arrayList = arrayList + "]";
        }
        return arrayList;
    }

    public static void generateTestSuiteStatisticsHtmlReport(String testSuiteName, Integer year, File statisticsResultDir, String numberOfUsersExecutedTestSuitePerMonth, String testSuiteRunPerMonth, String successArray, String failureArray, String incompleteArray, String testSuiteStatusWithDrilldown, String testSuiteFailedTestDrillDownMap) {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            String xmlTemplate1 = "<note><to>Tove</to><from>Jani</from><heading>Reminder</heading><body>Don't forget me this weekend!</body></note>";
            ByteArrayInputStream input = new ByteArrayInputStream(xmlTemplate1.getBytes("UTF-8"));
            String statXsl = cl.getResource("com/occamlab/te/stats/test_suite_stats.xsl").toString();
            Transformer transformer = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", null).newTransformer(new StreamSource(statXsl));
            transformer.setParameter("testSuiteName", testSuiteName);
            transformer.setParameter("year", year);
            transformer.setParameter("numberOfUsersExecutedTestSuitePerMonth", numberOfUsersExecutedTestSuitePerMonth);
            transformer.setParameter("testSuiteRunPerMonth", testSuiteRunPerMonth);
            transformer.setParameter("successArray", successArray);
            transformer.setParameter("failureArray", failureArray);
            transformer.setParameter("incompleteArray", incompleteArray);
            transformer.setParameter("testSuiteStatusWithDrilldown", testSuiteStatusWithDrilldown);
            transformer.setParameter("testSuiteFailedTestDrillDownMap", testSuiteFailedTestDrillDownMap);
            if (!statisticsResultDir.exists()) {
                statisticsResultDir.mkdir();
            }
            testSuiteName = testSuiteName.replace(" ", "_");
            File testSuiteHtml = new File(statisticsResultDir, testSuiteName + "_stats.html");
            testSuiteHtml.createNewFile();
            FileOutputStream fo = new FileOutputStream(testSuiteHtml);
            transformer.transform(new StreamSource(input), new StreamResult(fo));
            fo.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Map<String, Object> testSuiteRunDetailsOfCurrentYear(String testSuiteName, Map<String, List<SessionDetails>> sessionDetailsList) {
        HashMap<String, Object> testSuiteRunDetails = new HashMap<String, Object>();
        long count = 0L;
        List foundSessions = null;
        for (Map.Entry<String, List<SessionDetails>> userSessions : sessionDetailsList.entrySet()) {
            List<SessionDetails> sessionList = userSessions.getValue();
            foundSessions = sessionList.stream().filter(session -> session.getEtsName().contains(testSuiteName)).collect(Collectors.toList());
            DateTime currentTime = null;
            if (foundSessions == null || foundSessions.isEmpty()) continue;
            for (SessionDetails session2 : foundSessions) {
                try {
                    currentTime = DateTime.now();
                    String testExecutionTime = session2.getDate();
                    DateTime testExecutionDt = DateTimeFormat.forPattern("yyyy/MM/dd  HH:mm:ss").parseDateTime(testExecutionTime);
                    if (testExecutionDt.getYear() != currentTime.getYear()) continue;
                    ++count;
                }
                catch (Exception e) {
                    System.out.println("Error: " + e.getMessage());
                }
            }
        }
        testSuiteRunDetails.put(testSuiteName, count);
        return testSuiteRunDetails;
    }

    public static ArrayList<Long> testsRunPerMonthofCurrentYear(Map<String, List<SessionDetails>> sessionDetailsList) {
        long jan = 0L;
        long feb = 0L;
        long mar = 0L;
        long apr = 0L;
        long may = 0L;
        long jun = 0L;
        long jul = 0L;
        long aug = 0L;
        long sep = 0L;
        long oct = 0L;
        long nov = 0L;
        long dec = 0L;
        DateTimeFormatter formatter = DateTimeFormat.forPattern("yyyy/MM/dd  HH:mm:ss");
        DateTime currentTime = DateTime.now();
        List foundSessions = null;
        for (Map.Entry<String, List<SessionDetails>> userSessions : sessionDetailsList.entrySet()) {
            List<SessionDetails> sessionList = userSessions.getValue();
            foundSessions = sessionList.stream().filter(session -> formatter.parseDateTime(session.getDate()).getYear() == currentTime.getYear()).collect(Collectors.toList());
            if (foundSessions == null || foundSessions.isEmpty()) continue;
            for (SessionDetails session2 : foundSessions) {
                DateTime sessionDt = formatter.parseDateTime(session2.getDate());
                Integer sessionMonth = sessionDt.getMonthOfYear();
                switch (sessionMonth) {
                    case 1: {
                        ++jan;
                        break;
                    }
                    case 2: {
                        ++feb;
                        break;
                    }
                    case 3: {
                        ++mar;
                        break;
                    }
                    case 4: {
                        ++apr;
                        break;
                    }
                    case 5: {
                        ++may;
                        break;
                    }
                    case 6: {
                        ++jun;
                        break;
                    }
                    case 7: {
                        ++jul;
                        break;
                    }
                    case 8: {
                        ++aug;
                        break;
                    }
                    case 9: {
                        ++sep;
                        break;
                    }
                    case 10: {
                        ++oct;
                        break;
                    }
                    case 11: {
                        ++nov;
                        break;
                    }
                    case 12: {
                        ++dec;
                    }
                }
            }
        }
        ArrayList<Long> testRunsPerMonth = new ArrayList<Long>(Arrays.asList(jan, feb, mar, apr, may, jun, jul, aug, sep, oct, nov, dec));
        return testRunsPerMonth;
    }

    public static ArrayList<Long> usersPerMonthofCurrentYear(Map<String, List<SessionDetails>> sessionDetailsList) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern("yyyy/MM/dd  HH:mm:ss");
        DateTime currentTime = DateTime.now();
        ArrayList<Integer> monthList = new ArrayList<Integer>(Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12));
        ArrayList<Long> userPerMonth = new ArrayList<Long>();
        for (Integer month : monthList) {
            long count = 0L;
            long cnt = 0L;
            for (Map.Entry<String, List<SessionDetails>> userSessions : sessionDetailsList.entrySet()) {
                List<SessionDetails> sessionList = userSessions.getValue();
                count = sessionList.stream().filter(session -> formatter.parseDateTime(session.getDate()).getYear() == currentTime.getYear() && formatter.parseDateTime(session.getDate()).getMonthOfYear() == month.intValue()).collect(Collectors.counting());
                if (count <= 0L) continue;
                ++cnt;
            }
            userPerMonth.add(cnt);
        }
        return userPerMonth;
    }

    public static Map<String, Object> numberOfUsersPerTestSuite(String testSuiteName, Map<String, List<SessionDetails>> sessionDetailsList) {
        HashMap<String, Object> numberOfUsersPerTestSuite = new HashMap<String, Object>();
        DateTimeFormatter formatter = DateTimeFormat.forPattern("yyyy/MM/dd  HH:mm:ss");
        DateTime currentTime = DateTime.now();
        long count = 0L;
        long userCount = 0L;
        for (Map.Entry<String, List<SessionDetails>> userSessions : sessionDetailsList.entrySet()) {
            List<SessionDetails> sessionList = userSessions.getValue();
            count = sessionList.stream().filter(session -> session.getEtsName().contains(testSuiteName) && formatter.parseDateTime(session.getDate()).getYear() == currentTime.getYear()).collect(Collectors.counting());
            if (count <= 0L) continue;
            ++userCount;
        }
        numberOfUsersPerTestSuite.put(testSuiteName, userCount);
        return numberOfUsersPerTestSuite;
    }

    public static void generateOverallStatisticsHtmlReport(List<String> testSuiteNames, Integer year, File statResultDir, String allTestSuiteRunDetails, String testsRunPerMonth, String usersPerMonth, String numberOfUsersAndTestSuite) {
        try {
            File indexHtml;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            String xmlTemplate1 = "<note><to>Tove</to><from>Jani</from><heading>Reminder</heading><body>Don't forget me this weekend!</body></note>";
            ByteArrayInputStream input = new ByteArrayInputStream(xmlTemplate1.getBytes("UTF-8"));
            String statXsl = cl.getResource("com/occamlab/te/stats/overall_stats.xsl").toString();
            Transformer transformer = TransformerFactory.newInstance("net.sf.saxon.TransformerFactoryImpl", null).newTransformer(new StreamSource(statXsl));
            transformer.setParameter("testSuiteNames", testSuiteNames);
            transformer.setParameter("year", year);
            transformer.setParameter("allTestSuiteRunDetails", allTestSuiteRunDetails);
            transformer.setParameter("testsRunPerMonth", testsRunPerMonth);
            transformer.setParameter("usersPerMonth", usersPerMonth);
            transformer.setParameter("numberOfUsersAndTestSuite", numberOfUsersAndTestSuite);
            if (!statResultDir.exists()) {
                statResultDir.mkdir();
            }
            if ((indexHtml = new File(statResultDir, "index.html")).exists()) {
                indexHtml.delete();
            }
            indexHtml.createNewFile();
            FileOutputStream fo = new FileOutputStream(indexHtml);
            transformer.transform(new StreamSource(input), new StreamResult(fo));
            fo.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void zipDir(File zipFile, File dirPath) throws Exception {
        if (!dirPath.isDirectory()) {
            System.err.println(dirPath.getName() + " is not a directory");
            System.exit(1);
        }
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
            TEStatisticsUtil.addDir(dirPath, out);
            out.close();
        }
        catch (IOException e) {
            throw new Exception(e.getMessage());
        }
    }

    private static void addDir(File dirPath, ZipOutputStream out) throws IOException {
        File[] files = dirPath.listFiles();
        byte[] tempBuffer = new byte[1024];
        for (File file : files) {
            int length;
            FileInputStream in = new FileInputStream(file.getAbsolutePath());
            out.putNextEntry(new ZipEntry(file.getName()));
            while ((length = in.read(tempBuffer)) > 0) {
                out.write(tempBuffer, 0, length);
            }
            out.closeEntry();
            in.close();
        }
    }
}

