/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.geometry.jts;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Shape;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Vector3d;
import org.geotoolkit.display.shape.ShapeUtilities;
import org.geotoolkit.factory.HintsPending;
import org.geotoolkit.geometry.Envelope2D;
import org.geotoolkit.geometry.GeneralDirectPosition;
import org.geotoolkit.geometry.jts.JTSEnvelope2D;
import org.geotoolkit.geometry.jts.SRIDGenerator;
import org.geotoolkit.geometry.jts.transform.CoordinateSequenceMathTransformer;
import org.geotoolkit.geometry.jts.transform.GeometryCSTransformer;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.referencing.GeodeticCalculator;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.geotoolkit.referencing.operation.TransformPathNotFoundException;
import org.geotoolkit.referencing.operation.projection.ProjectionException;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.converter.Classes;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class JTS {
    private static final GeneralDirectPosition[] POSITIONS = new GeneralDirectPosition[4];
    private static final Map<CoordinateReferenceSystem, GeodeticCalculator> CALCULATORS;

    private JTS() {
    }

    private static void ensureNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(Errors.format(172, name));
        }
    }

    public static void ensureClosed(Coordinate[] array) {
        if (!array[0].equals2D(array[array.length - 1])) {
            array[array.length - 1].setCoordinate(array[0]);
        }
    }

    public static Envelope transform(Envelope envelope, MathTransform transform) throws TransformException {
        return JTS.transform(envelope, null, transform, 5);
    }

    public static Envelope transform(Envelope sourceEnvelope, Envelope targetEnvelope, MathTransform transform, int npoints) throws TransformException {
        int t;
        JTS.ensureNonNull("sourceEnvelope", sourceEnvelope);
        JTS.ensureNonNull("transform", transform);
        if (transform.getSourceDimensions() != 2 || transform.getTargetDimensions() != 2) {
            throw new MismatchedDimensionException(Errors.format(16, Classes.getShortClassName(transform)));
        }
        double[] coordinates = new double[4 * ++npoints * 2];
        double xmin = sourceEnvelope.getMinX();
        double xmax = sourceEnvelope.getMaxX();
        double ymin = sourceEnvelope.getMinY();
        double ymax = sourceEnvelope.getMaxY();
        double scaleX = (xmax - xmin) / (double)npoints;
        double scaleY = (ymax - ymin) / (double)npoints;
        int offset = 0;
        for (t = 0; t < npoints; ++t) {
            double dx = scaleX * (double)t;
            double dy = scaleY * (double)t;
            coordinates[offset++] = xmin;
            coordinates[offset++] = ymin + dy;
            coordinates[offset++] = xmin + dx;
            coordinates[offset++] = ymax;
            coordinates[offset++] = xmax;
            coordinates[offset++] = ymax - dy;
            coordinates[offset++] = xmax - dx;
            coordinates[offset++] = ymin;
        }
        assert (offset == coordinates.length);
        JTS.xform(transform, coordinates, coordinates);
        if (targetEnvelope == null) {
            targetEnvelope = new Envelope();
        }
        t = 0;
        while (t < offset) {
            targetEnvelope.expandToInclude(coordinates[t++], coordinates[t++]);
        }
        return targetEnvelope;
    }

    public static Geometry transform(Geometry geom, MathTransform transform) throws MismatchedDimensionException, TransformException {
        CoordinateSequenceMathTransformer cstrs = new CoordinateSequenceMathTransformer(transform);
        GeometryCSTransformer transformer = new GeometryCSTransformer(cstrs);
        return transformer.transform(geom);
    }

    public static Coordinate transform(Coordinate source, Coordinate dest, MathTransform transform) throws TransformException {
        JTS.ensureNonNull("source", source);
        JTS.ensureNonNull("transform", transform);
        if (dest == null) {
            dest = new Coordinate();
        }
        double[] array = new double[transform.getSourceDimensions()];
        JTS.copy(source, array);
        transform.transform(array, 0, array, 0, 1);
        switch (transform.getTargetDimensions()) {
            case 3: {
                dest.z = array[2];
            }
            case 2: {
                dest.y = array[1];
            }
            case 1: {
                dest.x = array[0];
            }
        }
        return dest;
    }

    public static Envelope toGeographic(Envelope envelope, CoordinateReferenceSystem crs) throws TransformException {
        MathTransform transform;
        if (CRS.equalsIgnoreMetadata(crs, DefaultGeographicCRS.WGS84)) {
            return envelope;
        }
        try {
            transform = CRS.findMathTransform(crs, DefaultGeographicCRS.WGS84, true);
        }
        catch (FactoryException exception) {
            throw new TransformPathNotFoundException(Errors.format(40, exception));
        }
        return JTS.transform(envelope, transform);
    }

    public static void xform(MathTransform transform, double[] src, double[] dest) throws TransformException {
        JTS.ensureNonNull("transform", transform);
        int sourceDim = transform.getSourceDimensions();
        int targetDim = transform.getTargetDimensions();
        if (targetDim != sourceDim) {
            throw new MismatchedDimensionException();
        }
        TransformException firstError = null;
        boolean startPointTransformed = false;
        for (int i = 0; i < src.length; i += sourceDim) {
            try {
                transform.transform(src, i, dest, i, 1);
                if (startPointTransformed) continue;
                startPointTransformed = true;
                for (int j = 0; j < i; ++j) {
                    System.arraycopy(dest, j, dest, i, targetDim);
                }
                continue;
            }
            catch (TransformException e) {
                if (firstError == null) {
                    firstError = e;
                }
                if (!startPointTransformed) continue;
                System.arraycopy(dest, i - targetDim, dest, i, targetDim);
            }
        }
        if (!startPointTransformed && firstError != null) {
            throw firstError;
        }
    }

    public static synchronized double orthodromicDistance(Coordinate p1, Coordinate p2, CoordinateReferenceSystem crs) throws TransformException {
        JTS.ensureNonNull("p1", p1);
        JTS.ensureNonNull("p2", p2);
        JTS.ensureNonNull("crs", crs);
        GeodeticCalculator gc = CALCULATORS.get(crs);
        if (gc == null) {
            gc = new GeodeticCalculator(crs);
            CALCULATORS.put(crs, gc);
        }
        assert (crs.equals(gc.getCoordinateReferenceSystem())) : crs;
        GeneralDirectPosition pos = POSITIONS[Math.min(POSITIONS.length - 1, crs.getCoordinateSystem().getDimension())];
        pos.setCoordinateReferenceSystem(crs);
        JTS.copy(p1, pos.ordinates);
        gc.setStartingPosition(pos);
        JTS.copy(p2, pos.ordinates);
        gc.setDestinationPosition(pos);
        return gc.getOrthodromicDistance();
    }

    public static void copy(Coordinate point, double[] ordinates) {
        JTS.ensureNonNull("point", point);
        JTS.ensureNonNull("ordinates", ordinates);
        switch (ordinates.length) {
            default: {
                Arrays.fill(ordinates, 3, ordinates.length, Double.NaN);
            }
            case 3: {
                ordinates[2] = point.z;
            }
            case 2: {
                ordinates[1] = point.y;
            }
            case 1: {
                ordinates[0] = point.x;
            }
            case 0: 
        }
    }

    public static Geometry shapeToGeometry(Shape shape, GeometryFactory factory) {
        JTS.ensureNonNull("shape", shape);
        JTS.ensureNonNull("factory", factory);
        PathIterator iterator = shape.getPathIterator(null, ShapeUtilities.getFlatness(shape));
        double[] buffer = new double[6];
        ArrayList coords = new ArrayList();
        ArrayList<LineString> lines = new ArrayList<LineString>();
        while (!iterator.isDone()) {
            switch (iterator.currentSegment(buffer)) {
                case 4: {
                    if (coords.isEmpty()) break;
                    coords.add(coords.get(0));
                    lines.add(factory.createLinearRing(coords.toArray(new Coordinate[coords.size()])));
                    coords.clear();
                    break;
                }
                case 0: {
                    if (!coords.isEmpty()) {
                        lines.add(factory.createLineString(coords.toArray(new Coordinate[coords.size()])));
                        coords.clear();
                    }
                }
                case 1: {
                    coords.add(new Coordinate(buffer[0], buffer[1]));
                    break;
                }
                default: {
                    throw new IllegalPathStateException();
                }
            }
            iterator.next();
        }
        if (!coords.isEmpty()) {
            lines.add(factory.createLineString(coords.toArray(new Coordinate[coords.size()])));
        }
        switch (lines.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (LineString)lines.get(0);
            }
        }
        return factory.createMultiLineString(GeometryFactory.toLineStringArray(lines));
    }

    public static Envelope2D getEnvelope2D(Envelope envelope, CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        JTS.ensureNonNull("envelope", envelope);
        JTS.ensureNonNull("crs", crs);
        SingleCRS crs2D = CRS.getHorizontalCRS(crs);
        if (crs2D == null) {
            throw new MismatchedDimensionException(Errors.format(38, crs));
        }
        return new Envelope2D(crs2D, envelope.getMinX(), envelope.getMinY(), envelope.getWidth(), envelope.getHeight());
    }

    public static Polygon toGeometry(Envelope envelope) {
        GeometryFactory gf = new GeometryFactory();
        return gf.createPolygon(gf.createLinearRing(new Coordinate[]{new Coordinate(envelope.getMinX(), envelope.getMinY()), new Coordinate(envelope.getMaxX(), envelope.getMinY()), new Coordinate(envelope.getMaxX(), envelope.getMaxY()), new Coordinate(envelope.getMinX(), envelope.getMaxY()), new Coordinate(envelope.getMinX(), envelope.getMinY())}), null);
    }

    public static Polygon toGeometry(org.opengis.geometry.Envelope env) {
        GeometryFactory gf = new GeometryFactory();
        Coordinate[] coordinates = new Coordinate[]{new Coordinate(env.getMinimum(0), env.getMinimum(1)), new Coordinate(env.getMinimum(0), env.getMaximum(1)), new Coordinate(env.getMaximum(0), env.getMaximum(1)), new Coordinate(env.getMaximum(0), env.getMinimum(1)), new Coordinate(env.getMinimum(0), env.getMinimum(1))};
        LinearRing ring = gf.createLinearRing(coordinates);
        return gf.createPolygon(ring, new LinearRing[0]);
    }

    public static JTSEnvelope2D toEnvelope(Geometry geom) {
        if (geom == null) {
            return null;
        }
        String srsName = null;
        Object userData = geom.getUserData();
        if (userData != null && userData instanceof String) {
            srsName = (String)userData;
        } else if (geom.getSRID() > 0) {
            srsName = "EPSG:" + geom.getSRID();
        }
        CoordinateReferenceSystem crs = null;
        if (userData != null && userData instanceof CoordinateReferenceSystem) {
            crs = (CoordinateReferenceSystem)userData;
        } else if (srsName != null) {
            try {
                crs = CRS.decode(srsName);
            }
            catch (NoSuchAuthorityCodeException e) {
            }
            catch (FactoryException e) {
                // empty catch block
            }
        }
        return new JTSEnvelope2D(geom.getEnvelopeInternal(), crs);
    }

    public static Polygon toGeometry(BoundingBox envelope) {
        GeometryFactory gf = new GeometryFactory();
        return gf.createPolygon(gf.createLinearRing(new Coordinate[]{new Coordinate(envelope.getMinX(), envelope.getMinY()), new Coordinate(envelope.getMaxX(), envelope.getMinY()), new Coordinate(envelope.getMaxX(), envelope.getMaxY()), new Coordinate(envelope.getMinX(), envelope.getMaxY()), new Coordinate(envelope.getMinX(), envelope.getMinY())}), null);
    }

    public static void checkCoordinatesRange(Geometry geom, CoordinateReferenceSystem crs) throws ProjectionException {
        boolean yUnbounded;
        CoordinateSystemAxis x = crs.getCoordinateSystem().getAxis(0);
        CoordinateSystemAxis y = crs.getCoordinateSystem().getAxis(1);
        boolean xUnbounded = Double.isInfinite(x.getMinimumValue()) && Double.isInfinite(x.getMaximumValue());
        boolean bl = yUnbounded = Double.isInfinite(y.getMinimumValue()) && Double.isInfinite(y.getMaximumValue());
        if (xUnbounded && yUnbounded) {
            return;
        }
        Coordinate[] c = geom.getCoordinates();
        for (int i = 0; i < c.length; ++i) {
            if (!xUnbounded && (c[i].x < x.getMinimumValue() || c[i].x > x.getMaximumValue())) {
                throw new ProjectionException(c[i].x + " outside of (" + x.getMinimumValue() + "," + x.getMaximumValue() + ")");
            }
            if (yUnbounded || !(c[i].y < y.getMinimumValue()) && !(c[i].y > y.getMaximumValue())) continue;
            throw new ProjectionException(c[i].y + " outside of (" + y.getMinimumValue() + "," + y.getMaximumValue() + ")");
        }
    }

    public static void setCRS(Geometry geom, CoordinateReferenceSystem crs) {
        ArgumentChecks.ensureNonNull("geometry", geom);
        if (crs == null) {
            return;
        }
        Object userData = geom.getUserData();
        if (userData instanceof CoordinateReferenceSystem) {
            userData = crs;
        } else if (userData instanceof Map) {
            Map values = (Map)userData;
            values.put(HintsPending.JTS_GEOMETRY_CRS, crs);
            userData = values;
        }
        if (userData == null) {
            userData = crs;
        }
        geom.setUserData(userData);
    }

    public static CoordinateReferenceSystem findCoordinateReferenceSystem(Geometry geom) throws NoSuchAuthorityCodeException, FactoryException {
        int srid;
        Map values;
        Object candidate;
        if (geom == null) {
            return null;
        }
        CoordinateReferenceSystem crs = null;
        Object userData = geom.getUserData();
        if (userData instanceof CoordinateReferenceSystem) {
            crs = (CoordinateReferenceSystem)userData;
        } else if (userData instanceof Map && (candidate = (values = (Map)userData).get(HintsPending.JTS_GEOMETRY_CRS)) instanceof CoordinateReferenceSystem) {
            crs = (CoordinateReferenceSystem)candidate;
        }
        if (crs == null && (srid = geom.getSRID()) != 0 && srid != -1) {
            String srs = SRIDGenerator.toSRS(srid, SRIDGenerator.Version.V1);
            crs = CRS.decode(srs);
        }
        return crs;
    }

    public static void zMinMax(CoordinateSequence cs, double[] target) {
        if (cs.getDimension() < 3) {
            return;
        }
        boolean validZFound = false;
        double zmin = Double.NaN;
        double zmax = Double.NaN;
        int size = cs.size();
        for (int t = size - 1; t >= 0; --t) {
            double z = cs.getOrdinate(t, 2);
            if (Double.isNaN(z)) continue;
            if (validZFound) {
                if (z < zmin) {
                    zmin = z;
                }
                if (!(z > zmax)) continue;
                zmax = z;
                continue;
            }
            validZFound = true;
            zmin = z;
            zmax = z;
        }
        if (!Double.isNaN(zmin)) {
            target[0] = zmin;
        }
        if (!Double.isNaN(zmax)) {
            target[1] = zmax;
        }
    }

    public static LinearRing reverseRing(LinearRing lr) {
        GeometryFactory gf = new GeometryFactory();
        int numPoints = lr.getNumPoints() - 1;
        Coordinate[] newCoords = new Coordinate[numPoints + 1];
        for (int t = numPoints; t >= 0; --t) {
            newCoords[t] = lr.getCoordinateN(numPoints - t);
        }
        return gf.createLinearRing(newCoords);
    }

    public static <T extends Geometry> T ensureClockWise(T g2) {
        if (!(g2 instanceof MultiPolygon) && !(g2 instanceof Polygon)) {
            return g2;
        }
        GeometryFactory gf = new GeometryFactory();
        boolean isMultiPolygon = false;
        int nbPolygon = 1;
        if (g2 instanceof MultiPolygon) {
            nbPolygon = g2.getNumGeometries();
            isMultiPolygon = true;
        }
        Polygon[] ps = new Polygon[nbPolygon];
        for (int i = 0; i < nbPolygon; ++i) {
            Polygon p = isMultiPolygon ? (Polygon)g2.getGeometryN(i) : (Polygon)g2;
            LinearRing[] holes = new LinearRing[p.getNumInteriorRing()];
            Coordinate[] coords = p.getExteriorRing().getCoordinates();
            LinearRing outer = CGAlgorithms.isCCW(coords) ? JTS.reverseRing((LinearRing)p.getExteriorRing()) : (LinearRing)p.getExteriorRing();
            int tt = p.getNumInteriorRing();
            for (int t = 0; t < tt; ++t) {
                coords = p.getInteriorRingN(t).getCoordinates();
                holes[t] = !CGAlgorithms.isCCW(coords) ? JTS.reverseRing((LinearRing)p.getInteriorRingN(t)) : (LinearRing)p.getInteriorRingN(t);
            }
            ps[i] = gf.createPolygon(outer, holes);
        }
        if (isMultiPolygon) {
            return (T)gf.createMultiPolygon(ps);
        }
        return (T)ps[0];
    }

    public static <T extends Geometry> T ensureCounterClockWise(T g2) {
        if (!(g2 instanceof MultiPolygon) && !(g2 instanceof Polygon)) {
            return g2;
        }
        GeometryFactory gf = new GeometryFactory();
        boolean isMultiPolygon = false;
        int nbPolygon = 1;
        if (g2 instanceof MultiPolygon) {
            nbPolygon = g2.getNumGeometries();
            isMultiPolygon = true;
        }
        Polygon[] ps = new Polygon[nbPolygon];
        for (int i = 0; i < nbPolygon; ++i) {
            Polygon p = isMultiPolygon ? (Polygon)g2.getGeometryN(i) : (Polygon)g2;
            LinearRing[] holes = new LinearRing[p.getNumInteriorRing()];
            Coordinate[] coords = p.getExteriorRing().getCoordinates();
            LinearRing outer = CGAlgorithms.isCCW(coords) ? (LinearRing)p.getExteriorRing() : JTS.reverseRing((LinearRing)p.getExteriorRing());
            int tt = p.getNumInteriorRing();
            for (int t = 0; t < tt; ++t) {
                coords = p.getInteriorRingN(t).getCoordinates();
                holes[t] = !CGAlgorithms.isCCW(coords) ? (LinearRing)p.getInteriorRingN(t) : JTS.reverseRing((LinearRing)p.getInteriorRingN(t));
            }
            ps[i] = gf.createPolygon(outer, holes);
        }
        if (isMultiPolygon) {
            return (T)gf.createMultiPolygon(ps);
        }
        return (T)ps[0];
    }

    public static <T extends Geometry> T ensureClockWise3D(T g2) {
        if (!(g2 instanceof MultiPolygon) && !(g2 instanceof Polygon)) {
            return g2;
        }
        GeometryFactory gf = new GeometryFactory();
        boolean isMultiPolygon = false;
        int nbPolygon = 1;
        if (g2 instanceof MultiPolygon) {
            nbPolygon = g2.getNumGeometries();
            isMultiPolygon = true;
        }
        Polygon[] ps = new Polygon[nbPolygon];
        for (int i = 0; i < nbPolygon; ++i) {
            Polygon p = isMultiPolygon ? (Polygon)g2.getGeometryN(i) : (Polygon)g2;
            LinearRing[] holes = new LinearRing[p.getNumInteriorRing()];
            Coordinate[] coords = p.getExteriorRing().getCoordinates();
            LinearRing outer = JTS.isCCW3D(coords) ? JTS.reverseRing((LinearRing)p.getExteriorRing()) : (LinearRing)p.getExteriorRing();
            int tt = p.getNumInteriorRing();
            for (int t = 0; t < tt; ++t) {
                coords = p.getInteriorRingN(t).getCoordinates();
                holes[t] = !JTS.isCCW3D(coords) ? JTS.reverseRing((LinearRing)p.getInteriorRingN(t)) : (LinearRing)p.getInteriorRingN(t);
            }
            ps[i] = gf.createPolygon(outer, holes);
        }
        if (isMultiPolygon) {
            return (T)gf.createMultiPolygon(ps);
        }
        return (T)ps[0];
    }

    public static <T extends Geometry> T ensureCounterClockWise3D(T g2) {
        if (!(g2 instanceof MultiPolygon) && !(g2 instanceof Polygon)) {
            return g2;
        }
        GeometryFactory gf = new GeometryFactory();
        boolean isMultiPolygon = false;
        int nbPolygon = 1;
        if (g2 instanceof MultiPolygon) {
            nbPolygon = g2.getNumGeometries();
            isMultiPolygon = true;
        }
        Polygon[] ps = new Polygon[nbPolygon];
        for (int i = 0; i < nbPolygon; ++i) {
            Polygon p = isMultiPolygon ? (Polygon)g2.getGeometryN(i) : (Polygon)g2;
            LinearRing[] holes = new LinearRing[p.getNumInteriorRing()];
            Coordinate[] coords = p.getExteriorRing().getCoordinates();
            LinearRing outer = JTS.isCCW3D(coords) ? (LinearRing)p.getExteriorRing() : JTS.reverseRing((LinearRing)p.getExteriorRing());
            int tt = p.getNumInteriorRing();
            for (int t = 0; t < tt; ++t) {
                coords = p.getInteriorRingN(t).getCoordinates();
                holes[t] = !JTS.isCCW3D(coords) ? (LinearRing)p.getInteriorRingN(t) : JTS.reverseRing((LinearRing)p.getInteriorRingN(t));
            }
            ps[i] = gf.createPolygon(outer, holes);
        }
        if (isMultiPolygon) {
            return (T)gf.createMultiPolygon(ps);
        }
        return (T)ps[0];
    }

    public static boolean isCCW3D(Coordinate[] ring) {
        int nbCoords = ring.length - 1;
        double buff = 0.0;
        for (int i = 1; i < nbCoords; ++i) {
            Vector3d v1 = new Vector3d(ring[i].x - ring[i - 1].x, ring[i].y - ring[i - 1].y, ring[i].z - ring[i - 1].z);
            Vector3d v2 = new Vector3d(ring[i + 1].x - ring[i].x, ring[i + 1].y - ring[i].y, ring[i + 1].z - ring[i].z);
            v1.cross(v1, v2);
            v1.normalize();
            buff += v1.x + v1.y + v1.z;
        }
        return buff > 0.0;
    }

    public static CoordinateReferenceSystem getCommonCRS(Geometry geom1, Geometry geom2) throws FactoryException, TransformException {
        CoordinateReferenceSystem resultCRS = null;
        CoordinateReferenceSystem crs1 = JTS.findCoordinateReferenceSystem(geom1);
        CoordinateReferenceSystem crs2 = JTS.findCoordinateReferenceSystem(geom2);
        if (crs1 != null) {
            resultCRS = crs1;
        } else if (crs2 != null) {
            resultCRS = crs2;
        }
        return resultCRS;
    }

    public static Geometry convertToCRS(Geometry geom, CoordinateReferenceSystem crsTarget) throws MismatchedDimensionException, TransformException, FactoryException {
        ArgumentChecks.ensureNonNull("geometry", geom);
        ArgumentChecks.ensureNonNull("crsTarget", crsTarget);
        CoordinateReferenceSystem crsGeom = JTS.findCoordinateReferenceSystem(geom);
        if (crsGeom == null) {
            return geom;
        }
        MathTransform mt = CRS.findMathTransform(crsGeom, crsTarget);
        Geometry result = JTS.transform(geom, mt);
        JTS.setCRS(result, crsTarget);
        return result;
    }

    public static boolean isConversionNeeded(Geometry geom1, Geometry geom2) throws FactoryException {
        CoordinateReferenceSystem crs1 = JTS.findCoordinateReferenceSystem(geom1);
        CoordinateReferenceSystem crs2 = JTS.findCoordinateReferenceSystem(geom2);
        return crs1 != null && crs2 != null && !crs1.equals(crs2);
    }

    static {
        for (int i = 0; i < POSITIONS.length; ++i) {
            JTS.POSITIONS[i] = new GeneralDirectPosition(i);
        }
        CALCULATORS = new HashMap<CoordinateReferenceSystem, GeodeticCalculator>();
    }
}

