/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml.v321;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import org.geotoolkit.gml.xml.FeatureCollection;
import org.geotoolkit.gml.xml.v321.AbstractFeatureType;
import org.geotoolkit.gml.xml.v321.BoundingShapeType;
import org.geotoolkit.gml.xml.v321.DirectPositionType;
import org.geotoolkit.gml.xml.v321.EnvelopeType;
import org.geotoolkit.gml.xml.v321.FeatureArrayPropertyType;
import org.geotoolkit.gml.xml.v321.FeatureCollectionType;
import org.geotoolkit.gml.xml.v321.FeaturePropertyType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="AbstractFeatureCollectionType", propOrder={"featureMember", "featureMembers"})
@XmlSeeAlso(value={FeatureCollectionType.class})
public abstract class AbstractFeatureCollectionType
extends AbstractFeatureType
implements FeatureCollection {
    private List<FeaturePropertyType> featureMember;
    private FeatureArrayPropertyType featureMembers;

    public AbstractFeatureCollectionType() {
    }

    public AbstractFeatureCollectionType(String id) {
        super(id, null, null);
    }

    public AbstractFeatureCollectionType(String id, String name, String description, List<FeaturePropertyType> featureMember) {
        super(id, name, description);
        this.featureMember = featureMember;
    }

    public List<FeaturePropertyType> getFeatureMember() {
        if (this.featureMember == null) {
            this.featureMember = new ArrayList<FeaturePropertyType>();
        }
        return this.featureMember;
    }

    public FeatureArrayPropertyType getFeatureMembers() {
        return this.featureMembers;
    }

    public void setFeatureMembers(FeatureArrayPropertyType value) {
        this.featureMembers = value;
    }

    @Override
    public void computeBounds() {
        double minx = Double.MAX_VALUE;
        double miny = Double.MAX_VALUE;
        double maxx = -1.7976931348623157E308;
        double maxy = -1.7976931348623157E308;
        for (FeaturePropertyType memberProp : this.featureMember) {
            BoundingShapeType bound;
            AbstractFeatureType member = memberProp.getAbstractFeature();
            if (member == null || (bound = member.getBoundedBy()) == null || bound.getEnvelope() == null) continue;
            if (bound.getEnvelope().getLowerCorner() != null && bound.getEnvelope().getLowerCorner().getValue() != null && bound.getEnvelope().getLowerCorner().getValue().size() > 1) {
                List<Double> lower = bound.getEnvelope().getLowerCorner().getValue();
                if (lower.get(0) < minx) {
                    minx = lower.get(0);
                }
                if (lower.get(1) < miny) {
                    miny = lower.get(1);
                }
            }
            if (bound.getEnvelope().getUpperCorner() == null || bound.getEnvelope().getUpperCorner().getValue() == null || bound.getEnvelope().getUpperCorner().getValue().size() <= 1) continue;
            List<Double> upper = bound.getEnvelope().getUpperCorner().getValue();
            if (upper.get(0) > maxx) {
                maxx = upper.get(0);
            }
            if (!(upper.get(1) > maxy)) continue;
            maxy = upper.get(1);
        }
        if (minx == Double.MAX_VALUE) {
            minx = -180.0;
        }
        if (miny == Double.MAX_VALUE) {
            miny = -90.0;
        }
        if (maxx == -1.7976931348623157E308) {
            maxx = 180.0;
        }
        if (maxy == -1.7976931348623157E308) {
            maxy = 90.0;
        }
        EnvelopeType env = new EnvelopeType(new DirectPositionType(minx, miny), new DirectPositionType(maxx, maxy), "EPSG:4326");
        env.setSrsDimension(2);
        env.setAxisLabels("Y X");
        this.setBoundedBy(new BoundingShapeType(env));
    }
}

