/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BinaryOperatorNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.CharConstantNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class ConcatenationOperatorNode
extends BinaryOperatorNode {
    public void init(Object object, Object object2) {
        super.init(object, object2, "||", "concatenate", "org.apache.derby.iapi.types.ConcatableDataValue", "org.apache.derby.iapi.types.ConcatableDataValue");
    }

    ValueNode evaluateConstantExpressions() throws StandardException {
        if (this.leftOperand instanceof CharConstantNode && this.rightOperand instanceof CharConstantNode) {
            CharConstantNode charConstantNode = (CharConstantNode)this.leftOperand;
            CharConstantNode charConstantNode2 = (CharConstantNode)this.rightOperand;
            StringDataValue stringDataValue = (StringDataValue)charConstantNode.getValue();
            StringDataValue stringDataValue2 = (StringDataValue)charConstantNode2.getValue();
            StringDataValue stringDataValue3 = (StringDataValue)this.getTypeServices().getNull();
            stringDataValue3.concatenate(stringDataValue, stringDataValue2, stringDataValue3);
            return (ValueNode)this.getNodeFactory().getNode(61, stringDataValue3.getString(), this.getContextManager());
        }
        return this;
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List list) throws StandardException {
        DataTypeDescriptor dataTypeDescriptor;
        Object object;
        this.leftOperand = this.leftOperand.bindExpression(fromList, subqueryList, list);
        this.rightOperand = this.rightOperand.bindExpression(fromList, subqueryList, list);
        if (this.leftOperand.requiresTypeFromContext()) {
            if (this.rightOperand.requiresTypeFromContext()) {
                throw StandardException.newException("42X35", this.operator);
            }
            object = this.rightOperand.getTypeId().isBitTypeId() ? (this.rightOperand.getTypeId().isBlobTypeId() ? TypeId.getBuiltInTypeId(2004) : TypeId.getBuiltInTypeId(-3)) : (this.rightOperand.getTypeId().isClobTypeId() ? TypeId.getBuiltInTypeId(2005) : TypeId.getBuiltInTypeId(12));
            this.leftOperand.setType(new DataTypeDescriptor((TypeId)object, true));
            if (this.rightOperand.getTypeId().isStringTypeId()) {
                this.leftOperand.setCollationInfo(this.rightOperand.getTypeServices());
            }
        }
        if (this.rightOperand.requiresTypeFromContext()) {
            object = this.leftOperand.getTypeId().isBitTypeId() ? (this.leftOperand.getTypeId().isBlobTypeId() ? TypeId.getBuiltInTypeId(2004) : TypeId.getBuiltInTypeId(-3)) : (this.leftOperand.getTypeId().isClobTypeId() ? TypeId.getBuiltInTypeId(2005) : TypeId.getBuiltInTypeId(12));
            this.rightOperand.setType(new DataTypeDescriptor((TypeId)object, true));
            if (this.leftOperand.getTypeId().isStringTypeId()) {
                this.rightOperand.setCollationInfo(this.leftOperand.getTypeServices());
            }
        }
        if (this.leftOperand.getTypeId().userType()) {
            this.leftOperand = this.leftOperand.genSQLJavaSQLTree();
        }
        if (this.rightOperand.getTypeId().userType()) {
            this.rightOperand = this.rightOperand.genSQLJavaSQLTree();
        }
        object = this.leftOperand.getTypeCompiler();
        if (!this.leftOperand.getTypeId().isStringTypeId() && !this.leftOperand.getTypeId().isBitTypeId()) {
            dataTypeDescriptor = DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, true, object.getCastToCharWidth(this.leftOperand.getTypeServices()));
            this.leftOperand = (ValueNode)this.getNodeFactory().getNode(60, this.leftOperand, dataTypeDescriptor, this.getContextManager());
            this.leftOperand.setCollationUsingCompilationSchema();
            ((CastNode)this.leftOperand).bindCastNodeOnly();
        }
        object = this.rightOperand.getTypeCompiler();
        if (!this.rightOperand.getTypeId().isStringTypeId() && !this.rightOperand.getTypeId().isBitTypeId()) {
            dataTypeDescriptor = DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, true, object.getCastToCharWidth(this.rightOperand.getTypeServices()));
            this.rightOperand = (ValueNode)this.getNodeFactory().getNode(60, this.rightOperand, dataTypeDescriptor, this.getContextManager());
            this.rightOperand.setCollationUsingCompilationSchema();
            ((CastNode)this.rightOperand).bindCastNodeOnly();
        }
        object = this.leftOperand.getTypeCompiler();
        this.setType(this.resolveConcatOperation(this.leftOperand.getTypeServices(), this.rightOperand.getTypeServices()));
        this.setLeftRightInterfaceType(object.interfaceName());
        return this.evaluateConstantExpressions();
    }

    private DataTypeDescriptor resolveConcatOperation(DataTypeDescriptor dataTypeDescriptor, DataTypeDescriptor dataTypeDescriptor2) throws StandardException {
        TypeId typeId = dataTypeDescriptor.getTypeId();
        TypeId typeId2 = dataTypeDescriptor2.getTypeId();
        if (!typeId.isConcatableTypeId() || !typeId2.isConcatableTypeId() || typeId2.isBitTypeId() && typeId.isStringTypeId() || typeId.isBitTypeId() && typeId2.isStringTypeId()) {
            throw StandardException.newException("42884", (Object)"||", (Object)"FUNCTION");
        }
        String string = typeId.typePrecedence() >= typeId2.typePrecedence() ? dataTypeDescriptor.getTypeName() : dataTypeDescriptor2.getTypeName();
        int n = dataTypeDescriptor.getMaximumWidth() + dataTypeDescriptor2.getMaximumWidth();
        if (typeId.getJDBCTypeId() == 1 || typeId.getJDBCTypeId() == -2) {
            switch (typeId2.getJDBCTypeId()) {
                case -2: 
                case 1: {
                    if (n <= 254) break;
                    if (typeId2.getJDBCTypeId() == 1) {
                        string = "VARCHAR";
                        break;
                    }
                    string = "VARCHAR () FOR BIT DATA";
                    break;
                }
                case -3: 
                case 12: {
                    if (n <= 4000) break;
                    if (typeId2.getJDBCTypeId() == 12) {
                        string = "LONG VARCHAR";
                        break;
                    }
                    string = "LONG VARCHAR FOR BIT DATA";
                    break;
                }
                case 2004: 
                case 2005: {
                    n = ConcatenationOperatorNode.clobBlobHandling(dataTypeDescriptor2, dataTypeDescriptor);
                }
            }
        } else if (typeId.getJDBCTypeId() == 12) {
            switch (typeId2.getJDBCTypeId()) {
                case 1: 
                case 12: {
                    if (n <= 4000) break;
                    string = "LONG VARCHAR";
                    break;
                }
                case 2005: {
                    n = ConcatenationOperatorNode.clobBlobHandling(dataTypeDescriptor2, dataTypeDescriptor);
                }
            }
        } else if (typeId.getJDBCTypeId() == -3) {
            switch (typeId2.getJDBCTypeId()) {
                case -3: 
                case -2: {
                    if (n <= 4000) break;
                    string = "LONG VARCHAR FOR BIT DATA";
                    break;
                }
                case 2004: {
                    n = ConcatenationOperatorNode.clobBlobHandling(dataTypeDescriptor2, dataTypeDescriptor);
                }
            }
        } else if (typeId.getJDBCTypeId() == 2005 || typeId.getJDBCTypeId() == 2004) {
            n = ConcatenationOperatorNode.clobBlobHandling(dataTypeDescriptor, dataTypeDescriptor2);
        } else if (typeId2.getJDBCTypeId() == 2005 || typeId2.getJDBCTypeId() == 2004) {
            n = ConcatenationOperatorNode.clobBlobHandling(dataTypeDescriptor2, dataTypeDescriptor);
        }
        if (string.equals("LONG VARCHAR")) {
            n = 32700;
        } else if (string.equals("LONG VARCHAR FOR BIT DATA")) {
            n = 32700;
        }
        boolean bl = dataTypeDescriptor.isNullable() || dataTypeDescriptor2.isNullable();
        DataTypeDescriptor dataTypeDescriptor3 = new DataTypeDescriptor(TypeId.getBuiltInTypeId(string), bl, n);
        dataTypeDescriptor3 = dataTypeDescriptor.getCollationDerivation() != dataTypeDescriptor2.getCollationDerivation() || dataTypeDescriptor.getCollationType() != dataTypeDescriptor2.getCollationType() ? dataTypeDescriptor3.getCollatedType(dataTypeDescriptor3.getCollationDerivation(), 0) : dataTypeDescriptor3.getCollatedType(dataTypeDescriptor.getCollationType(), dataTypeDescriptor.getCollationDerivation());
        return dataTypeDescriptor3;
    }

    private static int clobBlobHandling(DataTypeDescriptor dataTypeDescriptor, DataTypeDescriptor dataTypeDescriptor2) throws StandardException {
        int n = dataTypeDescriptor2.getTypeId().getJDBCTypeId() == -1 || dataTypeDescriptor2.getTypeId().getJDBCTypeId() == -4 ? dataTypeDescriptor.getMaximumWidth() + 32768 : dataTypeDescriptor.getMaximumWidth() + dataTypeDescriptor2.getMaximumWidth();
        if (n < 1) {
            return Integer.MAX_VALUE;
        }
        return n;
    }
}

