/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import org.geotoolkit.io.ExpandedTabWriter;
import org.geotoolkit.lang.Static;
import org.geotoolkit.resources.Errors;

public final class Exceptions
extends Static {
    private static final int TAB_WIDTH = 4;

    private Exceptions() {
    }

    public static boolean isValidMessage(String string) {
        if (string == null) {
            return false;
        }
        return !(string = string.trim()).isEmpty() && !string.equalsIgnoreCase("null");
    }

    public static <T extends Throwable> T setMessage(T t, String string, boolean bl) {
        Object object;
        if (bl && (object = t.getLocalizedMessage()) != null && !((String)(object = ((String)object).trim())).isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder(string.trim());
            int n = stringBuilder.length();
            if (n != 0 && Character.isLetterOrDigit(stringBuilder.charAt(n - 1))) {
                stringBuilder.append(". ");
            }
            string = stringBuilder.append((String)object).toString();
        }
        try {
            object = (Throwable)t.getClass().getConstructor(String.class).newInstance(string);
        }
        catch (Exception exception) {
            return t;
        }
        ((Throwable)object).setStackTrace(t.getStackTrace());
        return (T)object;
    }

    public static String formatChainedMessages(String string, Throwable throwable) {
        HashSet<String> hashSet = null;
        String string2 = null;
        StringBuilder stringBuilder = null;
        while (throwable != null) {
            SQLException sQLException;
            String string3 = throwable.getLocalizedMessage();
            if (string3 != null && !(string3 = string3.trim()).isEmpty()) {
                if (stringBuilder == null) {
                    hashSet = new HashSet<String>();
                    stringBuilder = new StringBuilder();
                    string2 = System.getProperty("line.separator", "\n");
                    if (string != null && !(string = string.trim()).isEmpty()) {
                        stringBuilder.append(string);
                        hashSet.add(string);
                        int n = 0;
                        while ((n = string.indexOf(58, n)) >= 0) {
                            hashSet.add(string.substring(++n).trim());
                        }
                    }
                }
                if (hashSet.add(string3)) {
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append(string2);
                    }
                    stringBuilder.append(string3);
                }
            }
            if (throwable instanceof SQLException && (sQLException = ((SQLException)throwable).getNextException()) != null) {
                throwable = sQLException;
                continue;
            }
            throwable = throwable.getCause();
        }
        if (stringBuilder != null) {
            string = stringBuilder.toString();
        }
        return string;
    }

    public static String formatStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(new ExpandedTabWriter(stringWriter, 4)));
        return stringWriter.toString();
    }

    public static void paintStackTrace(Graphics2D graphics2D, Rectangle rectangle, Throwable throwable) {
        int n;
        GlyphVector glyphVector;
        Rectangle2D rectangle2D;
        int n2;
        String string = Exceptions.formatStackTrace(throwable);
        double d = 0.0;
        double d2 = 0.0;
        ArrayList<GlyphVector> arrayList = new ArrayList<GlyphVector>();
        ArrayList<Rectangle2D> arrayList2 = new ArrayList<Rectangle2D>();
        int n3 = string.length();
        Font font = graphics2D.getFont();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        int n4 = 0;
        while (n4 < n3) {
            double d3;
            int n5 = string.indexOf(13, n4);
            n2 = string.indexOf(10, n4);
            if (n5 < 0) {
                n5 = n3;
            }
            if (n2 < 0) {
                n2 = n3;
            }
            if ((d3 = (rectangle2D = (glyphVector = font.createGlyphVector(fontRenderContext, string.substring(n4, n = Math.min(n5, n2)))).getVisualBounds()).getWidth()) > d) {
                d = d3;
            }
            d2 += rectangle2D.getHeight();
            arrayList.add(glyphVector);
            arrayList2.add(rectangle2D);
            n4 = (Math.abs(n5 - n2) <= 1 ? Math.max(n5, n2) : n) + 1;
        }
        float f = (float)rectangle.x + (float)(0.5 * Math.max(0.0, (double)rectangle.width - d));
        float f2 = (float)rectangle.y + (float)(0.5 * Math.max(0.0, (double)rectangle.height - d2));
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            glyphVector = (GlyphVector)arrayList.get(n);
            rectangle2D = (Rectangle2D)arrayList2.get(n);
            f2 = (float)((double)f2 + rectangle2D.getHeight());
            graphics2D.drawGlyphVector(glyphVector, f, f2);
        }
    }

    public static void show(Component component, Throwable throwable) throws UnsupportedOperationException {
        Exceptions.show(new Object[]{component, throwable});
    }

    public static void show(Component component, Throwable throwable, String string) throws UnsupportedOperationException {
        Exceptions.show(new Object[]{component, throwable, string});
    }

    private static void show(Object[] objectArray) throws UnsupportedOperationException {
        Class[] classArray = new Class[objectArray.length];
        switch (classArray.length) {
            default: {
                classArray[2] = String.class;
            }
            case 2: {
                classArray[1] = Throwable.class;
            }
            case 1: {
                classArray[0] = Component.class;
            }
            case 0: 
        }
        try {
            Class.forName("org.geotoolkit.internal.swing.ExceptionMonitor").getMethod("show", classArray).invoke(null, objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UnsupportedOperationException(Errors.format(118, "geotk-widgets-swing"), classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new UndeclaredThrowableException(throwable);
        }
    }
}

